/* 
 * Code for dealing with dynamic loading. This code is 
 * general native support for the interpreter. 
 */

#include "toba.h"
#include "runtime.h"

#include "java_lang_Class.h"
#include "java_lang_String.h"

#ifdef OPTION_JIT
#include "toba_runtime_SystemClassLoader.h"
extern struct in_java_lang_ClassLoader *system_loader;
#endif /* OPTION_JIT */

void loader_init()
{
    /* Go ahead and initialize the binary loader.  If we don't have jit
     * support, this registers additional classes we need to be able to
     * find with forName. */
    binary_loader_init();

#ifdef OPTION_JIT
    /* These only make sense if the jit is available. */
    class_loader_init();
    codegen_init();
#endif /* OPTION_JIT */
}
