/* sthreads_scout.h -- prototypes and structures for Scout thread interface */

#ifndef _sthreads_h_
#define _sthreads_h_

#ifdef SCOUT
#include <scout/semaphore.h>
#include <scout/thread.h>
#include <machine/thread.h>
#else /* SCOUT */
#include "scout_semaphore.h"
#include "scout_thread.h"
#endif /* SCOUT */

struct sthread_mutex {
    struct Semaphore mutex;
    Thread owner;
};

struct sthread_cond {
    struct Semaphore c;
    int nsignals, nwaiting;
};

/* per-thread control block */
typedef struct tcb {
    struct mythread mythread;		/* toba per-thread stuff */
    struct in_java_lang_Thread *obj;	/* the Thread object */
    void *thread;                       /* Scout thread struct */
    struct Semaphore suspend;		/* For suspending thread */
    struct Semaphore synch;		/* For syncing w/ suspender */
    int state;				/* thread state */
    int defer;
    int do_suspend;
    int do_async_exception;
    int got_async_exception;
    void *tramparg;			/* trampoline argument */
} tcb;

/* thread states */
#define TS_RUNNING		1
#define TS_SUSPENDED		2

/*
 * We need larger stacks than the default Scout thread stack size.
 */
#define STHREAD_STACK_SIZE 128*MIN_USEFUL_STACK_SIZE

void sthread_init();
void sthread_launch(void (*routine)(AnyType arg), void *p);
void sthread_got_exception(void);
void sthread_create(struct in_java_lang_Thread *o);
struct tcb *sthread_current();
void sthread_yield();
void sthread_sleep(Long millis);
void sthread_suspend(struct in_java_lang_Thread *o);
void sthread_resume(struct in_java_lang_Thread *o);
void sthread_setpriority(struct in_java_lang_Thread *o, int priority);
void sthread_stop(struct in_java_lang_Thread *o, Object e);
void sthread_exit();
void sthread_dontkill_start(struct mythread *thr);
void sthread_dontkill_end(struct mythread *thr);
int sthread_dontkill_p(struct mythread *thr);
void sthread_mutex_init(struct sthread_mutex *m);
void sthread_mutex_lock(struct sthread_mutex *m);
void sthread_mutex_unlock(struct sthread_mutex *m);
void sthread_mutex_destroy(struct sthread_mutex *m);
void sthread_cond_init(struct sthread_cond *c);
void sthread_cond_wait(struct sthread_cond *c, struct sthread_mutex *m, 
		       Long timeout);
void sthread_cond_signal(struct sthread_cond *c);
void sthread_cond_broadcast(struct sthread_cond *c);
void sthread_cond_destroy(struct sthread_cond *c);

void sthread_preemption_point();

extern int singlethreaded;
#endif /* _sthreads_h_ */
