/*  sthreads_sol.h -- sthreads interface to Solaris threads package  */

#ifndef h_sthreads
#define h_sthreads

#include <setjmp.h>
#include <thread.h>
#include <synch.h>

struct sthread_mutex {
    mutex_t mutex;
};

struct sthread_cond {
    int nsignals;
    int nwaiting;
    cond_t cond;
};

/* per-thread control block */
typedef struct tcb {
    struct mythread mythread;		/* per-thread information */
    struct in_java_lang_Thread *obj;	/* the Thread object */
    thread_t thread;			/* solaris thread id */
    sema_t synch;			/* synchronization */
    sema_t suspend;			/* block on this to suspend */
    sema_t lock;			/* lock on tcb */
    int state;				/* thread state */

    int defer;				/* non-zero if we should defer sigs */
    int sig;				/* signal causing exception */
    int got_async_exception;		/* over async exception quota of 1 */
    int defer_suspend;			/* a suspend has been deferred */
    int defer_async_exception;		/* an exception has been deferred */

    void *tramparg;                     /* Per-thread space for a trampoline */
} tcb;

/* thread states */
#define TS_RUNNING		1
#define TS_SUSPENDED		2

void sthread_init();
void sthread_launch(void (*routine)(), void *arg);
void sthread_got_exception(void);
void sthread_create(struct in_java_lang_Thread *o);
struct tcb *sthread_current();
void sthread_yield();
void sthread_sleep(Long millis);
void sthread_suspend(struct in_java_lang_Thread *o);
void sthread_resume(struct in_java_lang_Thread *o);
void sthread_setpriority(struct in_java_lang_Thread *o, int priority);
void sthread_stop(struct in_java_lang_Thread *o, Object e);
void sthread_exit();
void sthread_dontkill_start(struct mythread *thr);
void sthread_dontkill_end(struct mythread *thr);
int sthread_dontkill_p(struct mythread *thr);
void sthread_mutex_init(struct sthread_mutex *m);
void sthread_mutex_lock(struct sthread_mutex *m);
void sthread_mutex_unlock(struct sthread_mutex *m);
void sthread_mutex_destroy(struct sthread_mutex *m);
void sthread_cond_init(struct sthread_cond *c);
void sthread_cond_wait(struct sthread_cond *c, struct sthread_mutex *m, 
		       Long timeout);
void sthread_cond_signal(struct sthread_cond *c);
void sthread_cond_broadcast(struct sthread_cond *c);
void sthread_cond_destroy(struct sthread_cond *c);

extern int singlethreaded;
#endif /* h_sthreads */
