/* Redefinition of the fork() system call, so that we can make sure
 * that ownership for SIGIO goes to the right process */

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>

pid_t __wrap_fork(void) 
{
    int ret;

    ret = __real_fork();

    if (ret > 0) {
	/* Parent or error */
	return ret;
    } else if (ret < 0) {
	return ret;
    } else {
	/* Child */
	int i;
	int pid = getpid();

	/* Restart this thread's alarms, as those aren't inherited. */
	threadTimerReset();
	
	return 0;
    }
}
