/* Synchronization routines to use while running in UNIX */

#include <signal.h>

static sigset_t blockmask;
static sigset_t oldmask;

static int inited = 0;
static int count = 0;

long
synchEnableInterrupts (void)
{
    if (!inited) {
	return; /* No need to enable if nothing has been disabled yet */
    }

    /* reset the sigmask to what it was when we were called */
    if (count == 0)
	return 0;

    if (--count == 0)
	sigprocmask(SIG_SETMASK, &oldmask, 0);

    return 0;
}

long
synchDisableInterrupts (void)
{
    if (!inited) {
	sigfillset(&blockmask);
	inited = 1;
    }

    /* Block out all signals */
    if (count++ == 0)
	sigprocmask(SIG_BLOCK, &blockmask, &oldmask);

    return 0;
}
long
synchRestoreInterrupts (void)
{   
    synchEnableInterrupts();
    return 0;
}
