/* Redefinition of the open system call, so that we can mark it
 * as non-blocking and asynchronous */

#include <sys/time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <stdarg.h>
#include <unistd.h>

int __wrap_select(int  n,  fd_set  *readfds,  fd_set  *writefds,
		  fd_set *exceptfds, struct timeval *timeout)
{
    if (timeout &&
	(timeout->tv_sec == 0) &&
	(timeout->tv_usec == 0)) {
	return __real_select(n, readfds, writefds, exceptfds, timeout);
    } else {

	struct timeval notime;
	int res;

	notime.tv_sec = 0;
	notime.tv_usec = 0;
        while (1) {
	    res = __real_select(n, readfds, writefds, exceptfds, &notime);
	    if ((res == 0) && timeout) {
		int rval;
		fprintf(stderr, "Timed select blocks system!\n");
		threadYield();
	        rval = __real_select(n, readfds, writefds, exceptfds, timeout);
		threadYield();
		return rval;
	    } else if (res != 0) {
	        return res;
            } else {
                fdescAnyWait();
            }
        }
    }
}
