/*
 * @COPYRIGHT@
 * @COPYRIGHT@
 *
 * $RCSfile: scout_thread.h,v $
 *
 * HISTORY
 * $Log: scout_thread.h,v $
 * Revision 1.1  1997/09/19 20:26:51  bridges
 * Relocation of machine-dependent files, addition of scout_synch.h to
 * support the machine-dependent portions of scout threads synchronization.
 *
 * Revision 1.1.1.1  1997/08/29 22:41:02  bridges
 * Import of scout threads
 *
 * Revision 1.3  1996/10/03 07:02:10  davidm
 * Use $15 instead of $fp to make it compile under Linux (gas).
 *
 * Revision 1.2  1996/10/03 07:00:39  davidm
 * Rename PAL_wrfen to PALOSF_wrfen.
 *
 */
/*
 * This must not be included by anything but thread.c.  That's
 * why this file is not protected by #ifdefs.
 */

/*
 * Alpha register usage (OSF/1 1.3):
 *
 * Callee saved registers:	r9-r14, r26, f2-f9
 *
 *	r0  = function return value (non-fp)
 *	r15 = frame pointer (if has not been optimized away)
 *	r29 = global pointer
 *	r26 = return PC
 *	r30 = stack pointer (SP)
 *	r31 = always 0
 *	f0  = function return value (fp)
 *	f31 = always 0.0
 */

#define MAGIC_COOKIE		0xFEEDF00DBEC0FFEE
#define MIN_STACK_SIZE		(1024)	/* enough for a single printf() */
#define MIN_USEFUL_STACK_SIZE	(2*MIN_STACK_SIZE)
#define DEFAULT_STACK_SIZE	(64*MIN_USEFUL_STACK_SIZE) 
#define FPU_STATE_SIZE		(9*sizeof(long))

/*
 * Switch to stack TO_SP, discarding the old stack pointer and invoke
 * start().  On the Alpha, a return PC of 0 indicates a top-level
 * function.  So unlike in a normal procedure call, we set RA ($26) to 0:
 */
#define SWITCH_STACK_AND_START(to_sp,start)				\
{									\
    asm volatile ("mov %0, $sp
		   mov $31, $26
		   br $31, start..ng" : : "r"(to_sp), "i"(start));	\
}

/*
 * Save necessary state on stack, save new stack pointer to
 * variable SAVED_SP:
 */
#define SAVE_STATE(saved_sp)						\
{									\
    asm volatile							\
      ("lda $sp,-64($sp)	# allocate space for state on stack
	stq  $9,  0($sp)	# save callee-saved registers
	stq $10,  8($sp)	# r9-r15 and r26
	stq $11, 16($sp)
	stq $12, 24($sp)
	stq $13, 32($sp)
	stq $14, 40($sp)
	stq $15, 48($sp)
	stq $26, 56($sp)	# save return PC
	stq $sp, %0		# save sp to saved_sp
        " : "m=" (saved_sp) : : "memory");				\
}


/*
 * Load state stored at FROM_SP.
 */
#define LOAD_STATE(from_sp)						\
{									\
    asm volatile							\
      ("ldq $sp, %0 		# restore sp from from_sp
	ldq  $9,  0($sp)	# restore callee-saved registers
	ldq $10,  8($sp)	# r9-r15 and r26
	ldq $11, 16($sp)
	ldq $12, 24($sp)
	ldq $13, 32($sp)
	ldq $14, 40($sp)
	ldq $15, 48($sp)
	ldq $26, 56($sp)	# save return PC
	lda $sp,+64($sp)	# pop saved state
	" : : "m" (from_sp));						\
}

#define SAVE_FPU_STATE(fpu_state)					\
{									\
    asm volatile							\
      ("trapb			# take outstanding traps now 
	stt $f2, 0(%0)
	mf_fpcr $f2
	stt $f3, 8(%0)
	stt $f4, 16(%0)
	stt $f5, 24(%0)
	stt $f6, 32(%0)
	stt $f7, 40(%0)
	stt $f8, 48(%0)
	stt $f9, 56(%0)
	stt $f2, 64(%0)		# save fpcr
	" : : "r" (fpu_state) : "memory");				\
}
       
#define LOAD_FPU_STATE(fpu_state)					\
{									\
    asm volatile							\
      ("ldt $f9, 64(%0)		# load fpcr
	ldt $f2,  0(%0)
	ldt $f3,  8(%0)
	ldt $f4, 16(%0)
	ldt $f5, 24(%0)
	ldt $f6, 32(%0)
	ldt $f7, 40(%0)
	ldt $f8, 48(%0)
	mt_fpcr $f9		# install fpcr 
	ldt $f9, 56(%0)
	trapb			# ensure fpcr is updated before next trap
	" : : "r" (fpu_state) : "memory");				\
}

#define FPU_ON								\
{									\
   asm volatile ("mov 1, $16
		  call_pal %0"						\
		 :: "i"(PALOSF_wrfen)					\
		 : "memory", "1", "16", "22", "23", "24", "25");	\
}

#define FPU_OFF								\
{									\
   asm volatile ("mov $31, $16
		  call_pal %0"						\
		 :: "i"(PALOSF_wrfen)					\
		 : "memory", "1", "16", "22", "23", "24", "25");	\
}

/* this is for debugging purposes only: */
#define GET_SAVED_PC(sp)	((void*)(((u_long*)(sp))[7]))
