#ifndef __scout_include_h__
#define __scout_include_h__

/* Stuff needed by Scout threads */

#ifndef size_t
#include <stddef.h>
#endif
#if defined(linux)
/* glibc2/libc6 does not include linux/types.h, which defines __s*.
 * libc5 does, but it doesn't hurt to repeat it. */
#include <linux/types.h>
#endif /* linux */

typedef unsigned int bool;
#define FALSE 0
#define TRUE 1

#define u_char 	unsigned char
#define u_short unsigned short
#define u_int  	unsigned int
#define u_long 	unsigned long

typedef union {
    char        c;
    short       s;
    int         i;
    long        l;
    u_char      uc;
    u_short     us;
    u_int       ui;
    u_long      ul;
    void *      p;
    char *      cp;
    short *     sp;
    int *       ip;
    long *      lp;
    u_char *    ucp;
    u_short *   usp;
    u_int *     uip;
    u_long *    ulp;
    __s8        s8;
    __s16       s16;
    __s32       s32;
    __u8        u8;
    __u16       u16;
    __u32       u32;
} AnyType;

#ifndef __errno_h__
#define __errno_h__

typedef enum {
   ESUCCESS    = 0
} ErrorCode;

#endif /* __errno_h__ */

#endif
