/* 
 * @COPYRIGHT@
 * @COPYRIGHT@
 *
 * $RCSfile: scout_thread.h,v $
 *
 * HISTORY
 * $Log: scout_thread.h,v $
 * Revision 1.3  1998/02/02 17:00:04  pab
 * Remove -g from config, eliminate scoutthread compile warnings, draft glibc2 support
 *
 * Revision 1.2  1997/09/19 20:25:14  bridges
 * Rearranged architecture files, build environment.
 * Added code to prevent blocking in many system calls.
 *
 * Revision 1.1.1.1  1997/08/29 22:41:03  bridges
 * Import of scout threads
 *
 * Revision 1.5  1996/12/16 22:30:28  davidm
 * (struct Thread): Declare member "running" as unsigned long.
 *
 * Revision 1.4  1996/09/07 20:49:25  davidm
 * (tSelf): Don't use (0, x) to create rvalue since some compilers generate
 * 	warning about "useless expression".
 * (threadName): Make inline function.
 *
 * Revision 1.3  1996/05/28 20:17:26  davidm
 * ThreadPrio: moved into thread_prio.h.
 * ThreadScheduler: New type.
 * struct Thread: Removed unused member "magic".
 * threadIdleCount: Removed.
 * threadRegisterScheduler: New function.
 *
 * Add include of <scout/threadd_p.h>
 *
 */

#ifndef __thread_h__
#define __thread_h__

#include <sys/types.h>
#include "scout_include.h"
#include "scout_fifo.h"

typedef enum {
    THREAD_PRIO_MAX = 0,
    THREAD_PRIO_STD = 1,
    THREAD_PRIO_MIN = 2
} ThreadPrio;

typedef void			(*ThreadFunc)(AnyType arg);

typedef struct ThreadStack *	ThreadStack;

typedef struct Thread *		Thread;
typedef struct ThreadOptions *	ThreadOptions;
typedef struct ThreadScheduler *ThreadScheduler;

struct ThreadScheduler {
    const char *	name;			/* policy name */
    void		(*wakeupThread)(Thread t);
    Thread		(*selectThread)(void);	/* next thread to execute */
    int			quota;
    struct FIFO		async_q;		/* for asynchronous wakeups */
    ThreadScheduler	next;			/* cyclic scheduler list */
};

struct ThreadOptions {
    char *		name;		/* thread name */
    AnyType		arg;		/* argument to be passed to FUN */
    ThreadScheduler	scheduler;	/* scheduling policy */
    AnyType		priority;	/* sched.-dependent thread priority */
};

struct Thread {
    Thread			next;		/* linked list of threads */
   ErrorCode			pterrno; /* per-thread errno */
    u_long			running   : 1;	/* has thread been started? */
    ThreadStack			stack;
    ThreadFunc			func;
    struct ThreadOptions	option;
    void *			info;
};

extern bool			threadInitialized;
extern const ThreadOptions	threadDefaultOptions;
extern Thread			threadSelf;

#define tSelf			(threadSelf + 0)
#define threadSetContFunc(t,f)	{(t)->func = (f);}
#define threadSetContArg(t,a)	{(t)->option.arg = (a);}

extern struct ThreadScheduler   threadFixedPrioScheduler;

extern const char * threadName (Thread t);
extern void	threadInit (ThreadFunc init, AnyType arg);
extern Thread	threadCreate (ThreadFunc func, const ThreadOptions opt);
extern void	threadStop (void);
extern void	threadSuspend (void);
extern void	threadSuspendWithContinuation (void);
extern void	threadWakeup (Thread t);
extern void	threadAsyncWakeup (Thread t);
extern void	threadYield (void);
extern size_t	threadFreeStack (void);
extern void	threadFPUFault (void);

#ifdef SCOUT_ROUTER
#  include "thread_p.h"
#endif

#endif /* __thread_h__ */
