//  FieldRef.java -- a Field ref in a Constant table

package toba.classfile;

public class VariableRef extends FieldRef {
    public VariableRef(ClassRef cl, String n, String s) { super(cl, n, s); }

    protected Field findVariable(ClassData cdata) {
	Field[] ivtable = cdata.ivtable;
	for (int i = 0; i < ivtable.length; i++) {
	    if ((name == ivtable[i].name) && 
		(signature == ivtable[i].signature))
		return ivtable[i];
	}

	Field[] cvtable = cdata.cvtable;
	for (int i = 0; i < cvtable.length; i++) {
	    if ((name == cvtable[i].name) && 
		(signature == cvtable[i].signature))
		return cvtable[i];
	}
	throw new NoSuchFieldError(name + signature);
    }

    public void resolveWith(ClassData cdata) {
	resolveTo(findVariable(cdata));
    }

};
