package TTT;
use strict;
use warnings;

my @Values = (			#The relative importances of the squares
						[3, 1, 3],
						[1, 5, 1],
						[3, 1, 3]
			 );
use constant TwoValue => 5;
use constant Infinity => 1e99;
our ($X,$O) = (1,-1);
our $TIE    = 0;

our %chars = (0 => " ",
			  $X => "X",
			  $O => "O"
			 );

sub new
{
	my $proto = shift;
	my $class = ref($proto) || $proto;
	my $self  = {};
	$self->{PLIES} = 4;
	$self->{BOARD} = undef;
	$self->{MOVES} = undef;
	$self->{PLAYER} = undef;
	bless($self,$class);
}

sub newGame
{
	my $self = shift;
	$self->{BOARD} =
		[
		 [0, 0, 0],
		 [0, 0, 0],
		 [0, 0, 0]
		];
	$self->{MOVES} = 0;
	$self->{PLAYER} = $X;
}

sub plies
{
	my $self = shift;
	if(@_){$self->{PLIES} = shift;}
	return $self->{PLIES};
}

sub player
{
	my $self = shift;
	return $self->{PLAYER};
}

sub move
{
	my ($self,$row,$col) = @_;
	return undef if $row < 0 || $row > 2 || $col < 0 || $col > 2;
	return undef if $self->{BOARD}->[$row][$col];
	$self->{BOARD}->[$row][$col] = $self->{PLAYER};
	$self->{MOVES}++;
	if(defined($self->winner))
	{
		$self->{PLAYER} = 0;
	}
	else
	{
		$self->{PLAYER} *= -1;
	}
	return 1;
}

sub moveAI
{
	my $self = shift;

	my $me = shift || $self->{PLAYER};
	my $board = $self->{BOARD};
	my $plies = shift || 0;

	my $alpha = shift || - Infinity;
	$alpha *= -1;

	my $val = $self->boardValue($board,$me);
	return (undef,undef,$val) if($plies >= $self->{PLIES});
	my @moves = $self->legalMoves($board);
	return (undef,undef,$val) if(scalar @moves == 0);

	my $max = - Infinity;
	my $move;
	my $bestmove = $moves[0];
	my $bv;
	my @temp;
	for $move (@moves)
	{
		$board->[$move->[0]][$move->[1]] = $me;
		my $win = $self->winner($board);
		if(!$win)
		{
			@temp = $self->moveAI(-$me,$plies+1,$max);
			$bv = -$temp[2];
		}
		else
		{
			#2 * is a cheap hack to make immediate wins
			#better than future ones, even if they are forced
			$bv = 2 * $me * $win * Infinity;
		}
		$board->[$move->[0]][$move->[1]] = 0;
#		if($plies == 0)
#		{
#			print "\t[" . $move->[0] . "," . $move->[1] . "]:" . $bv;
#		}
		if($bv > $max)
		{
			$max = $bv;
			$bestmove = $move;
			return (undef,undef,$max)
				if ($max >= $alpha && abs($alpha) < Infinity);
		}
	}

	return ($bestmove->[0],$bestmove->[1],$max);
}

#Returns an array of (row,col) refs of all the legal moves in a board
sub legalMoves
{
	my $self = shift;
	my $board = shift || $self->{BOARD};
	my ($i,$j);
	my @Moves = ();
	for $i (0..2)
	{
		for $j (0..2)
		{
			push @Moves, [$i,$j] if($board->[$i][$j] == 0);
		}
	}
	return @Moves;
}

#Evaluate the value of the given (or current by default) board
#For a specified player
sub boardValue
{
	my $self = shift;
	my $board = shift || $self->{BOARD};
	my $who = shift || $self->{PLAYER};
	my $value = 0;
	my ($i,$j);
	for $i (0..2)
	{
		for $j (0..2)
		{
			$value += $board->[$i][$j] * $Values[$i][$j];
		}
	}
	my $sum;
	for $i (0..2)
	{
		$sum = $board->[$i][0] + $board->[$i][1] + $board->[$i][2];
		$value += TwoValue * $sum/2 if(abs($sum) == 2);
		$sum = $board->[0][$i] + $board->[1][$i] + $board->[2][$i];
		$value += TwoValue * $sum/2 if(abs($sum) == 2);
	}

	$sum = $board->[0][0] + $board->[1][1] + $board->[2][2];
	$value += TwoValue * $sum/2 if(abs($sum) == 2);
	$sum = $board->[0][2] + $board->[1][1] + $board->[2][0];
	$value += TwoValue * $sum/2 if(abs($sum) == 2);

	my $win = $self->winner($board);
	$value += $win * Infinity if $win;
	return $value * $who;
}

sub gameOver
{
	my $self = shift;
	return defined($self->winner());
}

sub winner
{
	my $self = shift;
	my $board = shift || $self->{BOARD};
	my ($i,$j);
	my ($ctX,$ctO) = (0,0);
	my ($Xcan,$Ocan) = (0,0);

	return $TIE if $self->{MOVES} >= 9;

	#diagonals, UL to LR
	for $i (0..2)
	{
		$ctX += $board->[$i][$i] == $X;
		$ctO += $board->[$i][$i] == $O;
	}
	return $X if $ctX == 3;
	return $O if $ctO == 3;
	$Xcan ||= !$ctO;
	$Ocan ||= !$ctX;

	#UR to LL
	($ctX,$ctO) = (0,0);
	for $i (0..2)
	{
		$ctX += $board->[$i][2-$i] == $X;
		$ctO += $board->[$i][2-$i] == $O;
	}
	return $X if $ctX == 3;
	return $O if $ctO == 3;
	$Xcan ||= !$ctO;
	$Ocan ||= !$ctX;

	#rows
	for $i (0..2)
	{
		($ctX,$ctO) = (0,0);
		for $j (0..2)
		{
			$ctX += $board->[$i][$j] == $X;
			$ctO += $board->[$i][$j] == $O;
		}
		return $X if $ctX == 3;
		return $O if $ctO == 3;
		$Xcan ||= !$ctO;
		$Ocan ||= !$ctX;
	}

	#columns
	for $i (0..2)
	{
		($ctX,$ctO) = (0,0);
		for $j (0..2)
		{
			$ctX += $board->[$j][$i] == $X;
			$ctO += $board->[$j][$i] == $O;
		}
		return $X if $ctX == 3;
		return $O if $ctO == 3;
		$Xcan ||= !$ctO;
		$Ocan ||= !$ctX;
	}
	return (($self->{PLAYER} == $X) ? $Xcan : $Ocan) ? undef : $TIE;
}

sub printBoard
{
	my $self = shift;
	my $player = $self->{PLAYER};
	my $board = $self->{BOARD};

	my ($i,$j);
	print "\n---$chars{$player}---\n";
	for $i (0..2)
	{
		print "|";
		for $j (0..2)
		{
			print $chars{$board->[$i][$j]};
			print "|";
		}
		print "\n-------\n";
	}
}

1;
