/*****************************************************************************
 *
 * Microchip DeviceNet Stack 
 * (Initializers, Process Manager, and Network Access State Machine)
 *
 *****************************************************************************
 * FileName:        GoDNet.h
 * Dependencies:    
 * Processor:       PIC18F with CAN
 * Compiler:       	C18 02.10.02 or higher
 * Linker:          MPLINK 03.20.01 or higher
 * Company:         Microchip Technology Incorporated
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "Company") is intended and supplied to you, the Company's
 * customer, for use solely and exclusively with products manufactured
 * by the Company. 
 *
 * The software is owned by the Company and/or its supplier, and is 
 * protected under applicable copyright laws. All rights are reserved. 
 * Any use in violation of the foregoing restrictions may subject the 
 * user to criminal sanctions under applicable laws, as well as to 
 * civil liability for the breach of the terms and conditions of this 
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 * This file contains the unified control functions for the DeviceNet stack.
 * 
 *
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ross Fosler			06/06/03	...	
 * 
 *****************************************************************************/









/*********************************************************************
 * Function:        void GoDNetProcessAllMsgEvents(void)
 *
 * PreCondition:  	none  
 *
 * Input:       	none			
 *                  
 * Output:     		none
 * 	
 * Side Effects:   	none 
 *
 * Overview:        This function processes all messaging events in the 
 *					DeviceNet protocol stack.  
 *
 * Note:            This function should be called as often as 
 *					possible to prevent overflow.
 ********************************************************************/
void GoDNetProcessAllMsgEvents(void);


/*********************************************************************
 * Function:        void GoDNetProcessAllTickEvents(void)
 *
 * PreCondition:  	none  
 *
 * Input:       	none			
 *                  
 * Output:     		none
 * 	
 * Side Effects:   	none 
 *
 * Overview:        This function processes all timer events in the 
 *					DeviceNet protocol stack.  
 *
 * Note:            This should be called once every TICK_RESOLUTION
 *					milliseconds.
 ********************************************************************/
void GoDNetProcessAllTickEvents(void);


/*********************************************************************
 * Function:        void GoDNetInitializeAll(void)
 *
 * PreCondition:  	none  
 *
 * Input:       	none			
 *                  
 * Output:     		none
 * 	
 * Side Effects:   	none 
 *
 * Overview:        Initialize everything for the DeviceNet protocol 
 *					stack to function.  
 *
 * Note:            none
 ********************************************************************/
void GoDNetInitializeAll(void);

