/*****************************************************************************
 *
 * Microchip DeviceNet Stack (DeviceNet Object Header)
 *
 *****************************************************************************
 * FileName:        dnet.h
 * Dependencies:    
 * Processor:       PIC18F with CAN
 * Compiler:       	C18 02.10.02 or higher
 * Linker:          MPLINK 03.20.01 or higher
 * Company:         Microchip Technology Incorporated
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "Company") is intended and supplied to you, the Company's
 * customer, for use solely and exclusively with products manufactured
 * by the Company. 
 *
 * The software is owned by the Company and/or its supplier, and is 
 * protected under applicable copyright laws. All rights are reserved. 
 * Any use in violation of the foregoing restrictions may subject the 
 * user to criminal sanctions under applicable laws, as well as to 
 * civil liability for the breach of the terms and conditions of this 
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 *
 * This file contains the DeviceNet object described in section 5-5 of 
 * volume 1 of the DeviceNet specification.
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ross Fosler			04/03/03	...	
 * 
 *****************************************************************************/






#define		DNET_ATTRIB_MAC_ID				0x01
#define		DNET_ATTRIB_BAUD_RATE			0x02
#define		DNET_ATTRIB_BOI					0x03
#define		DNET_ATTRIB_BO_COUNT			0x04
#define		DNET_ATTRIB_ALLOC_INFO			0x05
#define		DNET_ATTRIB_MAC_SW_CH			0x06
#define		DNET_ATTRIB_BAUD_SW_CH			0x07
#define		DNET_ATTRIB_MAC_SW_VAL			0x08
#define		DNET_ATTRIB_BAUD_SW_VAL			0x09



/*********************************************************************
 * DeviceNet object data structure
 ********************************************************************/
typedef union U_ALLOC
{
	USINT byte;
	struct S_ALLOC_BITS
	{
		unsigned 	expl:1;
		unsigned	poll:1;
		unsigned	strobe:1;
		unsigned	multi:1;
		unsigned	cos:1;
		unsigned	cyclic:1;
		unsigned	acksup:1;
		unsigned	res1:1;
	}bits;
}ALLOC;	


typedef struct _DNET
{
	USINT 	MACID;
	USINT 	BaudRate;
	BOOL	BOI;

	USINT	BusOffCount;

	struct _ALLOC_INFO
	{
		ALLOC	AllocChoice;
		USINT	MasterMACID;
	}AllocInfo;

#if ALLOW_MAC_ID_SW_CH
	BOOL 	MACSwChange;
#endif

#if ALLOW_BAUD_RATE_SW_CH
	BOOL	BaudSwChange;
#endif

#if ALLOW_MAC_ID_SW_VAL
	USINT	MACSwValue;
#endif

#if	ALLOW_BAUD_RATE_SW_VAL
	USINT	BaudSwValue;
#endif
}DNET;




 

				


/*********************************************************************
 * DeviceNet object data structure declared global
 ********************************************************************/
extern DNET uDNet;



unsigned char _DNetAllocNoSupportChk(BYTE choice);


/*********************************************************************
 * Function:        unsigned char DNetExplMsgHandler(void)
 *
 * PreCondition:    The path (aService, aClassID, aInstanceID) must
 *					be loaded prior to using this function. If service
 *					indicates any type of IO then the buffer pointers
 *					must be initialized.
 *
 * Input:       	aHeader, aClassID, aInstanceID, aService
 *					*pOutBuf, *pInBuf, aOutBufDataLen, aInBufDataLen
 *					aOutBufLen, aInBufLen		
 *                  
 * Output:      	aHeader, aService	
 *					*pOutBuf, *pInBuf, aOutBufDataLen, aInBufDataLen
 *				
 *			
 *
 * Side Effects:    
 *
 * Overview:        DeviceNet object explicit messaging handler. This
 *					fucntion is called by the Router object. It decodes
 *					the instance and service and performs the requested
 *					function.  
 *
 * Note:            None
 ********************************************************************/
unsigned char _DNetExplMsgHandler(void);
//unsigned char DNetInit(void);


/*********************************************************************
 * Function:        unsigned char DNetInst0GetAttrib(void)
 *
 * PreCondition:    The path (aService, aClassID, aInstanceID) must
 *					be loaded prior to using this function. If service
 *					indicates any type of IO then the buffer pointers
 *					must be initialized.
 *
 * Input:       	aHeader, aClassID, aInstanceID, aService
 *					*pOutBuf, *pInBuf, aOutBufDataLen, aInBufDataLen
 *					aOutBufLen, aInBufLen		
 *                  
 * Output:      	aHeader, aService	
 *					*pOutBuf, *pInBuf, aOutBufDataLen, aInBufDataLen
 *				
 *			
 *
 * Side Effects:    
 *
 * Overview:        Get attribute service for instance 0.  
 *
 * Note:            None
 ********************************************************************/
unsigned char _DNetInst0GetAttrib(void);


/*********************************************************************
 * Function:        unsigned char DNetInst1GetAttrib(void)
 *
 * PreCondition:    The path (aService, aClassID, aInstanceID) must
 *					be loaded prior to using this function. If service
 *					indicates any type of IO then the buffer pointers
 *					must be initialized.
 *
 * Input:       	aHeader, aClassID, aInstanceID, aService
 *					*pOutBuf, *pInBuf, aOutBufDataLen, aInBufDataLen
 *					aOutBufLen, aInBufLen		
 *                  
 * Output:      	aHeader, aService	
 *					*pOutBuf, *pInBuf, aOutBufDataLen, aInBufDataLen
 *				
 *			
 *
 * Side Effects:    
 *
 * Overview:        Get attribute service for instance 1.  
 *
 * Note:            None
 ********************************************************************/
unsigned char _DNetInst1GetAttrib(void);


/*********************************************************************
 * Function:        unsigned char DNetInst1SetAttrib(void)
 *
 * PreCondition:  	The path (aService, aClassID, aInstanceID) must
 *					be loaded prior to using this function. If service
 *					indicates any type of IO then the buffer pointers
 *					must be initialized.  
 *
 * Input:       	aHeader, aClassID, aInstanceID, aService
 *					*pOutBuf, *pInBuf, aOutBufDataLen, aInBufDataLen
 *					aOutBufLen, aInBufLen		
 *                  
 * Output:      	aHeader, aService	
 *					*pOutBuf, *pInBuf, aOutBufDataLen, aInBufDataLen
 *				
 *			
 *
 * Side Effects:    
 *
 * Overview:        Set attribute service for instance 1.  
 *
 * Note:            None
 ********************************************************************/
unsigned char _DNetInst1SetAttrib(void);


/*********************************************************************
 * Function:        unsigned char DNetAllocateConnection(void)
 *
 * PreCondition:    The path (aService, aClassID, aInstanceID) must
 *					be loaded prior to using this function. If service
 *					indicates any type of IO then the buffer pointers
 *					must be initialized.
 *
 * Input:       	aHeader, aClassID, aInstanceID, aService
 *					*pOutBuf, *pInBuf, aOutBufDataLen, aInBufDataLen
 *					aOutBufLen, aInBufLen		
 *                  
 * Output:      	aHeader, aService	
 *					*pOutBuf, *pInBuf, aOutBufDataLen, aInBufDataLen
 *				
 *			
 *
 * Side Effects:    
 *
 * Overview:        Allocate predefined master/slave connection set.  
 *
 * Note:            None
 ********************************************************************/
unsigned char _DNetAllocateConnection(void);


/*********************************************************************
 * Function:        unsigned char DNetReleaseConnection(void)
 *
 * PreCondition:    The path (aService, aClassID, aInstanceID) must
 *					be loaded prior to using this function. If service
 *					indicates any type of IO then the buffer pointers
 *					must be initialized.
 *
 * Input:       	aHeader, aClassID, aInstanceID, aService
 *					*pOutBuf, *pInBuf, aOutBufDataLen, aInBufDataLen
 *					aOutBufLen, aInBufLen		
 *                  
 * Output:      	aHeader, aService	
 *					*pOutBuf, *pInBuf, aOutBufDataLen, aInBufDataLen
 *				
 *			
 *
 * Side Effects:    
 *
 * Overview:        Release predefined master/slave connections or
 *					the connection set.  
 *
 * Note:            None
 ********************************************************************/
unsigned char _DNetReleaseConnection(void);



unsigned char _DNetCreateConnections(BYTE choice);
void _DNetCloseConnections(BYTE choice);




/*********************************************************************
 * Function:        void DNetSetMACID(USINT macID)
 *			  
 * PreCondition:    
 *
 * Input:    		macID       
 *                  
 * Output:     		none    
 *				
 * Side Effects:  	  
 *
 * Overview:        Writes to the DeviceNet object variable, MACID. 
 *
 * Note:            None
 ********************************************************************/
#define	mDNetSetMACID(macID)				(uDNet.MACID = macID)


/*********************************************************************
 * Function:        void DNetSetBaudRate(USINT baudrate)
 *			  
 * PreCondition:    
 *
 * Input:    		macID       
 *                  
 * Output:     		none    
 *				
 * Side Effects:  	  
 *
 * Overview:        Writes to the DeviceNet object variable, BaudRate. 
 *
 * Note:            None
 ********************************************************************/
#define	mDNetSetBaudRate(baudrate)			(uDNet.BaudRate = baudrate)


/*********************************************************************
 * Function:        void DNetSetBOI(BOOL boi)
 *			  
 * PreCondition:    
 *
 * Input:    		boi       
 *                  
 * Output:     		none    
 *				
 * Side Effects:  	  
 *
 * Overview:        Writes to the DeviceNet object variable, BOI. 
 *
 * Note:            None
 ********************************************************************/ 
#define mDNetSetBOI(boi)					(uDNet.BOI = boi)


/*********************************************************************
 * Function:        void DNetSetBusOffCount(USINT boCount)
 *			  
 * PreCondition:    
 *
 * Input:    		boCount       
 *                  
 * Output:     		none    
 *				
 * Side Effects:  	  
 *
 * Overview:        Writes to the DeviceNet object variable, BusOffCount. 
 *
 * Note:            None
 ********************************************************************/
#define mDNetSetBusOffCount(boCount)		(uDNet.BusOffCount = boCount)


/*********************************************************************
 * Function:        void DNetSetAllocChoice(USINT allocChoice)
 *			  
 * PreCondition:    
 *
 * Input:    		allocChoice       
 *                  
 * Output:     		none    
 *				
 * Side Effects:  	  
 *
 * Overview:        Writes to the DeviceNet object variable, AllocInfo.AllocChoice. 
 *
 * Note:            None
 ********************************************************************/
#define	mDNetSetAllocChoice(allocChoice)	(uDNet.AllocInfo.AllocChoice.byte = allocChoice)


/*********************************************************************
 * Function:        void DNetSetMasterMACID(USINT masterMACID)
 *			  
 * PreCondition:    
 *
 * Input:    		masterMACID       
 *                  
 * Output:     		none    
 *				
 * Side Effects:  	  
 *
 * Overview:        Writes to the DeviceNet object variable, AllocInfo.MasterMACID. 
 *
 * Note:            None
 ********************************************************************/
#define mDNetSetMasterMACID(masterMACID)	(uDNet.AllocInfo.MasterMACID = masterMACID)


/*********************************************************************
 * Function:        void DNetSetMACSwChange(BOOL swCh)
 *			  
 * PreCondition:    
 *
 * Input:    		swCh       
 *                  
 * Output:     		none    
 *				
 * Side Effects:  	  
 *
 * Overview:        Writes to the DeviceNet object variable, MACSwChange. 
 *
 * Note:            None
 ********************************************************************/
#define mDNetSetMACSwChange(swCh)			(uDNet.MACSwChange = swCh)


/*********************************************************************
 * Function:        void DNetSetBaudSwChange(BOOL swCh)
 *			  
 * PreCondition:    
 *
 * Input:    		swCh       
 *                  
 * Output:     		none    
 *				
 * Side Effects:  	  
 *
 * Overview:        Writes to the DeviceNet object variable, BaudSwChange. 
 *
 * Note:            None
 ********************************************************************/
#define mDNetSetBaudSwChange(swCh)			(uDNet.BaudSwChange = swCh)


/*********************************************************************
 * Function:        void DNetSetMACSwValue(USINT swVal)
 *			  
 * PreCondition:    
 *
 * Input:    		swVal       
 *                  
 * Output:     		none    
 *				
 * Side Effects:  	  
 *
 * Overview:        Writes to the DeviceNet object variable, MacSwValue. 
 *
 * Note:            None
 ********************************************************************/
#define mDNetSetMACSwValue(swVal)			(uDNet.MACSwValue = swVal)


/*********************************************************************
 * Function:        void DNetSetBaudSwValue(USINT swVal)
 *			  
 * PreCondition:    
 *
 * Input:    		swVal       
 *                  
 * Output:     		none    
 *				
 * Side Effects:  	  
 *
 * Overview:        Writes to the DeviceNet object variable, BaudSwValue. 
 *
 * Note:            None
 ********************************************************************/
#define mDNetSetBaudSwValue(swVal)			(uDNet.BaudSwValue = swVal)


/*********************************************************************
 * Function:        USINT DNetGetMACID(void)
 *			  
 * PreCondition:    
 *
 * Input:    		none       
 *                  
 * Output:     		MACID    
 *				
 * Side Effects:  	  
 *
 * Overview:        Reads from the DeviceNet object variable, BaudSwValue. 
 *
 * Note:            None
 ********************************************************************/
#define mDNetGetMACID()						(uDNet.MACID)


/*********************************************************************
 * Function:        USINT DNetGetBaudRate(void)
 *			  
 * PreCondition:    
 *
 * Input:    		none       
 *                  
 * Output:     		BaudRate    
 *				
 * Side Effects:  	  
 *
 * Overview:        Reads from the DeviceNet object variable, BaudRate. 
 *
 * Note:            None
 ********************************************************************/
#define mDNetGetBaudRate()					(uDNet.BaudRate)


/*********************************************************************
 * Function:        BOOL DNetGetBOI(void)
 *			  
 * PreCondition:    
 *
 * Input:    		none       
 *                  
 * Output:     		BOI    
 *				
 * Side Effects:  	  
 *
 * Overview:        Reads from the DeviceNet object variable, BOI. 
 *
 * Note:            None
 ********************************************************************/
#define mDNetGetBOI()						(uDNet.BOI)


/*********************************************************************
 * Function:        USINT DNetGetBusOffCount(void)
 *			  
 * PreCondition:    
 *
 * Input:    		none       
 *                  
 * Output:     		BusOffCount    
 *				
 * Side Effects:  	  
 *
 * Overview:        Reads from the DeviceNet object variable, BusOffCount. 
 *
 * Note:            None
 ********************************************************************/
#define mDNetGetBusOffCount()				(uDNet.BusOffCount)


/*********************************************************************
 * Function:        USINT DNetGetAllocChoice(void)
 *			  
 * PreCondition:    
 *
 * Input:    		none       
 *                  
 * Output:     		AllocInfo.AllocChoice    
 *				
 * Side Effects:  	  
 *
 * Overview:        Reads from the DeviceNet object variable, AllocInfo.AllocChoice. 
 *
 * Note:            None
 ********************************************************************/
#define	mDNetGetAllocChoice()				(uDNet.AllocInfo.AllocChoice)


/*********************************************************************
 * Function:        USINT DNetGetMasterMACID(void)
 *			  
 * PreCondition:    
 *
 * Input:    		none       
 *                  
 * Output:     		AllocInfo.MasterMACID    
 *				
 * Side Effects:  	  
 *
 * Overview:        Reads from the DeviceNet object variable, AllocInfo.MasterMACID. 
 *
 * Note:            None
 ********************************************************************/
#define mDNetGetMasterMACID()				(uDNet.AllocInfo.MasterMACID)


/*********************************************************************
 * Function:        BOOL DNetGetMACSwChange(void)
 *			  
 * PreCondition:    
 *
 * Input:    		none       
 *                  
 * Output:     		MACSwChange    
 *				
 * Side Effects:  	  
 *
 * Overview:        Reads from the DeviceNet object variable, MACSwChange. 
 *
 * Note:            None
 ********************************************************************/
#define mDNetGetMACSwChange()				(uDNet.MACSwChange)


/*********************************************************************
 * Function:        BOOL DNetGetBaudSwChange(void)
 *			  
 * PreCondition:    
 *
 * Input:    		none       
 *                  
 * Output:     		BaudSwChange    
 *				
 * Side Effects:  	  
 *
 * Overview:        Reads from the DeviceNet object variable, BaudSwChange. 
 *
 * Note:            None
 ********************************************************************/
#define mDNetGetBaudSwChange()				(uDNet.BaudSwChange)


/*********************************************************************
 * Function:        USINT DNetGetMACSwValue(void)
 *			  
 * PreCondition:    
 *
 * Input:    		none       
 *                  
 * Output:     		MacSwValue    
 *				
 * Side Effects:  	  
 *
 * Overview:        Reads from the DeviceNet object variable, MacSwValue. 
 *
 * Note:            None
 ********************************************************************/
#define mDNetGetMACSwValue()				(uDNet.MacSwValue)


/*********************************************************************
 * Function:        USINT DNetGetBaudSwValue(void)
 *			  
 * PreCondition:    
 *
 * Input:    		none       
 *                  
 * Output:     		BaudSwValue    
 *				
 * Side Effects:  	  
 *
 * Overview:        Reads from the DeviceNet object variable, BaudSwValue. 
 *
 * Note:            None
 ********************************************************************/
#define mDNetGetBaudSwValue()				(uDNet.BaudSwValue)





/*********************************************************************
 * Function:        unsigned char DNetInit(void)
 *
 * PreCondition:    The path (aService, aClassID, aInstanceID) must
 *					be loaded prior to using this function. If service
 *					indicates any type of IO then the buffer pointers
 *					must be initialized.
 *
 * Input:       	aHeader, aClassID, aInstanceID, aService
 *					*pOutBuf, *pInBuf, aOutBufDataLen, aInBufDataLen
 *					aOutBufLen, aInBufLen		
 *                  
 * Output:      	aHeader, aService	
 *					*pOutBuf, *pInBuf, aOutBufDataLen, aInBufDataLen
 *				
 *			
 *
 * Side Effects:    
 *
 * Overview:        Initialize the DeviceNet object.  
 *
 * Note:            None
 ********************************************************************/
#define mDNetInit(mac_ID, baud, boi, alloc_choice, master_mac_ID) 	{	\
					 uDNet.AllocInfo.MasterMACID = master_mac_ID;		\
					 uDNet.AllocInfo.AllocChoice = alloc_choice;		\
					 uDNet.BOI = boi;									\
					 uDNet.BaudRate = baud;								\
					 uDNet.MACID = mac_ID;}							
