/*****************************************************************************
 *
 * Microchip DeviceNet Stack (Connection Object Fragmentation Header)
 *
 *****************************************************************************
 * FileName:        FRAG.H
 * Dependencies:    
 * Processor:       PIC18F with CAN
 * Compiler:       	C18 02.10.02 or higher
 * Linker:          MPLINK 03.20.01 or higher
 * Company:         Microchip Technology Incorporated
 *
 * Software License Agreement
 *
 * The software supplied herewith by Microchip Technology Incorporated
 * (the "Company") is intended and supplied to you, the Company's
 * customer, for use solely and exclusively with products manufactured
 * by the Company. 
 *
 * The software is owned by the Company and/or its supplier, and is 
 * protected under applicable copyright laws. All rights are reserved. 
 * Any use in violation of the foregoing restrictions may subject the 
 * user to criminal sanctions under applicable laws, as well as to 
 * civil liability for the breach of the terms and conditions of this 
 * license.
 *
 * THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES, 
 * WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED 
 * TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT, 
 * IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR 
 * CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.
 *
 *
 * This file contains unacknowledged fragmentation support. Refer to 
 * section 4-4 of Volume 1 of the DeviceNet specification. 
 *
 *
 * Author               Date        Comment
 *~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
 * Ross Fosler			04/28/03	...	
 * 
 *****************************************************************************/

#if FRAGMENTATION_UNACK
	 
extern NEAR FRAG _aFrag; 


/*********************************************************************
 * Function:        void _FragNoAckConsume(void)
 *
 * PreCondition: 	The fragment structure must be loaded with the 
 *					last known state of the calling connection.  
 *
 * Input:       	none
 *                  
 * Output:      	none
 *
 * Side Effects:    _aFrag is updated.
 *
 * Overview:      	This function handles unacknowledged reception
 *					of fragmented data.
 *
 * Note:            This function only receives data and does not 
 *					free the CAN driver to receive. It is up to the
 *					calling function to release the hardware to 
 *					receive data.
 ********************************************************************/
void _FragNoAckConsume(void);



/*********************************************************************
 * Function:        void _FragNoAckProduce(void)
 *
 * PreCondition:    The fragment structure must be loaded with the 
 *					last known state of the calling connection.
 *
 * Input:       	none	
 *                  
 * Output:      	none
 *
 * Side Effects:    _aFrag is updated.
 *
 * Overview:        This function handles unacknowledged transmission
 *					of fragmented data.  
 *
 * Note:            This function does not issue any requests to the 
 *					driver to send data. It is up to the calling 
 *					to issue the transmit request.
 ********************************************************************/
void _FragNoAckProduce(void);





#define	_mFragNoAckConsume(rx_info){ 		_aFrag.rx = rx_info;	\
											_FragNoAckConsume();	\
											rx_info = _aFrag.rx; }
											
#define	_mFragNoAckProduce(tx_info){ 		_aFrag.tx = tx_info;	\
											_FragNoAckProduce();	\
											tx_info = _aFrag.tx; }										

#endif
