;*******************************************************************************;
;*                                                                              ;
;*  This implements a generic library functionality to support SPI Slave        ;
;*  for PIC16 family                                                            ;
;*  It adds additional functionality of Rx/Tx user defined Cicular buffer       ;
;*                                                                              ;
;*******************************************************************************;
;* FileName:            16SPISI.asm                                     ;
;* Dependencies:        P16xxx.inc                                      ;
;*                      SPISInt.Inc                                     ;
;* Processor:           PIC16xxxx                                       ;
;* Assembler:           MPASMWIN 02.70.02 or higher                     ;
;* Linker:              MPLINK 2.33.00 or higher                        ;
;* Company:             Microchip Technology, Inc.                      ;
;*                                                                      ;
;* Software License Agreement                                           ;
;*                                                                      ;
;* The software supplied herewith by Microchip Technology Incorporated  ;
;* (the "Company") for its PICmicro Microcontroller is intended and    ;
;* supplied to you, the Company's customer, for use solely and          ;
;* exclusively on Microchip PICmicro Microcontroller products. The      ;
;* software is owned by the Company and/or its supplier, and is         ;
;* protected under applicable copyright laws. All rights are reserved.  ;
;* Any use in violation of the foregoing restrictions may subject the   ;
;* user to criminal sanctions under applicable laws, as well as to      ;
;* civil liability for the breach of the terms and conditions of this   ;
;* license.                                                             ;
;*                                                                      ;
;* THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,    ;
;* WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED    ;
;* TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A          ;
;* PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,    ;
;* IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR           ;
;* CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.                    ;
;*                                                                      ;
;*                                                                      ;
;* ANY SPECIAL DESCRIPTION THAT MIGHT BE USEFUL FOR THIS FILE.          ;
;*                                                                      ;
;* Author               Date            Comment                         ;
;*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~;
;* Vidyadhar       May 14, 2003    Initial Release (V1.0)               ;
;*                                                                      ;
;***********************************************************************;


;***********************************************************************;
;_SPISINTCODE                                                           ;
                                                                        ;
;***********************************************************************;


_SPISINTINIT    CODE                            
;***********************************************************************;
; Function: SPISIntInit                                                 ;
;                                                                       ;
; PreCondition: None                                                    ;
;                                                                       ;
; Overview:                                                             ;
;       This routine is used for MSSP/SSP/BSSP Module Initialization    ;
;       It initializes Module according to compile time selection and   ;
;       flushes the Rx and Tx buffer. It clears all SPI errors          ;
;                                                                       ;
; Input: MpAM options                                                   ;
;                                                                       ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: Bank selection bits and 'W' register are changed        ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
SPISIntInit:                                    ;
                                                ;
        GLOBAL  SPISIntInit                     ;
                                                ;
    #ifdef SPIS_SLAVE_SEL_EN                    ;
                                                ;
        movlw   024h                            ;
                                                ;
    #else                                       ;
                                                ;
        movlw   025h                            ;
                                                ;
    #endif                                      ;
                                                ;
        BANKSEL SSPCON                          ;
        movwf   SSPCON                          ;
        clrf    SSPBUF                          ;
                                                ;
        bsf     INTCON,PEIE                     ;
        bsf     INTCON,GIE                      ;
                                                ;
        bsf     STATUS,RP0                      ;
        bsf     PIE1,SSPIE                      ;clear serial_sync interrupt 
                                                ;
        BANKSEL _vSPISIntTxBufWrPtr             ;
        clrf    _vSPISIntTxBufWrPtr             ;
        clrf    _vSPISIntTxBufRdPtr             ;
        clrf    _vSPISIntRxBufWrPtr             ;
        clrf    _vSPISIntRxBufRdPtr             ;
                                                ;
        clrf    vSPISIntStatus                  ;
        bsf     vSPISIntStatus,SPISSave         ;
        bsf     vSPISIntStatus,SPISTxBufEmpty   ;
        bsf     vSPISIntStatus,SPISRxBufEmpty   ;
                                                ;
        return                                  ;
                                                ;
;***********************************************;



_SPIMINTISR    CODE
;***********************************************************************;
; Function: SPISIntISR                                                  ;
;                                                                       ;
; PreCondition: This has to be called from Interrupt handler            ;
;                                                                       ;
; Overview:                                                             ;
;       This is a Interrupt service routine for Serial Interrupt.       ;
;       It handles Reception and Transmission of data on interrupt.     ;
;       Call it from Interrupt service routine.                         ;
;                                                                       ;
; Input: None                                                           ;
;                                                                       ;
; Output:                                                               ;
;    If data is received it puts it in vSPISIntBuffer and accordingly   ;
;    adjusts the vSPISIntBufWrPtr and clears SPISIntBufEmpty flag.      ;
;    If Buffer becomes full then it will set SPISIntBufFull flag.       ;
;    If data is received when buffer was full it will set SPISBufOF     ;
;    flag to indicate that transmitted data has been missed because     ;
;    of full Buffer. It will set ErrDataNotRcvd flag.                   ;
;                                                                       ;
;    If last data is transmitted then it will transmit next pending     ;
;    data if any. It will accordingly adjust the _vSPIIntBufRdPtr       ;
;    and clears the SPIIntBufFull flag. Which indicates that space      ;
;    is available for data in vSPISIntBuffer.                           ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: 2 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
SPISIntISR:                                     ;
        GLOBAL  SPISIntISR                      ;
                                                ;
        BANKSEL PIR1                            ;
        btfss   PIR1,SSPIF                      ;check which interrupt has occurred sspif
        return                                  ;
                                                ;
        movf    SSPCON,w                        ;
        andlw   00eh                            ;
        xorlw   004h                            ;
        btfss   STATUS,Z                        ;
        return                                  ;check is Slave Mode
                                                ;
;-----------------------------------------------;
                                                ;
        movf    SSPBUF,w                        ;
                                                ;
        #if SPIS_RX_BUF_LENGTH == 1             ;
                                                ;
;;        btfss   vSPISIntStatus,SPISRxBufFull    ;
                                                ;
        movwf   vSPISIntRxBuffer                ;
                                                ;
        #else                                   ;
                                                ;
        BANKSEL _vSPISIntTempReg                ;
        movwf   _vSPISIntTempReg                ;
                                                ;
        #endif                                  ;
                                                ;
        #if SPIS_TX_BUF_LENGTH == 0             ;
                                                ;
        BANKSEL SSPBUF                          ;
        clrf    SSPBUF                          ;
                                                ;
        #else                                   ;
                                                ;
        #if SPIS_TX_BUF_LENGTH == 1             ;
                                                ;
        BANKSEL SSPBUF                          ;
        movf    vSPISIntTxBuffer,W              ;
        movwf   SSPBUF                          ;
                                                ;
        bcf     vSPISIntStatus,SPISTxBufFull    ;
        bsf     vSPISIntStatus,SPISTxBufEmpty   ;
                                                ;
        #else                                   ;
                                                ;
        movlw   000h                            ;
                                                ;
        btfss   vSPISIntStatus,SPISTxBufEmpty   ;
        call    _SPISIntRdTxBuf                 ;
                                                ;
        BANKSEL SSPBUF                          ;
        movwf   SSPBUF                          ;
                                                ;
        #endif                                  ;
        #endif                                  ;
                                                ;
        bcf     PIR1,SSPIF                      ;
                                                ;
        #if SPIS_RX_BUF_LENGTH != 0             ;
                                                ;
        btfsc   vSPISIntStatus,SPISRxBufFull    ;checking is buffer empty
        goto    SPISRxBfFlEr                    ;
                                                ;
        #if SPIS_RX_BUF_LENGTH == 1             ;
                                                ;
        bsf     vSPISIntStatus,SPISRxBufFull    ;
        bcf     vSPISIntStatus,SPISRxBufEmpty   ;
                                                ;
        #else                                   ;
                                                ;
        btfss   vSPISIntStatus,SPISSave         ;checking is buffer empty
        return                                  ;
                                                ;
        BANKSEL _vSPISIntTempReg                ;
        movf    _vSPISIntTempReg,W              ;
                                                ;
        call    _SPISIntWrRxBuf                 ;
                                                ;
        #endif                                  ;
                                                ;
        return                                  ;
                                                ;
SPISRxBfFlEr                                    ;
        bsf     vSPISIntStatus,SPISRxBufOverFlow;
                                                ;
        #endif                                  ;
                                                ;
        return                                  ;
                                                ;
;***********************************************;



        #if SPIS_TX_BUF_LENGTH != 0             ;
                                                ;
        #if SPIS_TX_BUF_LENGTH != 1             ;
                                                ;
;***********************************************************************;
; Function: _SPISIntRdTxBuf                                             ;
;                                                                       ;
; PreCondition: SPISIntRecvEn should have called.                       ;
;                                                                       ;
; Overview:                                                             ;
;       This reads data from buffer.                                    ;
;                                                                       ;
; Input: Buffer                                                         ;
;                                                                       ;
; Output: 'W' Register                                                  ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
_SPISIntRdTxBuf:                                ;
                                                ;
        btfsc   vSPISIntStatus,SPISTxBufEmpty   ;
        return                                  ;
                                                ;
        BANKSEL _vSPISIntDupFSR                 ;
        movf    FSR,w                           ;
        movwf   _vSPISIntDupFSR                 ;
                                                ;
        BANKSEL _vSPISIntTxBufRdPtr             ;
        movlw   vSPISIntTxBuffer                ;load wreg with read pointer address
        addwf   _vSPISIntTxBufRdPtr,w           ;
        movwf   FSR                             ;load fsr with read pointer address
        movf    INDF,w                          ;move wreg the content of read pointer address
                                                ;
        BANKSEL _vSPISIntTempReg                ;
        movwf   _vSPISIntTempReg                ;read data is saved in temflg
                                                ;
        movf    _vSPISIntDupFSR,w               ;
        movwf   FSR                             ;
                                                ;
        BANKSEL _vSPISIntTxBufRdPtr             ;
        incf    _vSPISIntTxBufRdPtr,f           ;increment read pointer
        movlw   SPIS_TX_BUF_LENGTH              ;check for over flow of pointer
        xorwf   _vSPISIntTxBufRdPtr,w           ;
        btfsc   STATUS,Z                        ;
        clrf    _vSPISIntTxBufRdPtr             ;
                                                ;
        movf    _vSPISIntTxBufRdPtr,w           ;
        xorwf   _vSPISIntTxBufWrPtr,w           ;
        btfsc   STATUS,Z                        ;
        bsf     vSPISIntStatus,SPISTxBufEmpty   ;
                                                ;
        BANKSEL _vSPISIntTempReg                ;
        movf    _vSPISIntTempReg,w              ;Get the read data in 'W'
                                                ;
        bcf     vSPISIntStatus,SPISTxBufFull    ;
                                                ;
        return                                  ;
;***********************************************;

        #endif                                  ;
        #endif                                  ;
                                                ;


        #if SPIS_RX_BUF_LENGTH != 0             ;
                                                ;
        #if SPIS_RX_BUF_LENGTH != 1             ;
                                                ;
;***********************************************************************;
; Function: _SPISIntWrRxBuf                                             ;
;                                                                       ;
; PreCondition: None.                                                   ;
;                                                                       ;
; Overview:                                                             ;
;       This writes data into buffer.                                   ;
;                                                                       ;
; Input: 'W' Register                                                   ;
;                                                                       ;
; Output: Buffer                                                        ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
_SPISIntWrRxBuf:                                ;
        btfsc   vSPISIntStatus,SPISRxBufFull    ;
        return                                  ;
                                                ;
                                                ;
        BANKSEL _vSPISIntTempReg                ;
        movwf   _vSPISIntTempReg                ;save the wreg content (data) in temflg
                                                ;
        movf    FSR,w                           ;
        movwf   _vSPISIntDupFSR                 ;
                                                ;
        BANKSEL _vSPISIntRxBufWrPtr             ;
        movlw   vSPISIntRxBuffer                ;load wreg with write pointer address
        addwf   _vSPISIntRxBufWrPtr,w           ;
                                                ;
        movwf   FSR                             ;increment write pointer
        BANKSEL _vSPISIntTempReg                ;
        movf    _vSPISIntTempReg,w              ;read data from SSPBUF
        movwf   INDF                            ;move wreg content to write pointer pointing location
                                                ;
        movf    _vSPISIntDupFSR,w               ;
        movwf   FSR                             ;
                                                ;
        BANKSEL _vSPISIntRxBufWrPtr             ;
        incf    _vSPISIntRxBufWrPtr,f           ;increment write pointer
        movlw   SPIS_RX_BUF_LENGTH              ;check for overflow of pointer
        xorwf   _vSPISIntRxBufWrPtr,w           ;
        btfsc   STATUS,Z                        ;
        clrf    _vSPISIntRxBufWrPtr             ;
                                                ;
        movf    _vSPISIntRxBufWrPtr,w           ;
        xorwf   _vSPISIntRxBufRdPtr,w           ;campare it with write pointer
        btfsc   STATUS,Z                        ;
        bsf     vSPISIntStatus,SPISRxBufFull    ;
                                                ;
        bcf     vSPISIntStatus,SPISRxBufEmpty   ;
                                                ;
        return                                  ;
                                                ;
;***********************************************;

        #endif                                  ;
        #endif                                  ;
                                                ;

        #if SPIS_TX_BUF_LENGTH != 0             ;
        #if SPIS_TX_BUF_LENGTH != 1             ;
                                                ;
_SPISINTPUT    CODE
;***********************************************************************;
; Function: _SPISIntWrTxBuf                                             ;
;                                                                       ;
; PreCondition: None.                                                   ;
;                                                                       ;
; Overview:                                                             ;
;       This writes data into buffer.                                   ;
;                                                                       ;
; Input: 'W' Register                                                   ;
;                                                                       ;
; Output: Buffer                                                        ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
_SPISIntWrTxBuf:                                ;
        GLOBAL  _SPISIntWrTxBuf                 ;
                                                ;
        btfsc   vSPISIntStatus,SPISTxBufFull    ;
        return                                  ;
                                                ;
                                                ;
        BANKSEL _vSPISIntTempReg                ;
        movwf   _vSPISIntTempReg                ;save the wreg content (data) in temflg
                                                ;
        movf    FSR,w                           ;
        movwf   _vSPISIntDupFSR                 ;
                                                ;
        BANKSEL _vSPISIntTxBufWrPtr             ;
        movlw   vSPISIntTxBuffer                ;load wreg with write pointer address
        addwf   _vSPISIntTxBufWrPtr,w           ;
                                                ;
        movwf   FSR                             ;increment write pointer
        BANKSEL _vSPISIntTempReg                ;
        movf    _vSPISIntTempReg,w              ;read data from SSPBUF
        movwf   INDF                            ;move wreg content to write pointer pointing location
                                                ;
        movf    _vSPISIntDupFSR,w               ;
        movwf   FSR                             ;
                                                ;
        BANKSEL _vSPISIntTxBufWrPtr             ;
        incf    _vSPISIntTxBufWrPtr,f           ;increment write pointer
        movlw   SPIS_TX_BUF_LENGTH              ;check for overflow of pointer
        xorwf   _vSPISIntTxBufWrPtr,w           ;
        btfsc   STATUS,Z                        ;
        clrf    _vSPISIntTxBufWrPtr             ;
                                                ;
        movf    _vSPISIntTxBufWrPtr,w           ;
        xorwf   _vSPISIntTxBufRdPtr,w           ;campare it with write pointer
        btfsc   STATUS,Z                        ;
        bsf     vSPISIntStatus,SPISTxBufFull    ;
                                                ;
        bcf     vSPISIntStatus,SPISTxBufEmpty   ;
                                                ;
        return                                  ;
                                                ;
;***********************************************;

        #endif                                  ;
        #endif                                  ;
                                                ;


        #if SPIS_RX_BUF_LENGTH != 0             ;
        #if SPIS_RX_BUF_LENGTH != 1             ;
                                                ;
_SPISINTGET    CODE
;***********************************************************************;
; Function: _SPISIntRdRxBuf                                             ;
;                                                                       ;
; PreCondition: SPISIntRecvEn should have called.                       ;
;                                                                       ;
; Overview:                                                             ;
;       This reads data from buffer.                                    ;
;                                                                       ;
; Input: Buffer                                                         ;
;                                                                       ;
; Output: 'W' Register                                                  ;
;                                                                       ;
; Side Effects: None                                                    ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
_SPISIntRdRxBuf:                                ;
                                                ;
        GLOBAL  _SPISIntRdRxBuf                 ;
                                                ;
        btfsc   vSPISIntStatus,SPISRxBufEmpty   ;
        return                                  ;
                                                ;
        BANKSEL _vSPISIntDupFSR                 ;
        movf    FSR,w                           ;
        movwf   _vSPISIntDupFSR                 ;
                                                ;
        BANKSEL _vSPISIntRxBufRdPtr             ;
        movlw   vSPISIntRxBuffer                ;load wreg with read pointer address
        addwf   _vSPISIntRxBufRdPtr,w           ;
        movwf   FSR                             ;load fsr with read pointer address
        movf    INDF,w                          ;move wreg the content of read pointer address
                                                ;
        BANKSEL _vSPISIntTempReg                ;
        movwf   _vSPISIntTempReg                ;read data is saved in temflg
                                                ;
        movf    _vSPISIntDupFSR,w               ;
        movwf   FSR                             ;
                                                ;
        BANKSEL _vSPISIntRxBufRdPtr             ;
        incf    _vSPISIntRxBufRdPtr,f           ;increment read pointer
        movlw   SPIS_RX_BUF_LENGTH              ;check for over flow of pointer
        xorwf   _vSPISIntRxBufRdPtr,w           ;
        btfsc   STATUS,Z                        ;
        clrf    _vSPISIntRxBufRdPtr             ;
                                                ;
        movf    _vSPISIntRxBufRdPtr,w           ;
        xorwf   _vSPISIntRxBufWrPtr,w           ;
        btfsc   STATUS,Z                        ;
        bsf     vSPISIntStatus,SPISRxBufEmpty   ;
                                                ;
        BANKSEL _vSPISIntTempReg                ;
        movf    _vSPISIntTempReg,w              ;
                                                ;
        bcf     vSPISIntStatus,SPISRxBufFull    ;
        bcf     vSPISIntStatus,SPISRxBufOverFlow;
                                                ;
        return                                  ;
;***********************************************;

        #endif                                  ;
        #endif                                  ;
                                                ;


        #if SPIS_RX_BUF_LENGTH != 0             ;
                                                ;
_SPISINTDISRXBUF    CODE                            
;***********************************************************************;
; Function: SPISIntDiscardRxBuf                                         ;
;                                                                       ;
; PreCondition: None.                                                   ;
;                                                                       ;
; Overview:                                                             ;
;       This flushes the buffer.                                        ; 
;                                                                       ;
; Input: None                                                           ;
;                                                                       ;
; Output: None                                                          ;
;                                                                       ;
; Side Effects: Bank selection bits are changed                         ;
;                                                                       ;
; Stack requirement: 1 level deep                                       ;
;                                                                       ;
;***********************************************;***********************;
                                                ;
SPISIntDiscardRxBuf:                            ;
        GLOBAL  SPISIntDiscardRxBuf             ;
                                                ;
        clrf    _vSPISIntRxBufRdPtr             ;
        clrf    _vSPISIntRxBufWrPtr             ;
        bsf     vSPISIntStatus,SPISRxBufEmpty   ;
        bcf     vSPISIntStatus,SPISRxBufFull    ;
                                                ;
        return                                  ;
                                                ;
;***********************************************;

        #endif                                  ;
                                                ;


;***********************************************;
;       END                                     ;
;***********************************************;

