;*******************************************************************************;
;*                                                                              ;
;*  This implements a generic library functionality to support SPI Slave        ;
;*  for PIC16/PIC18 family                                                      ;
;*  It adds additional functionality of Rx/Tx user defined Cicular buffer       ;
;*                                                                              ;
;*******************************************************************************;
;* FileName:            SPISInt.asm                                     ;
;* Dependencies:        P16xxx.inc                                      ;
;*                      P18xxx.inc                                      ;
;*                      SPISInt.Def                                     ;
;*                      SPISInt.Inc                                     ;
;* Processor:           PIC16xxxx/PIC18xxxx                             ;
;* Assembler:           MPASMWIN 02.70.02 or higher                     ;
;* Linker:              MPLINK 2.33.00 or higher                        ;
;* Company:             Microchip Technology, Inc.                      ;
;*                                                                      ;
;* Software License Agreement                                           ;
;*                                                                      ;
;* The software supplied herewith by Microchip Technology Incorporated  ;
;* (the "Company") for its PICmicro Microcontroller is intended and    ;
;* supplied to you, the Company's customer, for use solely and          ;
;* exclusively on Microchip PICmicro Microcontroller products. The      ;
;* software is owned by the Company and/or its supplier, and is         ;
;* protected under applicable copyright laws. All rights are reserved.  ;
;* Any use in violation of the foregoing restrictions may subject the   ;
;* user to criminal sanctions under applicable laws, as well as to      ;
;* civil liability for the breach of the terms and conditions of this   ;
;* license.                                                             ;
;*                                                                      ;
;* THIS SOFTWARE IS PROVIDED IN AN "AS IS" CONDITION. NO WARRANTIES,    ;
;* WHETHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING, BUT NOT LIMITED    ;
;* TO, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A          ;
;* PARTICULAR PURPOSE APPLY TO THIS SOFTWARE. THE COMPANY SHALL NOT,    ;
;* IN ANY CIRCUMSTANCES, BE LIABLE FOR SPECIAL, INCIDENTAL OR           ;
;* CONSEQUENTIAL DAMAGES, FOR ANY REASON WHATSOEVER.                    ;
;*                                                                      ;
;*                                                                      ;
;* ANY SPECIAL DESCRIPTION THAT MIGHT BE USEFUL FOR THIS FILE.          ;
;*                                                                      ;
;* Author               Date            Comment                         ;
;*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~;
;* Vidyadhar       May 15, 2003    Initial Release (V1.0)               ;
;*                                                                      ;
;***********************************************;***********************;
                                                ;
#define BSSP_MODULE                             ;Module definitions to generate error message for
#define _GEN_MODULE_ERROR                       ;Processor which do not have these module.
                                                ;
#define _ADD_PROC_INC_FILE                      ;
                                                ;
    #include "P16xxx.inc"                       ;
                                                ;
#define MSSP_MODULE                             ;
                                                ;
    #include "P18xxx.inc"                       ;
                                                ;
#define SPISInt_Source                          ;
                                                ;
    #include "SPISInt.Inc"                      ;
                                                ;
                                                ;
;***********************************************;

;***********************************************;
                                                ;
    #ifdef    _PIC18xxx                         ;
I2CMSV    UDATA_ACS                             ;
    #else                                       ;
I2CMSV    UDATA_SHR                             ;
    #endif                                      ;
                                                ;
vSPISIntStatus      RES 1                       ;SPI Mas Communication Status/Error Register
                                                ;
SPISSV1    UDATA                                ;
                                                ;
_vSPISIntTxBufRdPtr RES 1                       ;SPIS Buffer Read Pointer
_vSPISIntTxBufWrPtr RES 1                       ;SPIS Buffer Write Pointer
_vSPISIntRxBufRdPtr RES 1                       ;SPIS Buffer Read Pointer
_vSPISIntRxBufWrPtr RES 1                       ;SPIS Buffer Write Pointer
                                                ;
SPISOV    UDATA_OVR                             ;
                                                ;
_vSPISIntTempReg    RES 1                       ;For temporary use
_vSPISIntDupFSR     RES 1                       ;Storage for FSR/FSR0L
    #ifdef   _PIC18xxx                          ;
_vSPISIntDupFSRH    RES 1                       ;Storage for FSR0H
    #endif                                      ;
                                                ;
    #if SPIS_TX_BUF_LENGTH != 1                 ;
SPISVT   UDATA                                  ;
    #else                                       ;
        #ifdef    _PIC18xxx                     ;
SPISVT   UDATA_ACS                              ;
        #else                                   ;
SPISVT   UDATA_SHR                              ;
        #endif                                  ;
    #endif                                      ;
                                                ;
vSPISIntTxBuffer    RES SPIS_TX_BUF_LENGTH      ;SPIS Buffer
                                                ;
    #if SPIS_RX_BUF_LENGTH != 1                 ;
SPISVR   UDATA                                  ;
    #else                                       ;
        #ifdef    _PIC18xxx                     ;
SPISVR   UDATA_ACS                              ;
        #else                                   ;
SPISVR   UDATA_SHR                              ;
        #endif                                  ;
    #endif                                      ;
                                                ;
vSPISIntRxBuffer    RES SPIS_RX_BUF_LENGTH      ;SPIS Buffer
                                                ;
;***********************************************;


;***********************************************;
                                                ;
                                                ;
    #ifdef   _PIC18xxx                          ;
    #include "18SPISI.asm"                      ;
    #endif                                      ;
                                                ;
    #ifdef   _PIC16xxx                          ;
    #include "16SPISI.asm"                      ;
    #endif                                      ;
                                                ;
                                                ;
;***********************************************;

        END                                     ;

;***********************************************;
