/**
 ** iob.c
 **
 ** Copyright 1990, 1991 by Randy Sargent.
 **
 ** The author hereby grants to MIT permission to use this software.
 ** The author also grants to MIT permission to distribute this software
 ** to schools for non-commercial educational use only.
 **
 ** The author hereby grants to other individuals or organizations
 ** permission to use this software for non-commercial
 ** educational use only.  This software may not be distributed to others
 ** except by MIT, under the conditions above.
 **
 ** Other than these cases, no part of this software may be used or
 ** distributed without written permission of the author.
 **
 ** Neither the author nor MIT make any representations about the 
 ** suitability of this software for any purpose.  It is provided 
 ** "as is" without express or implied warranty.
 **
 ** Randy Sargent
 ** Research Specialist
 ** MIT Media Lab
 ** 20 Ames St.  E15-301
 ** Cambridge, MA  02139
 ** E-mail:  rsargent@athena.mit.edu
 **
 **/


#include CONFIG

#if defined(UNIX)
#include "iob_unix.c"
#elif defined(PC)
#include "iob_pc.c"
#elif defined(MAC)
#include "iob_mac.c"
#else
#error 
#endif

/* machine independent code goes here: */
#include <stdio.h>
#include <string.h>

#include "util.h"
#include "byteq.h"
#include "stringlb.h"
/*#include "filelib.h"*/

#include "iob.h"

Int io_delay_factor= 1;
Int io_hex_on_serial= 0;
Int io_disable_xy= 0;

#ifndef DEFAULT_SERIAL_PORT
#define DEFAULT_SERIAL_PORT ""
#endif

char *io_default_serial_name = DEFAULT_SERIAL_PORT;

Int io_debug= 0;

void io_set_delay_factor(Int f)
{
    if (f < 1) f= 1;
    if (f > 100) f= 100;
    io_delay_factor= f;
}

void io_set_hex_on_serial(Int hex)
{
    io_hex_on_serial= hex;
}

void io_set_extended_charset(IOStream *s, Int extended)
{
    s->extended_charset= extended;
}

/*******************/
/* SERIAL ROUTINES */
/*******************/

Int io_screen_dims(IOStream *s, Int *x, Int *y)
{
    UNUSED(s); /* TODO: fix me */
    *x= 80;
    *y= 24;
    return 0;
}

Int io_printf(IOStream *s, char *format, ...)
{
    va_list args;
    Int ret;

    va_start(args, format);
    ret= io_vprintf(s, format, args);
    va_end(args);
    return ret;
}

Int io_vprintf(IOStream *s, char *format, va_list args)
{
    char buf[2000];
    Int ret;

    ret= vsprintf(buf, format, args);
    io_putstring(s, buf);
    return ret;
}

Int io_getchar(IOStream *s, Int timeout)
{
    IOStream *streams[2];
    Int which;
    Int ret;
    streams[0]= s;
    streams[1]= 0;
    ret= io_getchar_multiple_inputs(streams, &which, timeout);
    if (io_debug)
      if (32 <= ret && ret <= 127)
	printf("getchar %ld >%c<\n", ret, (int)ret);
      else
	printf("getchar %ld\n", ret);
    return ret;
}


void io_putstring(IOStream *s, char *foo)
{
    io_putchars(s, foo, strlen(foo));
}

void io_putchars(IOStream *s, char *foo, Int len)
{
    while (1) {
	int xfer= len;
	int space= BYTEQUEUE_SPACE(&s->outbuf);
	if (xfer > space) xfer= space;
	if (xfer) bytequeue_add(&s->outbuf, foo, xfer);
	foo += xfer;
	len -= xfer;
	if (!len) break;
	io_flush(s);
    }
}

void io_putchar(Int c, IOStream *s)
{
    if (BYTEQUEUE_FULL(&s->outbuf)) io_flush(s);
    bytequeue_add_char(&s->outbuf, c);
}

Int io_getchar_multiple_inputs(IOStream **inputs, Int *which, Int timeout)
{
    Int n;
    for (n= 0; inputs[n]; n++);
    return io_getchar_multiple_inputs_n(inputs, which, timeout, n);
}

void io_flush(IOStream *s)
{
    char buffer[1024];
    Int i= 0, wrote;
    if (!BYTEQUEUE_EMPTY(&s->outbuf)) {
	i= BYTEQUEUE_LENGTH(&s->outbuf);
	bytequeue_remove(&s->outbuf, buffer, i);
	/*if (s->stream == 0) return;*/
	wrote= io_write (s, buffer, i);
	if (wrote != i) {
	    perror("write");
	    fprintf(stderr,
		    "Error on write: stream %s.  Tried to write %ld chars, ret= %ld\n",
		    s->name,
		    i, wrote);
	} else {
	   /* fprintf(stderr, "%s: wrote %ld chars\n", s->name, wrote); */
	}
    }
}

void io_get_line(IOStream *in, char *buf, int maxlen)
{
    int i;
    int c;
    for (i= 0; i< maxlen-1; i++) {
	c= io_getchar(in, -1);
	if (c == '\n' || c == '\r') {
	    break;
	}
	buf[i]= c;
    }
    buf[i]= 0;
    return;
}

void io_discard_input(IOStream *s)
{
    while (io_getchar(s, 0) != EOF);
}

Int io_read_from_buffer(IOStream *input, char *buf, Int nbytes)
{
    int buffer_len= BYTEQUEUE_LENGTH(&input->inbuf);
    if (nbytes > buffer_len) nbytes= buffer_len;
    if (nbytes) {
	bytequeue_remove(&input->inbuf, buf, nbytes);
    }
    return nbytes;
}

#ifdef STAND_ALONE
NOPROTO void main(Int argc, char **argv) /*__ no proto */
{
    IOStream *kbd= io_open_stdin();
    IOStream *ser= io_open_serial(io_default_serial_name);
    IOStream *streams[3];
    Int i;

    streams[0]= kbd;
    streams[1]= ser;
    streams[2]= 0;
    
    for (i= 0; i< 3; i++) {
	Int c, which;
	
	c= io_getchar_multiple_inputs(streams, &which, 5000);
	printf("Got a char %d >%c< from %d\n", c, c, which);
    }

}
#endif 
