#include <stdio.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>

int socket_server_listen_socket[10];
int socket_server_port[10];
struct sockaddr_in socket_server_address[10];

int socket_server_init(int n, int port)
{
    int s;

    socket_server_port[n]= port;

    s=socket(AF_INET, SOCK_STREAM, 0);
    if (s < 0) {
	fprintf(stderr, "Couldn't open socket %d\n", port);
	exit(1);
    }
    
    socket_server_address[n].sin_family = AF_INET;
    socket_server_address[n].sin_addr.s_addr = htonl(INADDR_ANY);
    socket_server_address[n].sin_port = htons(port);
    
    if (bind(s, (struct sockaddr *) &socket_server_address[n],
	     sizeof(socket_server_address[n]))) {
	fprintf(stderr, "Couldn't bind socket\n");
	perror("bind socket");
	close(s);
	exit(-1);
    }
    listen(s, 5);

    socket_server_listen_socket[n]= s;
    return s;
}

int socket_server_accept(int n)
{
    int addr_length, f;
    addr_length= sizeof(socket_server_address[n]);
    f = accept(socket_server_listen_socket[n],
	       &socket_server_address[n], &addr_length);
    if (f < 0) {
	fprintf(stderr, "Error in accept\n");
	perror("accept socket");
	return(-1);
    }
    #if 0
    printf("Connection accepted\n");
    write(f, "hi there\n", 9);
    #endif
    return f;
}


