/*  jpilot-Mail
    Copyright (C) 2000 Oliver Kurth

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <time.h>

#include <gtk/gtk.h>
#include "libplugin.h"
#include <pi-mail.h>
#include "masqmail.h"
#include "mail.h"

gboolean msg2jp(message *msg, struct Mail *pMail, gint max_size, guint status_flags)
{
  GList *hdr_node, *data_node;
  header *hdr;
  gint size = 0;

  time_t now = time(NULL);
  struct tm *t = localtime(&now);

  pMail->read = (status_flags & STATUS_READ) ? TRUE : FALSE;
  pMail->signature = FALSE;
  pMail->confirmRead = FALSE;
  pMail->confirmDelivery = FALSE;
  pMail->priority = 1;
  pMail->addressing = FALSE; /* whats that? */

  pMail->date = *t;

  pMail->subject = NULL;
  pMail->from = NULL;
  pMail->to = NULL;
  pMail->cc = NULL;
  pMail->bcc = NULL;
  pMail->replyTo = NULL;
  /* temporarily, dunno what to do with it: */
  pMail->sentTo = NULL;

  foreach(msg->hdr_list, hdr_node){
    header *hdr = (header *)(hdr_node->data);
    switch(hdr->id){
    case HEAD_SUBJECT:
      pMail->subject = g_strchomp(g_strdup(hdr->value));
      break;
    case HEAD_FROM:
      pMail->from = g_strchomp(g_strdup(hdr->value));
      break;
    case HEAD_TO:
      pMail->to = g_strchomp(g_strdup(hdr->value));
      break;
    case HEAD_CC:
      pMail->cc = g_strchomp(g_strdup(hdr->value));
      break;
    case HEAD_BCC:
      pMail->bcc = g_strchomp(g_strdup(hdr->value));
      break;
    case HEAD_REPLY_TO:
      pMail->replyTo = g_strchomp(g_strdup(hdr->value));
      break;
    case HEAD_DATE:
      strptime(hdr->value, "%A, %e %h %Y %T", &(pMail->date));
      break;
    case HEAD_UNKNOWN:
      if(strncmp(hdr->header, "X-Priority", 10) == 0){
	gint val = atoi(hdr->value);
	switch(val){
	case 1:
	case 2:
	  pMail->priority = 0; /* high */
	  break;
	case 3:
	  pMail->priority = 1; /* normal */
	  break;
	case 4:
	case 5:
	  pMail->priority = 2; /* low */
	  break;
	}
      }
    }
  }
  
  pMail->body = g_strdup("");
  foreach(msg->data_list, data_node){
    gchar *line = (gchar *)(data_node->data);
    gchar *tmp_body;

    /* we truncate at whole lines */
    size += strlen(line);
    if(size < max_size){
      tmp_body = pMail->body;
      pMail->body = g_strconcat(tmp_body, line, NULL);
      g_free(tmp_body);
    }else{
      gchar *str = g_strdup_printf("(truncated to around %d bytes)", max_size);
      tmp_body = pMail->body;
      pMail->body = g_strconcat(tmp_body, str, NULL);
      g_free(tmp_body);
      g_free(str);
      break;
    }
  }
  return TRUE;
}

  
