/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp.twohead;

import org.biojava.bio.BioError;
import org.biojava.bio.dp.BackPointer;
import org.biojava.bio.dp.DP;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.IllegalTransitionException;
import org.biojava.bio.dp.ScoreType;
import org.biojava.bio.dp.State;
import org.biojava.bio.dp.twohead.Cell;
import org.biojava.bio.dp.twohead.CellCalculator;
import org.biojava.bio.dp.twohead.CellCalculatorFactory;
import org.biojava.bio.dp.twohead.CellCalculatorFactoryMaker;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;

public class DPInterpreter
implements CellCalculatorFactory {
    private final DP dp;

    public DPInterpreter(DP dP) {
        this.dp = dP;
    }

    public CellCalculator backwards(ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        return new Backward(this.dp, scoreType);
    }

    public CellCalculator forwards(ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        return new Forward(this.dp, scoreType);
    }

    public CellCalculator viterbi(ScoreType scoreType, BackPointer backPointer) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
        return new Viterbi(this.dp, scoreType, backPointer);
    }

    private static class Forward
    implements CellCalculator {
        private final int[][] transitions;
        private final double[][] transitionScores;
        private final State[] states;
        private final State magicalState;

        public Forward(DP dP, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            this.states = dP.getStates();
            this.transitions = dP.getForwardTransitions();
            this.transitionScores = dP.getForwardTransitionScores(scoreType);
            this.magicalState = dP.getModel().magicalState();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void _calcCell(Cell[][] cellArray, boolean bl) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            Cell cell = cellArray[0][0];
            double[] dArray = cell.scores;
            double[] dArray2 = cell.emissions;
            int n = 0;
            while (n < this.states.length) {
                block13: {
                    State state = this.states[n];
                    try {
                        int[] nArray;
                        double[] dArray3;
                        double d;
                        if (bl && state instanceof EmissionState) {
                            dArray[n] = state == this.magicalState ? 0.0 : Double.NaN;
                            break block13;
                        }
                        if (!(state instanceof EmissionState)) {
                            d = 0.0;
                            dArray3 = dArray;
                        } else {
                            d = dArray2[n];
                            if (d == Double.NEGATIVE_INFINITY || Double.isNaN(d)) {
                                dArray[n] = Double.NaN;
                                break block13;
                            }
                            nArray = ((EmissionState)state).getAdvance();
                            dArray3 = cellArray[nArray[0]][nArray[1]].scores;
                        }
                        nArray = this.transitions[n];
                        double[] dArray4 = this.transitionScores[n];
                        double d2 = Double.NaN;
                        double d3 = 0.0;
                        int n2 = 0;
                        while (true) {
                            if (n2 >= nArray.length) {
                                if (!Double.isNaN(d2)) break;
                                dArray[n] = Double.NaN;
                                break block13;
                            }
                            int n3 = nArray[n2];
                            double d4 = dArray3[n3];
                            if (!Double.isNaN(d4) && d4 != Double.NEGATIVE_INFINITY) {
                                double d5;
                                if (Double.isNaN(d2)) {
                                    d2 = d4;
                                }
                                if (!Double.isNaN(d5 = dArray4[n2]) && d5 != Double.NEGATIVE_INFINITY) {
                                    d3 += Math.exp(d4 + d5 - d2);
                                }
                            }
                            ++n2;
                        }
                        dArray[n] = d + Math.log(d3) + d2;
                    }
                    catch (Exception exception) {
                        throw new BioError(exception, "Problem with state " + n + " -> " + this.states[n].getName());
                    }
                    catch (BioError bioError) {
                        throw new BioError(bioError, "Error  with state " + n + " -> " + this.states[n].getName());
                    }
                }
                ++n;
            }
        }

        public void calcCell(Cell[][] cellArray) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            this._calcCell(cellArray, false);
        }

        public void initialize(Cell[][] cellArray) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            this._calcCell(cellArray, true);
        }
    }

    private static class Backward
    implements CellCalculator {
        private final int[][] transitions;
        private final double[][] transitionScores;
        private final State[] states;
        private final State magicalState;

        public Backward(DP dP, ScoreType scoreType) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            this.states = dP.getStates();
            this.transitions = dP.getBackwardTransitions();
            this.transitionScores = dP.getBackwardTransitionScores(scoreType);
            this.magicalState = dP.getModel().magicalState();
        }

        public void _calcCell(Cell[][] cellArray, boolean bl) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            Cell cell = cellArray[0][0];
            double[] dArray = cell.scores;
            int n = this.states.length - 1;
            while (n >= 0) {
                block11: {
                    State state = this.states[n];
                    if (bl && state instanceof EmissionState) {
                        dArray[n] = state == this.magicalState ? 0.0 : Double.NaN;
                    } else {
                        int[] nArray = this.transitions[n];
                        double[] dArray2 = this.transitionScores[n];
                        double[] dArray3 = new double[nArray.length];
                        int n2 = 0;
                        while (n2 < nArray.length) {
                            double d;
                            Cell cell2;
                            int n3 = nArray[n2];
                            State state2 = this.states[n3];
                            if (state2 instanceof EmissionState) {
                                int[] nArray2 = ((EmissionState)state2).getAdvance();
                                cell2 = cellArray[nArray2[0]][nArray2[1]];
                                d = cell2.emissions[n3];
                                if (Double.isNaN(d)) {
                                    dArray[n] = Double.NaN;
                                    break block11;
                                }
                                double[] dArray4 = cell2.scores;
                            } else {
                                cell2 = cell;
                                d = 0.0;
                            }
                            dArray3[n2] = cell2.scores[n3] + d;
                            ++n2;
                        }
                        double d = Double.NaN;
                        double d2 = 0.0;
                        int n4 = 0;
                        while (n4 < nArray.length) {
                            int n5 = nArray[n4];
                            double d3 = dArray3[n4];
                            if (d3 != Double.NEGATIVE_INFINITY && !Double.isNaN(d3)) {
                                double d4;
                                if (Double.isNaN(d)) {
                                    d = d3;
                                }
                                if (!Double.isNaN(d4 = dArray2[n4]) && d4 != Double.NEGATIVE_INFINITY) {
                                    d2 += Math.exp(d3 + d4 - d);
                                }
                            }
                            ++n4;
                        }
                        dArray[n] = Double.isNaN(d) ? Double.NaN : Math.log(d2) + d;
                    }
                }
                --n;
            }
        }

        public void calcCell(Cell[][] cellArray) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            this._calcCell(cellArray, false);
        }

        public void initialize(Cell[][] cellArray) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            this._calcCell(cellArray, true);
        }
    }

    private class Viterbi
    implements CellCalculator {
        private final int[][] transitions;
        private final double[][] transitionScores;
        private final State[] states;
        private final BackPointer TERMINAL_BP;
        private final State magicalState;

        public Viterbi(DP dP, ScoreType scoreType, BackPointer backPointer) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            this.TERMINAL_BP = backPointer;
            this.states = dP.getStates();
            this.transitions = dP.getForwardTransitions();
            this.transitionScores = dP.getForwardTransitionScores(scoreType);
            this.magicalState = dP.getModel().magicalState();
        }

        public void _calcCell(Cell[][] cellArray, boolean bl) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            Cell cell = cellArray[0][0];
            double[] dArray = cell.scores;
            BackPointer[] backPointerArray = cell.backPointers;
            double[] dArray2 = cell.emissions;
            int n = 0;
            while (n < this.states.length) {
                block15: {
                    State state = this.states[n];
                    try {
                        BackPointer[] backPointerArray2;
                        double[] dArray3;
                        double d;
                        if (bl && state instanceof EmissionState) {
                            if (state == this.magicalState) {
                                dArray[n] = 0.0;
                                backPointerArray[n] = this.TERMINAL_BP;
                            } else {
                                dArray[n] = Double.NaN;
                                backPointerArray[n] = null;
                            }
                            break block15;
                        }
                        if (!(state instanceof EmissionState)) {
                            d = 0.0;
                            dArray3 = dArray;
                            backPointerArray2 = backPointerArray;
                        } else {
                            d = dArray2[n];
                            if (d == Double.NEGATIVE_INFINITY || Double.isNaN(d)) {
                                dArray[n] = Double.NaN;
                                backPointerArray[n] = null;
                                break block15;
                            }
                            int[] nArray = ((EmissionState)state).getAdvance();
                            Cell cell2 = cellArray[nArray[0]][nArray[1]];
                            dArray3 = cell2.scores;
                            backPointerArray2 = cell2.backPointers;
                        }
                        double d2 = Double.NEGATIVE_INFINITY;
                        int[] nArray = this.transitions[n];
                        double[] dArray4 = this.transitionScores[n];
                        int n2 = -1;
                        int n3 = 0;
                        while (n3 < nArray.length) {
                            double d3;
                            double d4;
                            int n4 = nArray[n3];
                            double d5 = dArray3[n4];
                            if (d5 != Double.NEGATIVE_INFINITY && !Double.isNaN(d5) && (d4 = (d3 = dArray4[n3]) + d5) > d2) {
                                d2 = d4;
                                n2 = n4;
                            }
                            ++n3;
                        }
                        if (n2 != -1) {
                            dArray[n] = d + d2;
                            try {
                                State state2 = this.states[n];
                                backPointerArray[n] = new BackPointer(state2, backPointerArray2[n2], dArray[n]);
                                break block15;
                            }
                            catch (Throwable throwable) {
                                throw new BioError(throwable, "Couldn't generate backpointer for " + this.states[n].getName() + " back to " + this.states[n2].getName());
                            }
                        }
                        backPointerArray[n] = null;
                        dArray[n] = Double.NaN;
                    }
                    catch (Exception exception) {
                        throw new BioError(exception, "Problem with state " + n + " -> " + this.states[n].getName());
                    }
                    catch (BioError bioError) {
                        throw new BioError(bioError, "Error  with state " + n + " -> " + this.states[n].getName());
                    }
                }
                ++n;
            }
            bl = false;
        }

        public void calcCell(Cell[][] cellArray) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            this._calcCell(cellArray, false);
        }

        public void initialize(Cell[][] cellArray) throws IllegalSymbolException, IllegalAlphabetException, IllegalTransitionException {
            this._calcCell(cellArray, true);
        }
    }

    public static class Maker
    implements CellCalculatorFactoryMaker {
        public CellCalculatorFactory make(DP dP) {
            return new DPInterpreter(dP);
        }
    }
}

