/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import org.biojava.bio.gui.sequence.AbstractForwarder;
import org.biojava.bio.gui.sequence.BasicFeatureRenderer;
import org.biojava.bio.gui.sequence.FeatureRenderer;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.NestedError;

public class FeatureBlockSequenceRenderer
extends AbstractForwarder
implements SequenceRenderer {
    public static ChangeType RENDERER = new ChangeType("The associated FeatureRenderer has changed", "org.biojava.bio.gui.sequence.FeatureBlockSequenceRenderer", "RENDERER");
    private FeatureRenderer renderer;

    public FeatureBlockSequenceRenderer() {
        try {
            this.setFeatureRenderer(new BasicFeatureRenderer());
        }
        catch (ChangeVetoException changeVetoException) {
            throw new NestedError(changeVetoException, "Assertion Failure: Should have no listeners");
        }
    }

    public double getDepth(SequenceRenderContext sequenceRenderContext, int n, int n2) {
        FeatureFilter.OverlapsLocation overlapsLocation;
        Sequence sequence = (Sequence)sequenceRenderContext.getSequence();
        FeatureHolder featureHolder = sequence.filter(overlapsLocation = new FeatureFilter.OverlapsLocation(new RangeLocation(n, n2)), false);
        if (featureHolder.countFeatures() > 0) {
            return this.renderer.getDepth(sequenceRenderContext);
        }
        return 0.0;
    }

    public FeatureRenderer getFeatureRenderer() {
        return this.renderer;
    }

    public double getMinimumLeader(SequenceRenderContext sequenceRenderContext) {
        return 0.0;
    }

    public double getMinimumTrailer(SequenceRenderContext sequenceRenderContext) {
        return 0.0;
    }

    public void paint(Graphics2D graphics2D, SequenceRenderContext sequenceRenderContext, int n, int n2) {
        Shape shape = graphics2D.getClip();
        Rectangle rectangle = graphics2D.getClipBounds();
        Rectangle2D.Double double_ = new Rectangle2D.Double();
        Iterator iterator = ((Sequence)sequenceRenderContext.getSequence()).filter(new FeatureFilter.OverlapsLocation(new RangeLocation(n, n2)), false).features();
        while (iterator.hasNext()) {
            Feature feature = (Feature)iterator.next();
            Location location = feature.getLocation();
            this.renderer.renderFeature(graphics2D, feature, sequenceRenderContext);
        }
    }

    public void setFeatureRenderer(FeatureRenderer featureRenderer) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(RENDERER);
            synchronized (changeSupport2) {
                ChangeEvent changeEvent = new ChangeEvent(this, SequenceRenderContext.LAYOUT, null, null, new ChangeEvent(this, RENDERER, this.renderer, featureRenderer));
                changeSupport.firePreChangeEvent(changeEvent);
                this.setFeatureRendererImpl(featureRenderer);
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.setFeatureRendererImpl(featureRenderer);
        }
    }

    protected void setFeatureRendererImpl(FeatureRenderer featureRenderer) {
        this.unregisterLayout(this.renderer, SequenceRenderContext.LAYOUT);
        this.unregisterRepaint(this.renderer, SequenceRenderContext.REPAINT);
        this.renderer = featureRenderer;
        this.registerLayout(this.renderer, SequenceRenderContext.LAYOUT);
        this.registerRepaint(this.renderer, SequenceRenderContext.REPAINT);
    }
}

