/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.apache.xerces.parsers.DOMParser;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.program.das.DASSequence;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.cache.Cache;
import org.biojava.utils.cache.FixedSizeCache;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DASSequenceDB
implements SequenceDB {
    static boolean USE_XFF = Boolean.getBoolean("org.biojava.use_xff");
    private URL dataSourceURL;
    private Map sequences = new HashMap();
    private Cache symbolsCache = new FixedSizeCache(20);
    private SequenceDB allEntryPoints;

    public DASSequenceDB(URL uRL) throws BioException {
        this.dataSourceURL = uRL;
        try {
            URL uRL2 = new URL(uRL, "entry_points");
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL2.openConnection();
            try {
                httpURLConnection.connect();
            }
            catch (Exception exception) {
                throw new BioException(exception, "Can't connect to " + uRL2);
            }
            int n = httpURLConnection.getHeaderFieldInt("X-DAS-Status", 0);
            if (n == 0) {
                throw new BioException("Not a DAS server");
            }
            if (n != 200) {
                throw new BioException("DAS error (status code = " + n + ") connecting to " + uRL + " with query " + uRL2);
            }
            InputSource inputSource = new InputSource(httpURLConnection.getInputStream());
            DOMParser dOMParser = DASSequence.nonvalidatingParser();
            dOMParser.parse(inputSource);
            Element element = dOMParser.getDocument().getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("SEGMENT");
            Object var9_13 = null;
            int n2 = 0;
            while (n2 < nodeList.getLength()) {
                element = (Element)nodeList.item(n2);
                this.sequences.put(element.getAttribute("id"), null);
                ++n2;
            }
        }
        catch (SAXException sAXException) {
            throw new BioException(sAXException, "Exception parsing DAS XML");
        }
        catch (IOException iOException) {
            throw new BioException(iOException, "Error connecting to DAS server");
        }
        catch (NumberFormatException numberFormatException) {
            throw new BioException(numberFormatException);
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void addSequence(Sequence sequence) throws ChangeVetoException {
        throw new ChangeVetoException("No way we're adding sequences to DAS");
    }

    public SequenceDB allEntryPointsDB() {
        if (this.allEntryPoints == null) {
            this.allEntryPoints = new AllEntryPoints();
        }
        return this.allEntryPoints;
    }

    public String getName() {
        return this.dataSourceURL.toString();
    }

    public Sequence getSequence(String string) {
        if (!this.sequences.containsKey(string)) {
            throw new NoSuchElementException("Couldn't find sequence " + string);
        }
        Sequence sequence = (Sequence)this.sequences.get(string);
        if (sequence == null) {
            try {
                sequence = new DASSequence(this, this.dataSourceURL, string);
            }
            catch (Exception exception) {
                throw new BioError(exception);
            }
            this.sequences.put(string, sequence);
        }
        return sequence;
    }

    Cache getSymbolsCache() {
        return this.symbolsCache;
    }

    public URL getURL() {
        return this.dataSourceURL;
    }

    public Set ids() {
        return this.sequences.keySet();
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void removeSequence(String string) throws ChangeVetoException {
        throw new ChangeVetoException("No way we're removing sequences from DAS");
    }

    public SequenceIterator sequenceIterator() {
        return new SequenceIterator(){
            private Iterator i;
            {
                this.i = DASSequenceDB.this.ids().iterator();
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public Sequence nextSequence() {
                return DASSequenceDB.this.getSequence((String)this.i.next());
            }
        };
    }

    private class AllEntryPoints
    implements SequenceDB {
        AllEntryPoints() {
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        }

        public void addSequence(Sequence sequence) throws ChangeVetoException {
            throw new ChangeVetoException("No way we're adding sequences to DAS");
        }

        public String getName() {
            return "All sequences in " + DASSequenceDB.this.dataSourceURL.toString();
        }

        public Sequence getSequence(String string) throws BioException {
            return new DASSequence(DASSequenceDB.this, DASSequenceDB.this.dataSourceURL, string);
        }

        public Set ids() {
            throw new BioError("ImplementMe");
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        }

        public void removeSequence(String string) throws ChangeVetoException {
            throw new ChangeVetoException("No way we're removing sequences from DAS");
        }

        public SequenceIterator sequenceIterator() {
            throw new BioError("ImplementMe");
        }
    }
}

