/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import org.apache.xerces.parsers.DOMParser;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.symbol.CompoundLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.ChangeVetoException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

class DASXFFParser {
    static final DASXFFParser INSTANCE = new DASXFFParser();

    private DASXFFParser() {
    }

    private String getChildText(Element element) {
        StringBuffer stringBuffer = new StringBuffer();
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Text) {
                stringBuffer.append(((Text)node).getData());
            }
            node = node.getNextSibling();
        }
        return stringBuffer.toString().trim();
    }

    public void parseComponentFeature(Element element, ComponentFeature.Template template) throws ParseException {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Element element2 = (Element)node;
                String string = element2.getTagName();
                if (string.equals("componentID")) {
                    if (template.annotation == null) {
                        template.annotation = new SimpleAnnotation();
                    }
                    try {
                        template.annotation.setProperty("sequence.id", this.getChildText(element2));
                    }
                    catch (ChangeVetoException changeVetoException) {
                        throw new BioError(changeVetoException);
                    }
                } else if (string.equals("componentLocation")) {
                    template.componentLocation = this.parseXFFLocation(element2);
                }
            }
            node = node.getNextSibling();
        }
        this.parseStrandedFeature(element, template);
    }

    public void parseFeature(Element element, Feature.Template template) throws ParseException {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Element element2 = (Element)node;
                String string = element2.getTagName();
                if (string.equals("type")) {
                    template.type = this.getChildText(element2);
                } else if (string.equals("source")) {
                    template.source = this.getChildText(element2);
                } else if (string.equals("location")) {
                    template.location = this.parseXFFLocation(element2);
                } else if (string.equals("id")) {
                    String string2 = this.getChildText(element2);
                    if (template.annotation == null) {
                        template.annotation = new SimpleAnnotation();
                    }
                    try {
                        template.annotation.setProperty("org.biojava.bio.program.das.feature_id", string2);
                    }
                    catch (ChangeVetoException changeVetoException) {
                        throw new BioError(changeVetoException);
                    }
                }
            }
            node = node.getNextSibling();
        }
        if (template.annotation == null) {
            template.annotation = Annotation.EMPTY_ANNOTATION;
        }
    }

    public void parseSegment(Element element, SeqIOListener seqIOListener) throws ParseException {
        String string;
        seqIOListener.startSequence();
        String string2 = element.getAttribute("start");
        if (string2 != null) {
            seqIOListener.addSequenceProperty("sequence.start", string2);
        }
        if ((string = element.getAttribute("stop")) != null) {
            seqIOListener.addSequenceProperty("sequence.stop", string);
        }
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            if (node instanceof Element && (element2 = (Element)node).getTagName().equals("featureSet")) {
                this.parseXFFFeatureSet(element2, seqIOListener);
            }
            node = node.getNextSibling();
        }
        seqIOListener.endSequence();
    }

    public void parseStrandedFeature(Element element, StrandedFeature.Template template) throws ParseException {
        String string = element.getAttribute("strand");
        template.strand = string.equals("-") ? StrandedFeature.NEGATIVE : StrandedFeature.POSITIVE;
        this.parseFeature(element, template);
    }

    public void parseURL(URL uRL, SeqIOListener seqIOListener) throws BioException, ParseException, IOException {
        try {
            HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
            httpURLConnection.connect();
            int n = httpURLConnection.getHeaderFieldInt("X-DAS-Status", 0);
            if (n == 0) {
                throw new BioError("Not a DAS server: " + uRL.toString());
            }
            if (n != 200) {
                throw new BioError("DAS error (status code = " + n + ")");
            }
            InputSource inputSource = new InputSource(httpURLConnection.getInputStream());
            DOMParser dOMParser = new DOMParser();
            dOMParser.parse(inputSource);
            Element element = dOMParser.getDocument().getDocumentElement();
            NodeList nodeList = element.getElementsByTagName("SEGMENT");
            if (nodeList.getLength() != 1) {
                throw new BioException("Non-extended DASFEATURES documents must contain one SEGMENT");
            }
            element = (Element)nodeList.item(0);
            this.parseSegment(element, seqIOListener);
        }
        catch (SAXException sAXException) {
            throw new ParseException(sAXException);
        }
    }

    public void parseXFFFeatureSet(Element element, SeqIOListener seqIOListener) throws ParseException {
        Node node = element.getFirstChild();
        while (node != null) {
            if (node instanceof Element) {
                Feature.Template template;
                Element element2 = (Element)node;
                String string = element2.getTagName();
                if (string.equals("componentFeature")) {
                    template = new ComponentFeature.Template();
                    this.parseComponentFeature(element2, (ComponentFeature.Template)template);
                } else if (string.equals("strandedFeature")) {
                    template = new StrandedFeature.Template();
                    this.parseStrandedFeature(element2, (StrandedFeature.Template)template);
                } else {
                    template = new Feature.Template();
                    this.parseFeature(element2, template);
                }
                seqIOListener.startFeature(template);
                Node node2 = element2.getFirstChild();
                while (node2 != null) {
                    Element element3;
                    if (node2 instanceof Element && (element3 = (Element)node2).getTagName().equals("featureSet")) {
                        this.parseXFFFeatureSet(element3, seqIOListener);
                    }
                    node2 = node2.getNextSibling();
                }
                seqIOListener.endFeature();
            }
            node = node.getNextSibling();
        }
    }

    public Location parseXFFLocation(Element element) throws ParseException {
        ArrayList<Location> arrayList = new ArrayList<Location>();
        Node node = element.getFirstChild();
        while (node != null) {
            Element element2;
            String string;
            if (node instanceof Element && (string = (element2 = (Element)node).getTagName()).equals("span")) {
                Location location = this.parseXFFSpan(element2);
                arrayList.add(location);
            }
            node = node.getNextSibling();
        }
        if (arrayList.size() == 0) {
            return Location.empty;
        }
        if (arrayList.size() == 1) {
            return (Location)arrayList.get(0);
        }
        return new CompoundLocation(arrayList);
    }

    public Location parseXFFSpan(Element element) throws ParseException {
        try {
            String string = element.getAttribute("start");
            String string2 = element.getAttribute("stop");
            int n = Integer.parseInt(string);
            int n2 = Integer.parseInt(string2);
            return new RangeLocation(n, n2);
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(numberFormatException);
        }
    }
}

