/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.xerces.parsers.DOMParser;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.RNAComplementTranslationTable;
import org.biojava.bio.seq.TranscriptionTable;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.AlphabetManager;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.ReversibleTranslationTable;
import org.biojava.bio.symbol.SimpleAlphabet;
import org.biojava.bio.symbol.SimpleTranslationTable;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolListViews;
import org.biojava.bio.symbol.TranslationTable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public final class RNATools {
    private static final ReversibleTranslationTable complementTable;
    private static final ReversibleTranslationTable transcriptionTable;
    private static final FiniteAlphabet rna;
    private static final Map geneticCodes;
    private static final Symbol a;
    private static final Symbol g;
    private static final Symbol c;
    private static final Symbol u;
    private static Map symbolToComplement;
    static /* synthetic */ Class class$org$biojava$bio$seq$RNATools;

    static {
        try {
            rna = (FiniteAlphabet)AlphabetManager.alphabetForName("RNA");
            SymbolList symbolList = rna.getParser("token").parse("agcu");
            a = symbolList.symbolAt(1);
            g = symbolList.symbolAt(2);
            c = symbolList.symbolAt(3);
            u = symbolList.symbolAt(4);
            symbolToComplement = new HashMap();
            Symbol symbol = AlphabetManager.getGapSymbol();
            symbolToComplement.put(symbol, symbol);
            Iterator iterator = ((SimpleAlphabet)rna).ambiguities();
            while (iterator.hasNext()) {
                Symbol symbol2 = (Symbol)iterator.next();
                HashSet<Symbol> hashSet = new HashSet<Symbol>();
                FiniteAlphabet finiteAlphabet = (FiniteAlphabet)symbol2.getMatches();
                Iterator iterator2 = finiteAlphabet.iterator();
                while (iterator2.hasNext()) {
                    hashSet.add(RNATools.complement((Symbol)iterator2.next()));
                }
                symbolToComplement.put(symbol2, rna.getAmbiguity(hashSet));
            }
            complementTable = new RNAComplementTranslationTable();
            transcriptionTable = new TranscriptionTable();
            geneticCodes = new HashMap();
            RNATools.loadGeneticCodes();
        }
        catch (Throwable throwable) {
            throw new BioError(throwable, "Unable to initialize RNATools");
        }
    }

    public static Symbol a() {
        return a;
    }

    public static Symbol c() {
        return c;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static Symbol complement(Symbol symbol) throws IllegalSymbolException {
        if (symbol == a) {
            return u;
        }
        if (symbol == g) {
            return c;
        }
        if (symbol == c) {
            return g;
        }
        if (symbol == u) {
            return a;
        }
        Symbol symbol2 = (Symbol)symbolToComplement.get(symbol);
        if (symbol2 != null) {
            return symbol2;
        }
        RNATools.getRNA().validate(symbol);
        throw new BioError("Realy confused. Can't find symbol " + symbol.getName());
    }

    public static SymbolList complement(SymbolList symbolList) throws IllegalAlphabetException {
        return SymbolListViews.translate(symbolList, RNATools.complementTable());
    }

    public static ReversibleTranslationTable complementTable() {
        return complementTable;
    }

    public static SymbolList createRNA(String string) throws IllegalSymbolException {
        try {
            SymbolParser symbolParser = RNATools.getRNA().getParser("token");
            return symbolParser.parse(string);
        }
        catch (BioException bioException) {
            throw new BioError(bioException, "Something has gone badly wrong with RNA");
        }
    }

    public static Symbol forIndex(int n) throws IndexOutOfBoundsException {
        if (n == 0) {
            return a;
        }
        if (n == 1) {
            return g;
        }
        if (n == 2) {
            return c;
        }
        if (n == 3) {
            return u;
        }
        throw new IndexOutOfBoundsException("No symbol for index " + n);
    }

    public static Symbol forSymbol(char c) throws IllegalSymbolException {
        if (c == 'a') {
            return a;
        }
        if (c == 'g') {
            return g;
        }
        if (c == 'c') {
            return RNATools.c;
        }
        if (c == 'u') {
            return u;
        }
        throw new IllegalSymbolException("Unable to find symbol for token " + c);
    }

    public static Symbol g() {
        return g;
    }

    public static TranslationTable getGeneticCode(String string) {
        return (TranslationTable)geneticCodes.get(string);
    }

    public static Set getGeneticCodeNames() {
        return geneticCodes.keySet();
    }

    public static FiniteAlphabet getRNA() {
        return rna;
    }

    public static int index(Symbol symbol) throws IllegalSymbolException {
        if (symbol == a) {
            return 0;
        }
        if (symbol == g) {
            return 1;
        }
        if (symbol == c) {
            return 2;
        }
        if (symbol == u) {
            return 3;
        }
        RNATools.getRNA().validate(symbol);
        throw new IllegalSymbolException("Realy confused. Can't find index for " + symbol.getName());
    }

    private static void loadGeneticCodes() {
        try {
            InputStream inputStream = (class$org$biojava$bio$seq$RNATools != null ? class$org$biojava$bio$seq$RNATools : (class$org$biojava$bio$seq$RNATools = RNATools.class$("org.biojava.bio.seq.RNATools"))).getClassLoader().getResourceAsStream("org/biojava/bio/seq/TranslationTables.xml");
            if (inputStream == null) {
                throw new BioError("Couldn't locate TranslationTables.xml.");
            }
            InputSource inputSource = new InputSource(inputStream);
            DOMParser dOMParser = new DOMParser();
            dOMParser.parse(inputSource);
            Document document = dOMParser.getDocument();
            NodeList nodeList = document.getDocumentElement().getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Element element;
                String string;
                Node node = nodeList.item(n);
                if (node instanceof Element && (string = (element = (Element)node).getNodeName()).equals("table")) {
                    String string2 = element.getAttribute("name");
                    String string3 = element.getAttribute("source");
                    String string4 = element.getAttribute("target");
                    FiniteAlphabet finiteAlphabet = (FiniteAlphabet)AlphabetManager.alphabetForName(string3);
                    FiniteAlphabet finiteAlphabet2 = (FiniteAlphabet)AlphabetManager.alphabetForName(string4);
                    SymbolParser symbolParser = finiteAlphabet.getParser("name");
                    SymbolParser symbolParser2 = finiteAlphabet2.getParser("name");
                    SimpleTranslationTable simpleTranslationTable = new SimpleTranslationTable(finiteAlphabet, finiteAlphabet2);
                    NodeList nodeList2 = element.getChildNodes();
                    int n2 = 0;
                    while (n2 < nodeList2.getLength()) {
                        Node node2 = nodeList2.item(n2);
                        if (node2 instanceof Element) {
                            Element element2 = (Element)node2;
                            String string5 = element2.getAttribute("from");
                            String string6 = element2.getAttribute("to");
                            SymbolList symbolList = RNATools.createRNA(string5);
                            if (symbolList.length() != 3) {
                                throw new BioError("`" + string5 + "' is not a valid codon");
                            }
                            AtomicSymbol atomicSymbol = (AtomicSymbol)finiteAlphabet.getSymbol(symbolList.toList());
                            AtomicSymbol atomicSymbol2 = (AtomicSymbol)symbolParser2.parseToken(string6);
                            simpleTranslationTable.setTranslation(atomicSymbol, atomicSymbol2);
                        }
                        ++n2;
                    }
                    geneticCodes.put(string2, simpleTranslationTable);
                }
                ++n;
            }
        }
        catch (Exception exception) {
            throw new BioError(exception, "Couldn't parse TranslationTables.xml");
        }
    }

    public static SymbolList reverseComplement(SymbolList symbolList) throws IllegalAlphabetException {
        return SymbolListViews.translate(SymbolListViews.reverse(symbolList), RNATools.complementTable());
    }

    public static SymbolList transcribe(SymbolList symbolList) throws IllegalAlphabetException {
        return SymbolListViews.translate(symbolList, RNATools.transcriptionTable());
    }

    public static ReversibleTranslationTable transcriptionTable() {
        return transcriptionTable;
    }

    public static SymbolList translate(SymbolList symbolList) throws IllegalAlphabetException {
        return SymbolListViews.translate(symbolList, RNATools.getGeneticCode("UNIVERSAL"));
    }

    public static Symbol u() {
        return u;
    }
}

