/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FeatureRealizer;
import org.biojava.bio.seq.RealizingFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleComponentFeature;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.impl.FeatureImpl;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeVetoException;

public class SimpleAssembly
extends AbstractSymbolList
implements Sequence,
RealizingFeatureHolder {
    private int length = 0;
    private String name;
    private String uri;
    private Annotation annotation;
    private SimpleFeatureHolder features;
    private SortedMap components;
    private List componentList;
    private FeatureRealizer featureRealizer = FeatureImpl.DEFAULT;
    private static final Symbol N;

    static {
        try {
            N = DNATools.getDNA().getParser("token").parseToken("n");
        }
        catch (BioException bioException) {
            throw new BioError(bioException);
        }
    }

    public SimpleAssembly(int n, String string, String string2) {
        this.features = new SimpleFeatureHolder();
        this.components = new TreeMap(Location.naturalOrder);
        this.componentList = new ArrayList();
        this.length = n;
        this.name = string;
        this.uri = string2;
    }

    public SimpleAssembly(String string, String string2) {
        this.features = new SimpleFeatureHolder();
        this.components = new TreeMap(Location.naturalOrder);
        this.componentList = new ArrayList();
        this.name = string;
        this.uri = string2;
    }

    public int countFeatures() {
        return this.features.countFeatures();
    }

    public Feature createFeature(Feature.Template template) throws BioException, ChangeVetoException {
        Object object;
        Object object2;
        if (template.location.getMin() < 1) {
            throw new BioException("Coordinates out of range");
        }
        if (template instanceof ComponentFeature.Template) {
            object2 = this.components.keySet().iterator();
            while (object2.hasNext()) {
                object = (Location)object2.next();
                if (!object.overlaps(template.location)) continue;
                throw new BioError("Can't create overlapping ComponentFeature");
            }
        }
        object2 = this.realizeFeature(this, template);
        this.features.addFeature((Feature)object2);
        if (object2 instanceof ComponentFeature) {
            object = (ComponentFeature)object2;
            Location location = object.getLocation();
            SymbolList symbolList = object.getSymbols();
            this.putComponent(location, symbolList);
            this.length = Math.max(this.length, location.getMax());
        }
        return object2;
    }

    public Iterator features() {
        return this.features.features();
    }

    public FeatureHolder filter(FeatureFilter featureFilter, boolean bl) {
        return this.features.filter(featureFilter, bl);
    }

    public Alphabet getAlphabet() {
        return DNATools.getDNA();
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public String getName() {
        return this.name;
    }

    public String getURN() {
        return this.uri;
    }

    public int length() {
        return this.length;
    }

    private Location locationOfPoint(int n) {
        int n2 = 0;
        int n3 = this.componentList.size() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            Location location = (Location)this.componentList.get(n4);
            if (location.contains(n)) {
                return location;
            }
            if (n < location.getMin()) {
                n3 = n4 - 1;
                continue;
            }
            n2 = n4 + 1;
        }
        return null;
    }

    private void putComponent(Location location, SymbolList symbolList) {
        this.components.put(location, symbolList);
        this.componentList.clear();
        this.componentList.addAll(this.components.keySet());
    }

    public Feature realizeFeature(FeatureHolder featureHolder, Feature.Template template) throws BioException {
        if (template instanceof ComponentFeature.Template) {
            if (featureHolder != this) {
                throw new BioException("ComponentFeatures can only be attached directly to SimpleAssembly objects");
            }
            ComponentFeature.Template template2 = (ComponentFeature.Template)template;
            return new SimpleComponentFeature(this, template2);
        }
        FeatureHolder featureHolder2 = featureHolder;
        while (featureHolder2 instanceof Feature) {
            if (featureHolder2 instanceof ComponentFeature) {
                throw new BioException("Cannot [currently] realize features on components of SimpleAssemblies");
            }
            featureHolder2 = ((Feature)featureHolder2).getParent();
        }
        return this.featureRealizer.realizeFeature(this, featureHolder, template);
    }

    private void removeComponent(Location location) {
        this.components.remove(location);
        this.componentList.clear();
        this.componentList.addAll(this.components.keySet());
    }

    public void removeFeature(Feature feature) throws ChangeVetoException {
        if (feature instanceof ComponentFeature) {
            this.removeComponent(feature.getLocation());
        }
        this.features.removeFeature(feature);
    }

    public SymbolList subList(int n, int n2) {
        Location location = this.locationOfPoint(n);
        if (location.contains(n2)) {
            SymbolList symbolList = (SymbolList)this.components.get(location);
            int n3 = n - location.getMin() + 1;
            int n4 = n2 - location.getMin() + 1;
            return symbolList.subList(n3, n4);
        }
        return super.subList(n, n2);
    }

    public Symbol symbolAt(int n) {
        Location location = this.locationOfPoint(n);
        if (location != null) {
            SymbolList symbolList = (SymbolList)this.components.get(location);
            return symbolList.symbolAt(n - location.getMin() + 1);
        }
        return N;
    }
}

