/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.db;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.db.IDMaker;
import org.biojava.bio.seq.db.SequenceDB;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class HashSequenceDB
implements SequenceDB,
Serializable {
    private final Map sequenceByID = new HashMap();
    private final IDMaker idMaker;
    private String name;
    protected transient ChangeSupport changeSupport = null;

    public HashSequenceDB() {
        this(IDMaker.byName, null);
    }

    public HashSequenceDB(String string) {
        this(IDMaker.byName, string);
    }

    public HashSequenceDB(IDMaker iDMaker) {
        this(iDMaker, null);
    }

    public HashSequenceDB(IDMaker iDMaker, String string) {
        this.idMaker = iDMaker;
        this.name = string;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.generateChangeSupport(null);
        this.changeSupport.addChangeListener(changeListener);
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.generateChangeSupport(changeType);
        this.changeSupport.addChangeListener(changeListener, changeType);
    }

    public void addSequence(String string, Sequence sequence) throws ChangeVetoException {
        if (this.changeSupport == null) {
            this.sequenceByID.put(string, sequence);
        } else {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                ChangeEvent changeEvent = new ChangeEvent(this, SequenceDB.SEQUENCES, new Object[]{string, sequence}, null);
                this.changeSupport.firePreChangeEvent(changeEvent);
                this.sequenceByID.put(string, sequence);
                this.changeSupport.firePostChangeEvent(changeEvent);
            }
        }
    }

    public void addSequence(Sequence sequence) throws ChangeVetoException {
        String string = this.idMaker.calcID(sequence);
        this.addSequence(string, sequence);
    }

    protected void generateChangeSupport(ChangeType changeType) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
    }

    public IDMaker getIDMaker() {
        return this.idMaker;
    }

    public String getName() {
        return this.name;
    }

    public Sequence getSequence(String string) {
        return (Sequence)this.sequenceByID.get(string);
    }

    public Set ids() {
        return this.sequenceByID.keySet();
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.changeSupport.removeChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.changeSupport.removeChangeListener(changeListener, changeType);
    }

    public void removeSequence(String string) throws BioException, ChangeVetoException {
        if (this.changeSupport == null) {
            this.sequenceByID.remove(string);
        } else {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                ChangeEvent changeEvent = new ChangeEvent(this, SequenceDB.SEQUENCES, null, string);
                this.changeSupport.firePreChangeEvent(changeEvent);
                this.sequenceByID.remove(string);
                this.changeSupport.firePostChangeEvent(changeEvent);
            }
        }
    }

    public SequenceIterator sequenceIterator() {
        return new SequenceIterator(this){
            Iterator seqI;
            {
                this.seqI = hashSequenceDB.sequenceByID.values().iterator();
            }

            public boolean hasNext() {
                return this.seqI.hasNext();
            }

            public Sequence nextSequence() {
                return (Sequence)this.seqI.next();
            }
        };
    }
}

