/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.util.ArrayList;
import java.util.List;
import org.biojava.bio.seq.io.ChunkedSymbolList;
import org.biojava.bio.seq.io.SubArraySymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;

class ChunkedSymbolListBuilder {
    private static final int CHUNK_SIZE = 4096;
    private List chunkL = new ArrayList();
    private Symbol[] headChunk = null;
    private int headChunkPos = 0;
    private Alphabet alpha = null;

    ChunkedSymbolListBuilder() {
    }

    public void addSymbols(Alphabet alphabet, Symbol[] symbolArray, int n, int n2) throws IllegalAlphabetException {
        if (this.alpha == null) {
            this.alpha = alphabet;
        } else if (this.alpha != alphabet) {
            throw new IllegalAlphabetException("Alphabet changed!");
        }
        if (this.headChunk == null) {
            this.headChunk = new Symbol[4096];
            this.headChunkPos = 0;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (this.headChunkPos == 4096) {
                this.chunkL.add(this.headChunk);
                this.headChunk = new Symbol[4096];
                this.headChunkPos = 0;
            }
            int n4 = Math.min(n2 - n3, 4096 - this.headChunkPos);
            System.arraycopy(symbolArray, n + n3, this.headChunk, this.headChunkPos, n4);
            n3 += n4;
            this.headChunkPos += n4;
        }
    }

    public SymbolList makeSymbolList() {
        Symbol[] symbolArray;
        if (this.headChunkPos > 0) {
            if (this.headChunkPos < 4096) {
                symbolArray = this.headChunk;
                this.headChunk = new Symbol[this.headChunkPos];
                System.arraycopy(symbolArray, 0, this.headChunk, 0, this.headChunkPos);
            }
            this.chunkL.add(this.headChunk);
        }
        if (this.chunkL.size() == 0) {
            return SymbolList.EMPTY_LIST;
        }
        if (this.chunkL.size() == 1) {
            return new SubArraySymbolList((Symbol[])this.chunkL.get(0), this.headChunkPos, 0, this.alpha);
        }
        symbolArray = new Symbol[this.chunkL.size()][];
        int n = 0;
        while (n < this.chunkL.size()) {
            symbolArray[n] = (Symbol[])this.chunkL.get(n);
            ++n;
        }
        int n2 = (this.chunkL.size() - 1) * 4096 + this.headChunkPos;
        return new ChunkedSymbolList((Symbol[][])symbolArray, 4096, n2, this.alpha);
    }
}

