/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.biojava.bio.symbol.CompoundLocation;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;

public class RangeLocation
implements Location,
Serializable {
    private int min;
    private int max;

    public RangeLocation(int n, int n2) throws IndexOutOfBoundsException {
        if (n2 < n) {
            throw new IndexOutOfBoundsException("max must exceed min: min=" + n + ", max=" + n2);
        }
        this.min = n;
        this.max = n2;
    }

    public Iterator blockIterator() {
        return Collections.singleton(this).iterator();
    }

    public boolean contains(int n) {
        return this.getMin() <= n && this.getMax() >= n;
    }

    public boolean contains(Location location) {
        return this.getMin() <= location.getMin() && this.getMax() >= location.getMax();
    }

    public boolean equals(Location location) {
        return this.getMin() == location.getMin() && this.getMax() == location.getMax() && location.isContiguous();
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public Location intersection(Location location) {
        int n;
        int n2 = Math.max(this.getMin(), location.getMin());
        if (n2 <= (n = Math.min(this.getMax(), location.getMax()))) {
            return new RangeLocation(n2, n);
        }
        return Location.empty;
    }

    public boolean isContiguous() {
        return true;
    }

    public boolean overlaps(Location location) {
        return (this.getMin() > location.getMax() || this.getMax() < location.getMin()) ^ true;
    }

    public SymbolList symbols(SymbolList symbolList) {
        return symbolList.subList(this.getMin(), this.getMax());
    }

    public String toString() {
        return "[" + this.getMin() + ", " + this.getMax() + "]";
    }

    public Location translate(int n) {
        if (n == 0) {
            return this;
        }
        return new RangeLocation(this.getMin() + n, this.getMax() + n);
    }

    public Location union(Location location) {
        ArrayList<Location> arrayList = new ArrayList<Location>(2);
        arrayList.add(this);
        arrayList.add(location);
        return new CompoundLocation(arrayList);
    }
}

