/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

public class ChangeSupport {
    private int listenerCount = 0;
    private int delta;
    private Reference[] listeners;
    private ChangeType[] types;

    public ChangeSupport() {
        this(5);
    }

    public ChangeSupport(int n) {
        this(n, 5);
    }

    public ChangeSupport(int n, int n2) {
        this.listeners = new Reference[n];
        this.types = new ChangeType[n];
        this.delta = n2;
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.addChangeListener(changeListener, null);
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.growIfNecisary();
        this.types[this.listenerCount] = changeType;
        this.listeners[this.listenerCount] = new WeakReference<ChangeListener>(changeListener);
        ++this.listenerCount;
    }

    public void firePostChangeEvent(ChangeEvent changeEvent) {
        boolean bl = false;
        ChangeType changeType = changeEvent.getType();
        int n = 0;
        while (n < this.listenerCount) {
            ChangeType changeType2 = this.types[n];
            if (changeType2 == null || changeType2 == changeType) {
                ChangeListener changeListener = (ChangeListener)this.listeners[n].get();
                if (changeListener != null) {
                    changeListener.postChange(changeEvent);
                } else {
                    bl = true;
                }
            }
            ++n;
        }
        if (bl) {
            this.reapGarbageListeners();
        }
    }

    public void firePreChangeEvent(ChangeEvent changeEvent) throws ChangeVetoException {
        boolean bl = false;
        ChangeType changeType = changeEvent.getType();
        int n = 0;
        while (n < this.listenerCount) {
            ChangeType changeType2 = this.types[n];
            if (changeType2 == null || changeType2 == changeType) {
                ChangeListener changeListener = (ChangeListener)this.listeners[n].get();
                if (changeListener != null) {
                    changeListener.preChange(changeEvent);
                } else {
                    bl = true;
                }
            }
            ++n;
        }
        if (bl) {
            this.reapGarbageListeners();
        }
    }

    protected void growIfNecisary() {
        if (this.listenerCount == this.listeners.length) {
            int n = this.listenerCount + this.delta;
            Reference[] referenceArray = new Reference[n];
            ChangeType[] changeTypeArray = new ChangeType[n];
            System.arraycopy(this.listeners, 0, referenceArray, 0, this.listenerCount);
            System.arraycopy(this.types, 0, changeTypeArray, 0, this.listenerCount);
            this.listeners = referenceArray;
            this.types = changeTypeArray;
        }
    }

    protected void reapGarbageListeners() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.listenerCount) {
            Reference reference = this.listeners[n2];
            if (reference.get() != null) {
                this.types[n] = this.types[n2];
                this.listeners[n] = reference;
                ++n;
            }
            ++n2;
        }
        this.listenerCount = n;
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.removeChangeListener(changeListener, null);
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        int n = 0;
        while (n < this.listenerCount) {
            if (this.listeners[n].get() == changeListener && this.types[n] == changeType) {
                --this.listenerCount;
                System.arraycopy(this.listeners, n + 1, this.listeners, n, this.listenerCount - n);
                System.arraycopy(this.types, n + 1, this.types, n, this.listenerCount - n);
                return;
            }
            ++n;
        }
    }
}

