/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.parser;

final class ContentModel {
    public char type;
    public Object content;
    public ContentModel next;

    public ContentModel(char type, ContentModel content) {
        this.type = type;
        this.content = content;
    }

    public ContentModel(String element) {
        this.type = '\u0000';
        this.content = element;
    }

    public boolean empty() {
        switch (this.type) {
            case '*': 
            case '?': {
                return true;
            }
            case '\u0000': 
            case '+': {
                return false;
            }
            case '|': {
                if (this.content instanceof ContentModel && ((ContentModel)this.content).empty()) {
                    return true;
                }
                ContentModel m = this.next;
                while (m != null) {
                    if (m.empty()) {
                        return true;
                    }
                    m = m.next;
                }
                return false;
            }
            case ',': {
                if (this.content instanceof ContentModel) {
                    if (!((ContentModel)this.content).empty()) {
                        return false;
                    }
                } else {
                    return false;
                }
                ContentModel m = this.next;
                while (m != null) {
                    if (!m.empty()) {
                        return false;
                    }
                    m = m.next;
                }
                return true;
            }
        }
        throw new InternalError();
    }

    public boolean first(String token) {
        switch (this.type) {
            case '\u0000': 
            case '*': 
            case '+': 
            case '?': {
                if (this.content instanceof String) {
                    return this.content == token;
                }
                return ((ContentModel)this.content).first(token);
            }
            case ',': {
                if (this.content instanceof String && this.content == token) {
                    return true;
                }
                if (((ContentModel)this.content).first(token)) {
                    return true;
                }
                if (!((ContentModel)this.content).empty()) {
                    return false;
                }
                ContentModel m = this.next;
                while (m != null) {
                    if (m.content instanceof String && m.content == token) {
                        return true;
                    }
                    if (((ContentModel)m.content).first(token)) {
                        return true;
                    }
                    if (!((ContentModel)this.content).empty()) {
                        return false;
                    }
                    m = m.next;
                }
                return false;
            }
            case '|': {
                if (this.content instanceof String && this.content == token) {
                    return true;
                }
                if (((ContentModel)this.content).first(token)) {
                    return true;
                }
                ContentModel m = this.next;
                while (m != null) {
                    if (m.content instanceof String && m.content == token) {
                        return true;
                    }
                    if (((ContentModel)m.content).first(token)) {
                        return true;
                    }
                    m = m.next;
                }
                return false;
            }
        }
        throw new InternalError();
    }

    public String next() {
        switch (this.type) {
            case '*': 
            case '?': 
            case '|': {
                return null;
            }
            case '\u0000': {
                return (String)this.content;
            }
            case '+': 
            case ',': {
                if (this.content instanceof String) {
                    return (String)this.content;
                }
                return ((ContentModel)this.content).next();
            }
        }
        throw new InternalError();
    }
}

