/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.tree;

import com.sun.xml.tree.DomEx;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.NodeEx;
import com.sun.xml.tree.ParentNode;
import com.sun.xml.tree.TreeWalker;
import com.sun.xml.tree.XmlDocument;
import com.sun.xml.tree.XmlWritable;
import com.sun.xml.tree.XmlWriteContext;
import java.io.IOException;
import java.util.Locale;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

abstract class NodeBase
implements Node,
NodeEx,
NodeList,
XmlWritable {
    private ParentNode parent;
    private int parentIndex = -1;
    private XmlDocument ownerDocument;
    private boolean readonly;

    NodeBase() {
    }

    public Node appendChild(Node newChild) throws DOMException {
        throw new DomEx(3);
    }

    public abstract Node cloneNode(boolean var1);

    public NamedNodeMap getAttributes() {
        return null;
    }

    public NodeList getChildNodes() {
        return this;
    }

    public Node getFirstChild() {
        return null;
    }

    public int getIndexOf(Node maybeChild) {
        return -1;
    }

    public String getInheritedAttribute(String name) {
        ElementNode e;
        NodeBase current = this;
        Attr value = null;
        while (!(current instanceof ElementNode && (value = (e = (ElementNode)current).getAttributeNode(name)) != null || (current = current.getParentImpl()) == null)) {
        }
        if (value != null) {
            return value.getValue();
        }
        return null;
    }

    public String getInheritedAttribute(String namespace, String name) {
        ElementNode e;
        NodeBase current = this;
        Attr value = null;
        while (!(current instanceof ElementNode && (value = (e = (ElementNode)current).getAttributeNode(namespace, name)) != null || (current = current.getParentImpl()) == null)) {
        }
        if (value != null) {
            return value.getValue();
        }
        return null;
    }

    public String getLanguage() {
        return this.getInheritedAttribute("xml:lang");
    }

    public Node getLastChild() {
        return null;
    }

    public int getLength() {
        return 0;
    }

    String getMessage(String messageId) {
        return this.getMessage(messageId, null);
    }

    String getMessage(String messageId, Object[] parameters) {
        Locale locale = ((XmlDocument)this.getOwnerDocument()).getLocale();
        return XmlDocument.catalog.getMessage(locale, messageId, parameters);
    }

    public Node getNextSibling() {
        if (this.parent == null) {
            return null;
        }
        if (this.parentIndex < 0 || this.parent.item(this.parentIndex) != this) {
            this.parentIndex = this.parent.getIndexOf(this);
        }
        return this.parent.item(this.parentIndex + 1);
    }

    public abstract String getNodeName();

    public abstract short getNodeType();

    public String getNodeValue() {
        return null;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument;
    }

    ParentNode getParentImpl() {
        return this.parent;
    }

    public Node getParentNode() {
        return this.parent;
    }

    public Node getPreviousSibling() {
        if (this.parent == null) {
            return null;
        }
        if (this.parentIndex < 0 || this.parent.item(this.parentIndex) != this) {
            this.parentIndex = this.parent.getIndexOf(this);
        }
        return this.parent.item(this.parentIndex - 1);
    }

    public boolean hasChildNodes() {
        return false;
    }

    public Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new DomEx(3);
    }

    boolean isReadonly() {
        return this.readonly;
    }

    public Node item(int i) {
        return null;
    }

    public Node removeChild(Node oldChild) throws DOMException {
        throw new DomEx(3);
    }

    public Node replaceChild(Node newChild, Node refChild) throws DOMException {
        throw new DomEx(3);
    }

    public void setNodeValue(String value) {
        if (this.readonly) {
            throw new DomEx(7);
        }
    }

    void setOwnerDocument(XmlDocument doc) {
        this.ownerDocument = doc;
    }

    void setParentNode(ParentNode arg, int index) throws DOMException {
        if (this.parent != null && arg != null) {
            this.parent.removeChild(this);
        }
        this.parent = arg;
        this.parentIndex = index;
    }

    void setReadonly(boolean deep) {
        this.readonly = true;
        if (deep) {
            Node next;
            TreeWalker walker = new TreeWalker(this);
            while ((next = walker.getNext()) != null) {
                ((NodeBase)next).setReadonly(false);
            }
        }
    }

    public void writeChildrenXml(XmlWriteContext context) throws IOException {
    }

    public abstract void writeXml(XmlWriteContext var1) throws IOException;
}

