/*
 *
 *  s t k l o s . h			-- STklos support
 *
 * Copyright (C) 1993,1994,1995 Erick Gallesio - I3S-CNRS/ESSI <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 *
 *            Author: Erick Gallesio [eg@unice.fr]
 *    Creation date:  9-Feb-1994 15:56
 * Last file update: 25-Feb-1995 16:04 
 */

#define STKLOS_VERSION		"2.1"

typedef struct {
  char instance_type;
  SCM clath;	  		/* Name is choosed to avoid conflicts with C++ */
  SCM accessors;
  SCM slots;
} Instance;

extern int STk_tc_instance; 		/* The type field of an instance */

#define TYPE_INSTANCE		00
#define TYPE_GENERIC		01


#define INST(x)		  ((Instance *) (EXTDATA(x)))
#define CLASS_OF(x) 	  (INST(x)->clath)
#define SLOTS_OF(x) 	  (INST(x)->slots)
#define INST_TYPE(x)	  (INST(x)->instance_type)
#define ACCESSORS_OF(x)	  (INST(x)->accessors)
#define PROC_OF(x)	  (INST(x)->proc)

#define THE_SLOT_OF(x, i) (VECT(SLOTS_OF(x))[i])
#define SUBCLASSP(c1, c2) (STk_memq(c2, THE_SLOT_OF(c1, S_cpl)) != Ntruth)

#define INSTANCEP(x)	  (TYPEP(x, STk_tc_instance))
#define CLASSP(x)	  (INSTANCEP(x) && \
			   SUBCLASSP(CLASS_OF(x), VCELL(Intern("<class>"))))

#define NINSTANCEP(x)	  (NTYPEP(x, STk_tc_instance))
#define NCLASSP(x)	  (!CLASSP(x))



#define S_name 			0 	/*a symbol*/
#define S_direct_supers 	1 	/* (class ...) */
#define S_direct_slots		2 	/* ((name . options) ...) */
#define S_cpl			3 	/* (class ...) */
#define S_slots			4	/* ((name . options) ...) */
#define S_nfields		5	/* an integer */
#define S_initializers		6	/* (proc ...) */
#define S_getters_n_setters	7	/* ((slot getter setter) ...) */
#define NUMBER_OF_CLASS_SLOTS	8	


#define S_methods		1	/* offset of methods slot in a <generic> */

#define S_specializers		1	/* offset of spec. slot in a <method> */
#define S_procedure 		2	/* offset of proc. slot in a <method> */


/* Low level functions exported */
SCM STk_make_instance(SCM clath, long  size, int type);
SCM STk_basic_make_class(SCM clath, SCM name, SCM dsupers, SCM dslots);

PRIMITIVE STk_allocate_instance(SCM clath);
PRIMITIVE STk_slot_ref(SCM obj, SCM slot_name);
PRIMITIVE STk_slot_set(SCM obj, SCM slot_name, SCM value);
PRIMITIVE STk_class_of(SCM obj);


