/* 
 * t k - m a i n . c 			-- Initialization of Tk
 *
 * This code initializes the Tk library. It corresponds to a part of the 
 * file main.c of the wish interpreter. 
 *
 *           Author: Erick Gallesio [eg@unice.fr]
 *    Creation date: 13-May-1993 10:59
 * Last file update: 16-Jul-1995 16:16
 *
 *
 * Code used here was originally copyrigthed as shown below:
 *      Copyright 1990-1992 Regents of the University of California.
 *
 *
 * Copyright (C) 1993,1994,1995 Erick Gallesio - I3S-CNRS/ESSI <eg@unice.fr>
 * 
 *
 * Permission to use, copy, and/or distribute this software and its
 * documentation for any purpose and without fee is hereby granted, provided
 * that both the above copyright notice and this permission notice appear in
 * all copies and derived works.  Fees for distribution or use of this
 * software or derived works may only be charged with express written
 * permission of the copyright holder.  
 * This software is provided ``as is'' without express or implied warranty.
 *
 * This software is a derivative work of other copyrighted softwares; the
 * copyright notices of these softwares are placed in the file COPYRIGHTS
 *
 */
#ifdef USE_TK
#include <signal.h>
#include "stk.h"


/*
 * Command used to initialize wish:
 */

static char initCmd[] = "(load (string-append tk_library \"/STk/tk-init.stk\"))";

/*
 * Global variables used by the main program:
 */

static Tk_Window w;			/* The main window for the application.  If
				 	 * NULL then the application no longer
					 * exists. */
Tcl_Interp *STk_main_interp= NULL;	/* Interpreter for this application. */
int Tk_initialized = 0;			/* 1 when Tk is fully initialized */

/*
 * Forward declarations for procedures defined later in this file:
 */

static void DelayedMap _ANSI_ARGS_((ClientData clientData));
static void StructureProc _ANSI_ARGS_((ClientData clientData,
				       XEvent *eventPtr));


/*
 *----------------------------------------------------------------------
 *
 * Tk_main
 *
 *----------------------------------------------------------------------
 */

void Tk_main(int synchronize, char *name, char *fileName, char *Xdisplay,
	     char *geometry)
{
  char *p;
  Tk_3DBorder border;

  STk_main_interp = Tcl_CreateInterp();
#ifdef TCL_MEM_DEBUG
    Tcl_InitMemory(STk_main_interp);
#endif
  
  /*
   * Parse command-line arguments.
   */


  Tcl_SetVar(STk_main_interp, "*geometry*", geometry?geometry: "", TCL_GLOBAL_ONLY);

  if (name == NULL) {
    if (fileName != NULL) {
      p = fileName;
    } else {
      p = STk_Argv0;
    }
    name = strrchr(p, '/');
    if (name != NULL) {
      name++;
    } else {
      name = p;
    }
  }

  /*
   * Initialize the Tk application and arrange to map the main window
   * after the startup script has been executed, if any.  This way
   * the script can withdraw the window so it isn't ever mapped
   * at all.
   */

  
  w = Tk_CreateMainWindow(STk_main_interp, Xdisplay, name, "STk");
  if (w == NULL) {
    fprintf(stderr, "%s\n", STk_main_interp->result);
    exit(1);
  }

  Tk_CreateEventHandler(w, StructureNotifyMask, StructureProc,
			(ClientData) NULL);
  Tk_DoWhenIdle(DelayedMap, (ClientData) NULL);
  if (synchronize) {
    XSynchronize(Tk_Display(w), True);
  }
  Tk_GeometryRequest(w, 200, 200);
  border = Tk_Get3DBorder(STk_main_interp, w, None, "#cccccc");
  if (border == NULL) {
    Tcl_SetResult(STk_main_interp, (char *) NULL, TCL_STATIC);
    Tk_SetWindowBackground(w, WhitePixelOfScreen(Tk_Screen(w)));
  } 
  else {
    Tk_SetBackgroundFromBorder(w, border);
  }
  XSetForeground(Tk_Display(w), DefaultGCOfScreen(Tk_Screen(w)),
		 BlackPixelOfScreen(Tk_Screen(w)));
  

  STk_init_tracevar(); 	/* Initialize the variable tracing mechanism */
  STk_init_glue();
  Tk_initialized = 1;   /* Ok, it's fully initialized		     */

  /*
   * Set the geometry of the main window, if requested.
   */
  
  if (geometry != NULL) {
    if (TCL_OK != Tcl_VarEval(STk_main_interp, "(wm 'geometry *root* '", 
			      geometry, ")", NULL))
      fprintf(stderr, "**** Warning: %s\n", STk_main_interp->result);
  }

  /*
   * Execute Stk's initialization script, followed by the script specified
   * on the command line, if any.
   */
  
  Tcl_GlobalEval(STk_main_interp, initCmd);
}

/*
 *----------------------------------------------------------------------
 *
 * StructureProc --
 *
 *	This procedure is invoked whenever a structure-related event
 *	occurs on the main window.  If the window is deleted, the
 *	procedure modifies "w" to record that fact.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	Variable "w" may get set to NULL.
 *
 *----------------------------------------------------------------------
 */

static void StructureProc(clientData, eventPtr)
     ClientData clientData;	/* Information about window. */
     XEvent *eventPtr;		/* Information about event. */
{
  if (eventPtr->type == DestroyNotify) {
    w = NULL;
  }
}

/*
 *----------------------------------------------------------------------
 *
 * DelayedMap --
 *
 *	This procedure is invoked by the event dispatcher once the
 *	startup script has been processed.  It waits for all other
 *	pending idle handlers to be processed (so that all the
 *	geometry information will be correct), then maps the
 *	application's main window.
 *
 * Results:
 *	None.
 *
 * Side effects:
 *	The main window gets mapped.
 *
 *----------------------------------------------------------------------
 */

static void DelayedMap(clientData)
    ClientData clientData;	/* Not used. */
{

    while (Tk_DoOneEvent(TK_IDLE_EVENTS) != 0) {
	/* Empty loop body. */
    }
    if (w == NULL) {
	return;
    }
    Tk_MapWindow(w);
}

#endif /* USE_TK */
