/*
 *	$Source: /mit/projects/visual/RCS/lookups.c,v $
 *	$Header: lookups.c,v 1.4 87/07/08 09:59:23 joelr Exp $
 */

#include <stdio.h>
#include <X/Xlib.h>
#define LKUPS  
#define READFILE extern
#define AUX extern
#include "prsdefs.h"
#include "lkups.h"
#define FN_MISC extern
#include "functions.h"



int 
lookup(word)
 char *word;
{
  int i;
  static struct lut {
    char *key;
    int value;
  } table[NKEYS] = {
    "package", 1,
    "element", 2,
    "screenset", 3,
    "screen", 4,
    "map", 5,
    "dimension", 6,
    "include", 7,
    "name", 8,
    "next", 9,
    "type", 10,
    "active", 11,
    "label", 12,
    "in", 13,
    "out", 14,
    "icon", 15,
    "filename", 16,
    "pos_in", 17,
    "pos_out", 18,
    "max", 19,
    "min", 20,
    "range", 21,
    "boundary", 22,
    "screen_name", 23,
    "parent", 24,
    "xpos", 25,
    "ypos", 26,
    "width", 27,
    "height", 28,
    "borderwidth", 29,
    "border", 30,
    "background", 31
    };

  for(i=0;i<NKEYS;++i){
    if(strcmp(word,table[i].key) == 0){
      return (table[i].value);
    }
  }
return (NULL);
}






 char *
lookup_type(what,lkup)    /*   type  */
 int 		what;
 Lkup_union 	*lkup;

{
  char 		*blank, *index();
  int 		i;
  static struct lut {
    char *key;
    int value;
  } table[TKEYS] = {
    "video", 1,
    "still", 2,
    "text", 3,
    "window", 4,
    "transparency", 5,
    "tk_widget", 6
    };
	if(what == Key)
	{
  		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
  		 }
  		for(i=0;i<TKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].value);
    			 }
  		 }
 	 }
	else
	{
  		for(i=0;i<TKEYS;++i)
		{
    			if(table[i].value == lkup->val)
			{
      				return ((char *) table[i].key);
    			 }
  		 }
	 }
	return ((char *) FAILURE);
}


 char * 
lookup_boundary(what,lkup)
 int 		what;
 Lkup_union 	*lkup;
{
  char 		*blank, *index();
  int 		i;
  static struct lut {
    char *key;
    int value;
  } table[BKEYS] = {
    "wrap",1,
    "freeze", 2,
    "bounce", 3,
    "limit", 4
    };
	if(what == Key)
	{
  		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
  		 }
  		for(i=0;i<BKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].value);
    			 }
  		 }
	 }
	else
	{
  		for(i=0;i<BKEYS;++i)
		{
    			if(table[i].value == lkup->val)
			{
        			return((char *) table[i].key);
    			 }
  		 }
	 }
	return ((char *) FAILURE);
}





 char *
lookup_active(what,lkup)
 int 		what;
 Lkup_union 	*lkup;
{
  char 		*blank, *index();
  int 		i;
  static struct lut {
    char *key;
    int value;
  } table[AKEYS] = {
    "yes", 1,
    "no", 0,
    };

	if(what == Key)
	{
  		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
   		 }
  		for(i=0;i<AKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].value);
    			 }
  		 }
	 }
	else 
	{
  		for(i=0;i<AKEYS;++i)
		{
    			if(table[i].value == lkup->val)
			{
      				return ((char *) table[i].key);
    			 }
  		 }
	 }
	return ((char *) FAILURE);
}



 char *
lookup_map_type(what,lkup)
 int 		what;
 Lkup_union 	*lkup;
{
  char 		*blank, *index();
  int 		i;
  static struct lut {
    char *key;
    int value;
  } table[MKEYS] = {
    "simple", 0,
    "complex", 1,
    "line", 2,
    "button", 3,
    "dialog", 4,
    "tkscroll", 5,
    "tktext",6
    };

	if(what == Key)
	{
  		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
   		 }
  		for(i=0;i<MKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].value);
    			 }
  		 }
	 }
	else 
	{
  		for(i=0;i<MKEYS;++i)
		{
    			if(table[i].value == lkup->val)
			{
      				return ((char *) table[i].key);
    			 }
  		 }
	 }
	return ((char *) FAILURE);
}



#define TKFKEYS 5

 char *
lookup_function(what,lkup)
 int 		what;
 Lkup_union 	*lkup;
{
  char 		*blank, *index();
  int 		i;
  static struct lut {
    char *key;
    char *value;
    int	 param;
  } table[TKFKEYS] = {
    "IntFunction", (char *) IntFunction, INT_PARAM,
    "StringFunction", (char *) StringFunction, STRING_PARAM,
    "video", (char *) video, STRING_PARAM,
    "scroll", (char *) scroll, NULL,
    "thumb", (char *) thumb, NULL
    };

	switch(what)
	{
	   case Key:
  		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
   		 }
  		for(i=0;i<TKFKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].value);
    			 }
  		 }
	 
		break;
	 
	   case Val:
  		for(i=0;i<TKFKEYS;++i)
		{
    			if(table[i].value == (char *)lkup->val)
			{
      				return ((char *) table[i].key);
    			 }
  		 }
		break;

	   case Param:
		if( (blank = index(lkup->name,' ')) !=0 )
		{
    			*blank = '\0';
   		 }
  		for(i=0;i<TKFKEYS;++i)
		{
    			if(strcmp(lkup->name,table[i].key) == 0)
			{
      				return ((char *) table[i].param);
    			 }
  		 }
	 
		break;
	 
	 }
	return ((char *) FAILURE);
}






int 
TK_lookup(word)
 char *word;
{
  int i;
  static struct lut {
    char *key;
    int value;
  } table[TKkeys] = {
    "window", 1,
    "label", 2, 
    "font", 3,
    "borderwidth", 4,
    "foreground", 5,
    "background", 6,
    "border", 7,
    "width", 8,
    "height", 9,
    "justify", 10,
    "function", 11,
    "parameter", 12,
    "highlight", 13,
    "unhighlight", 14,
    "notify", 15,
    "orientation", 16,
    "pos_in", 17,
    "pos_out", 18,
    "thumb", 19,
    "scrollupdownproc", 20,
    "thumbproc", 21,
    "top", 22,
    "shown", 23,
    "hspace", 24,
    "vspace", 25,
    "dialog_entry", 26,
    "dialogbuttons", 27,
    "name", 28,
    "x", 29,
    "y", 30,
    "value", 31,
   
    };

  for(i=0;i<TKkeys;++i){
    if(strcmp(word,table[i].key) == 0){
      return (table[i].value);
    }
  }
return (NULL);
}




























