/*#define MUSEV 1 */

#include <stdio.h>
#include <X10/Xlib.h>
#define AUX extern
#define READFILE extern
#define LKUPS extern
#include "prsdefs.h"
#include "structs.h"
#include "lkups.h"
#define DISPLAYS
#include "dspdefs.h"
#define FN_MISC extern
#define SETPOS extern
#include "functions.h"
#define VDISC extern
#include "vdisc.h"

extern RegisterWindow();
extern in_region();
extern Map *find_map();
extern struct maplist 	  *find_all_maps();
extern position_and_scale();

/*#define DBG             1 */
#ifdef DBG
#define Debug(f)	fprintf f
#else 
#define Debug(f)
#endif

/*-----------------------------------------------------------------------
*	Assumes w is invisible -- works up the tree mapping unmapped
*	parents until it finds a parent that is visible or the RootWindow.
*/

map_parents(w)
	Window	w;
{
	WindowInfo    info;
	int           nchildren;
	Window        parent;
	Window        *children;

      	if( w == (Window) NULL ) return (-1);
      	while( w != (Window) NULL && w != RootWindow ) 
	{
              	XQueryTree( w, &parent, &nchildren, &children );
              	free( (char *) children );
              	w = parent;
              	XQueryWindow( w, &info );
		if( info.mapped == IsUnmapped)
		{
			XMapWindow( (Window) w);
		 }
              	XQueryWindow( w, &info );
		if( ! info.mapped == IsInvisible)
		    break;

         }

	return(1);
}

/*-----------------------------------------------------------------------
*/
  void
free_video(e)
  Element	*e;
{
  static char   *funcname = "free_video";
  Map		*m = e->current;
  Dimension	*d = e->p->dimension[m->simple.key_dimension];
  WindowInfo    info;
  int 		status, frame, zero = 0;
  float 	n, off;
  char		s[Nchars];
  Screenlist    *sl;

	/*  Special routine to "unmanaged" video control.*/

Debug((stderr,"  %s\n",funcname));
	sl = e->screen;
  	while(sl)
	{
 		if( ! XQueryWindow(sl->s->w,&info))
  		{
	  		printf("%s: failed XQueryWindow\n",funcname);
			exit(1);
	 	 }
        	if(info.mapped == IsUnmapped)
		{
			XMapWindow( (Window) sl->s->w);
#ifdef MUSEV
			RegisterWindow (sl->s->w, e->name);
#endif
	 	 }
  		if( ! XQueryWindow(sl->s->w,&info))
  		{
	  		printf("%s: failed XQueryWindow\n",funcname);
			exit(1);
	 	 }
  		if( info.mapped == IsInvisible )
  		{
			map_parents( sl->s->w );
	 	 }
		sl = sl->next;
	 }
}
/*------------------------------------------------------------------------
*/
  void
display_still(e)
  Element   	*e;
{
  static char   *funcname = "display_still";
  Map		*m = e->current;
  Dimension	*d = e->p->dimension[m->simple.key_dimension];
  WindowInfo    info;
  int 		status, frame, zero = 0;
  float 	n, off;
  char		s[Nchars];
  Screenlist    *sl;
  int		pixmap[16];
  float         xclip, yclip;
  int		res, skip,newmap = 0;


/*
Ordinarily one would display a map only if it is in region.  If the maps
are handling a virtual coordinate space this doesn't work so well.  See the
light_table demo, where each map is displayed on two screens.  The problem
is that the map will be in region w/ respect to dims governing the full
screen but not w/ respect to those governing the zoomed window.  Only slides
in region with both will appear at all, which in that case is not the 
desired result.  Therefore, the following check is commented out.  
*/
	m = (Map *) find_map(e);
  	if(! in_region(e->p,e, m))
	{
printf("display_still: `%s' not in region\n",e->name);
	  	return;
	 }



	if(m->simple.out <= m->simple.in)
	{
		frame = m->simple.in;
	 }
	else
	{
		n = m->simple.out - m->simple.in;
		off = e->p->dimension[m->simple.key_dimension]->current 
		    + e->delta_current + m->simple.in;
		frame = ( off/ n) * n;	
	 }
printf("display_still frame %d\n",frame);


	sl = e->screen;
/* Register only the first screen referenced in the element. */
#ifdef MUSEV
	RegisterWindow(sl->s->w, e->name);
#endif
  	while(sl)
	{
		skip = res = 0;
		/* look at all screens for virtual coordinate activity */
		if(sl->s->x_key > -1 || sl->s->y_key > -1)
		{
			res = position_and_scale(e, sl->s, &xclip, &yclip);
			if(res == -1)
			{
				XUnmapWindow(sl->s->w);
				skip = 1;
			 }
		 }
		if(! skip)
		{
 			if( ! XQueryWindow(sl->s->w,&info))
  			{
	  			printf("%s: failed XQueryWindow\n",funcname);
				exit(1);
	 	 	 }
        		if( info.mapped == IsUnmapped)
			{
				XMapWindow( (Window) sl->s->w);
				newmap = 1;
	 	 	 }
  			if( ! XQueryWindow(sl->s->w,&info))
  			{
	  			printf("%s: failed XQueryWindow\n",funcname);
				exit(1);
	 	 	 }
  			if( !skip && info.mapped == IsInvisible )
  			{
				map_parents( sl->s->w );
	 	 	 }

			 /* res = 0 ==> window hasn't changed */
			if( res || m->simple.current != frame || newmap)
			{
printf("redisplaying: res %d, current %d, frame %d\n",res,m->simple.current,frame);
				m->simple.current = frame;
				Vdisc_getframe(m->simple.rpd);
				if( frame != v$val)
				{
printf("searching frame %d\n",frame);
					Vdisc_search(m->simple.rpd,frame,WAIT);
			 	 }

printf("setting switcher\n");
/*				if(disc->switcher != m->simple.rpd)
				{
					Swtr_all(m->simple.rpd);
					disc->switcher = m->simple.rpd;
			 	 }
*/
printf("XScaleVideo to 0,0,%d,%d in window %d\n",info.width,info.height,sl->s->w);

				XUnmapWindow( (Window) sl->s->w);
				XMapWindow((Window) sl->s->w);
  				if((status = XScaleVideo(sl->s->w,0,0,640,480, 
				    0, 0, info.width,info.height)) == -1)
				{
	  				printf("%s: failed XScaleVideo to 0,0,%d,%d in window %d\n",funcname,info.width,info.height,sl->s->w);
					exit(1);
	 		 	 }
			 
printf("getpixmap..");
				if((status = XPixmapGetXY(RootWindow,1,1,1,1,pixmap)) == -1)
				{
	  				printf("%s: failed XPixmapGet\n",funcname);
					exit(1);
	 			 }
			 }
		 } /* end skip */
printf("done\n");
		
		sl = sl->next;
	 }

	if( d->rate == 0 && d->rate_setting != 0)
	{
		d->rate = d->interval = d->rate_setting;
		start_timer(d, &zero, 0);
	 }
        
}


/*------------------------------------------------------------------------
*/
  CVideo        *cvideo;

  void
display_complex(e)
  Element   	*e;
{
  static char   *funcname = "display_complex";
  Map		*m = e->current;
  WindowInfo    info;
  int 		status;
  Screenlist    *sl;


  	if( ! XQueryWindow(e->screen->s->w,&info))
  	{
	  	printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }

	if( ! m->complex.cvideo )
	{
		if (!(m->complex.cvideo = InitCVideo(e->screen->s->w,
			info.width, info.height, disc->port, 
			m->complex.startframe, m->complex.rows,
	    		m->complex.columns, m->complex.offset, 
			m->complex.xoverlap, m->complex.yoverlap, 
			HORIZONTAL))) 
		{
			printf( "Could not init map.\n");
			exit(3);
	 	 }
	 }

	cvideo = m->complex.cvideo;  /* tmp: set global cvideo for proc */
        if(info.mapped == IsUnmapped)
	{
		XMapWindow( (Window) e->screen->s->w);
	 }
  	if( ! XQueryWindow(e->screen->s->w,&info))
  	{
	  	printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }
  	if( info.mapped == IsInvisible )
  	{
		map_parents( e->screen->s->w );
	 }
		
        
}



/*--------------------------------------------------------------------
*/

#define Nspeeds 4
#define VDSC_STEP  1000 /* msec between frames */
#define VDSC_SLOW  165
#define VDSC_PLAY  33
#define VDSC_FAST  11


  int
play_vdisc(disc, d, m)
  Vdisc  	*disc;
  Dimension	*d;
  Map		*m;
{
  char		*func = "play_vdisc";
  char		s[Nchars];
  int		sign = d->rate_setting < 0 ? -1 : 1;
  struct timezone       tmz, *timezone = &tmz;
  int		i,status;
  static struct	spd{
			int	val;
			char	fwdcmd[16];
			char    revcmd[16];
		     }  speed[4] = {	VDSC_FAST, "ffast",  "rfast",
			      		VDSC_PLAY, "fplay",  "rplay",
			      		VDSC_SLOW, "fslow",  "rslow",
					VDSC_STEP, "fmin",   "rmin"
			      	      };

	for(i = 0; i < Nspeeds && speed[i].val < (d->rate_setting *sign);++i);

	if(i >= Nspeeds) i = Nspeeds - 1;
        if(sign < 0)
	{
		Vdisc_setspeed(m->simple.rpd,speed[i].revcmd);
	 }
	else
	{
		Vdisc_setspeed(m->simple.rpd,speed[i].fwdcmd);
	 }		

	gettimeofday(&d->start_time,timezone);

	d->start_point = d->current;
	d->interval = d->rate = d->rate_setting;

	d->rate = speed[i].val * sign;
	d->interval = speed[i].val;

	return (speed[i].val);
}

boundary_video(m,e,d,disc)
  Map		*m;
  Element	*e;
  Dimension	*d;
  Vdisc		*disc;
{
  char		*funcname = "boundary_video";
  char		s[Nchars];
  int 		n, status;
  WindowInfo    info;
  Screenlist    *sl;

Debug((stderr,"%s\n",funcname));

	switch(d->boundary)  /* Note: EXPIRE handled in setpos */
  	{
		case WRAP:
			disc->operation = VDSC_STOPPED;
			display_video(e);
			break;
		case FREEZE:
			Vdisc_still(m->simple.rpd);

		  	if( ! XQueryWindow(e->screen->s->w,&info))
  			{
	  			printf("%s: failed XQueryWindow\n",funcname);
				exit(1);
	 		 }

			if((status = XStillVideo(e->screen->s->w,0,0,
				0, 0, info.width,info.height)) == -1)
			{
	  			printf("%s: failed XStillVideo in window %d\n",
			    	    funcname, e->screen->s->w);
				exit(1);
	 		 }

			disc->operation = VDSC_STOPPED;
			break;
		case BOUNCE:
			d->rate_setting *= -1;
			Vdisc_audio1on(m->simple.rpd);
			Vdisc_audio2on(m->simple.rpd);
			if(e->selected == 1)
			{
			     Vdisc_audio1off(m->simple.rpd);
			 }
			if(e->selected == 2)
			{
			     Vdisc_audio2off(m->simple.rpd);
		 	 }
			n = play_vdisc(disc, d, m);
			if((status = XStartVideo(e->screen->s->w, 0,0,3)) == -1)
			{
				printf("%s: failed XStartVideo\n"
				    ,funcname);
				exit(1);
	 		 }		
			disc->operation = n;	
			break;
		case LIMIT:
			Vdisc_still(m->simple.rpd);
		  	if( ! XQueryWindow(e->screen->s->w,&info))
  			{
	  			printf("%s: failed XQueryWindow\n",funcname);
				exit(1);
	 		 }

			if((status = XStillVideo(e->screen->s->w,0,0,
				0, 0, info.width,info.height)) == -1)
			{
	  			printf("%s: failed XStillVideo in window %d\n",
			    	    funcname, e->screen->s->w);
				exit(1);
	 		 }
			disc->operation = VDSC_STOPPED;
			d->rate = d->rate_setting = 0;
			break;
	}
}


  void
display_video(e)
  Element   	*e;
{
  static char   *funcname = "display_video";
  Map		*m;
  static Map    *now_showing; /* keep track of map */
  Dimension	*d;
  WindowInfo    info;
  int 		status, rate, rf, frame, k;
  float		n, off;
  char		s[Nchars];
  int		zero = 0, in_motion = 0;
  Screenlist    *sl;
  Element       *tmpe;

	if( (m = (Map *) find_map(e)) == NULL) return;
	d = e->p->dimension[m->simple.key_dimension];

        if(m != now_showing) /* switch to new map if neccessary */
	{
		now_showing = m;
		d->rate = 0;
	 }
  	if( in_region(e->p,e, m))
	{
   		if( disc->operation == VDSC_STOPPED || d->rate == 0 )
   		{
  			if( ! XQueryWindow(e->screen->s->w,&info))
  			{
	  			printf("%s: failed XQueryWindow\n",funcname);
				exit(1);
	 		 }
        		if(info.mapped == IsUnmapped)
			{
				XMapWindow( (Window) e->screen->s->w);

#ifdef MUSEV
				RegisterWindow (e->screen->s->w, e->name);
#endif
	 	 	 }
  			if( ! XQueryWindow(e->screen->s->w,&info))
  			{
	  			printf("%s: failed XQueryWindow\n",funcname);
				exit(1);
	 		 }
  			if( info.mapped == IsInvisible )
  			{
				map_parents( e->screen->s->w );
	 		 }


			if(disc->operation != VDSC_STOPPED) in_motion = 1;

			if( d->rate_setting == 0 ) /* stop the disc*/
			{
				disc->operation = VDSC_STOPPED;
				stop_timer(d);
				if((status = XStillVideo(e->screen->s->w,0,0,
					0, 0, info.width,info.height)) == -1)
				{
	  				printf("%s: failed XStillVideo in window %d\n",
			  		    funcname, e->screen->s->w);
					exit(1);
	 		 	 }
				Vdisc_still(m->simple.rpd);
			 }

/* 
*   At this point, it's neccessary to resync the disc with the dimension,
*   either a.) searching for a new frame based on the dimension position, or
*   b.) forcing the dimension to match up with where the disc is currently
*   sitting (to avoid the `yank-back' syndrome that happens when the disc
*   player gets ahead of the dimension).
*   
*   The second case is used when:
*	 o  the current element is already in control of the disc;
*	 o  the disc has been in motion ( `in_motion' is set);
*/


		       if(e == disc->controlling_element && in_motion)
		       {

				/* force the dim pos'n to the frame */
				Vdisc_getframe(m->simple.rpd);
				k = m->simple.key_dimension;
		       		off = e->p->dimension[k]->maxi - 
				    e->p->dimension[k]->mini;

				n = m->simple.out - m->simple.in;

				off *=  ((float)(v$val - m->simple.in) 
					   / (float) n );

				if(off > e->p->dimension[k]->maxi)
				{
					off = e->p->dimension[k]->maxi;
				        Vdisc_search(m->simple.rpd,
					    m->simple.out,WAIT);
				 }

				/* if dim pos is reset, update all other data*/
				if( e->p->dimension[k]->current != off)
				{
				    e->p->dimension[k]->current = off;
				    e->p->prev_position[k] = e->p->position[k];
				    e->p->position[k] = off;
				    for(tmpe = e->p->element; tmpe; 
						tmpe = tmpe->next)
				    {	
					if(tmpe != e) update_element(tmpe);
	 			     }
				 }
			}


		   else  /* search for frame based on dimension */
		   {
			n = m->simple.out - m->simple.in;
			k = m->simple.key_dimension;
		        off = e->p->dimension[k]->maxi - e->p->dimension[k]->mini;
			if(n > off) /* just a warning */
			{
				m->simple.out -= (n-off);
				printf("%s warning: framecount greater than dimension in element %s\n",funcname, e->name);
	 		 }

			if (off != 0)
			{
				off = ((float) (e->p->dimension[k]->current 
				    + e->delta_current) / off)*n;
				e->p->dimension[k]->delta_sign = (n>0)? 1: -1;
			 }
			if( off - (frame = off) > .5) ++frame;	       
		        frame += m->simple.in;


	/* this tries to avoid repainting video frames; may skip when shldnt*/
			Vdisc_getframe(m->simple.rpd); /* puts in v$val */
  			if( m->simple.current != frame || v$val != frame)
			{
				m->simple.current = frame;

				Vdisc_search(m->simple.rpd,frame,WAIT);
/*
				if(disc->switcher != m->simple.rpd)
				{
					Swtr_all(m->simple.rpd);
					disc->switcher = m->simple.rpd;
			 	}
*/
  				if((status = XStillVideo(e->screen->s->w,0, 0, 
				    0, 0, info.width,info.height)) == -1)
				{
	  				printf("%s: failed XStillVideo to 0,0,%d,%d\n",funcname,info.width,info.height);
					exit(1);
	 	 	 	 }
			  }
		    }




	 		if(d->rate_setting != 0)
			{
				disc->controlling_element = e;
					/* Control can be taken if the disc is 
					*  stopped.
					*/
			    Vdisc_audio1on(m->simple.rpd);
			    Vdisc_audio2on(m->simple.rpd);
			    if(e->selected == 1)
			    {
			      	Vdisc_audio1off(m->simple.rpd);
			     }
			    if(e->selected == 2)
			    {
			      	Vdisc_audio2off(m->simple.rpd);
		 	     }
				n = play_vdisc(disc, d, m);
  				if((status = XStartVideo(e->screen->s->w, 0,0,3)) == -1)
				{
	  				printf("%s: failed XStartVideo\n"
					    ,funcname);
					exit(1);
	 			 }		
				disc->operation = n;
				stop_timer(d);

				start_timer(d, &zero, 0);
	 	 	 }

		 }
		else		/* disc is playing -- watch for end  */
		{
			if((     (d->rate < 0 && d->current == d->mini)
			     ||  (d->rate > 0 && d->current == d->maxi))
			     &&  (disc->controlling_element == e)  )
			{
				boundary_video(m,e,d,disc);
			 }
		  }
    	 }
	else		/*  element is out of bounds  */
	{
		if( ! XQueryWindow(e->screen->s->w,&info))
		{
 			printf("%s: failed XQueryWindow\n",funcname);
			exit(1);
 		 }

	        if(info.mapped == IsMapped)
		{
			XUnmapWindow( (Window) e->screen->s->w);
	 	 }
		if((     (d->rate < 0 && d->current == d->mini)
		     ||  (d->rate > 0 && d->current == d->maxi))
		     &&  (disc->controlling_element == e)  )
		{
			Vdisc_still(m->simple.rpd);
			disc->operation = VDSC_STOPPED;
		 }
	 }		
}

  void
display_audio(e)
  Element   	*e;
{
  static char   *funcname = "display_video";
  Map		*m = e->current;
  Dimension	*d = e->p->dimension[m->simple.key_dimension];
  Screenlist    *sl;
  WindowInfo    info;
  int 		status, rate, rf, frame, k;
  float		n, off;
  char		s[Nchars];
  int		zero = 0;

Debug((stderr,"%s: element `%s'\n",funcname,e->name));
	
	m = find_map(e);
  	if( in_region(e->p,e, m))
	{
   		if( disc->operation == VDSC_STOPPED )
   		{
  			if( ! XQueryWindow(e->screen->s->w,&info))
  			{
	  			printf("%s: failed XQueryWindow\n",funcname);
				exit(1);
	 		 }
        		if(info.mapped == IsUnmapped)
			{
				XMapWindow( (Window) e->screen->s->w);
#ifdef MUSEV
				RegisterWindow (sl->s->w, e->name);
#endif
	 	 	 }
  			if( ! XQueryWindow(e->screen->s->w,&info))
  			{
	  			printf("%s: failed XQueryWindow\n",funcname);
				exit(1);
	 		 }
  			if( info.mapped == IsInvisible )
  			{
				map_parents( e->screen->s->w );
	 		 }
			n = m->simple.out - m->simple.in;
			k = m->simple.key_dimension;
		       off = e->p->dimension[k]->maxi - e->p->dimension[k]->mini;
	if(n > off)
	{
		m->simple.out -= (n-off);
		printf("%s warning: framecount greater than dimension in element %s\n",funcname, e->name);
		printf("\treset to `%d'\n",m->simple.out);
	 }
		        off = (off == 0) ? 0 : 
			  ((float) e->p->dimension[k]->current / off)*n;
			if( off - (frame = off) > .5) ++frame;	       
		       frame += m->simple.in;
			

	 		if(d->rate_setting != 0)
			{
printf(" assigned control to pack %s, element %s\n",e->p->name,e->name);
				disc->controlling_element = e;
					/* Control can be taken if the disc is 
					*  stopped.
					*/
			    Vdisc_audio1on(m->simple.rpd);
			    Vdisc_audio1on(m->simple.rpd);
			    {
			      	Vdisc_audio1off(m->simple.rpd);
			     }
			    if(e->selected == 2)
			    {
			      	Vdisc_audio2off(m->simple.rpd);
		 	     }
			     n = play_vdisc(disc, d, m);
			     disc->operation = n;
			     stop_timer(d);

			     start_timer(d, &zero, 0);
	 	 	 }
		 }
		else		/* disc is playing -- watch for end  */
		{
			if((     (d->rate < 0 && d->current == d->mini)
			     ||  (d->rate > 0 && d->current == d->maxi))
			     &&  (disc->controlling_element == e)  )
			{
				boundary_video(m,e,d,disc);
			 }
		 }
    	 }
	else		/*  element is out of bounds  */
	{
	        if(info.mapped == IsMapped)
		{
			XUnmapWindow( (Window) m->simple.w);
	 	 }
		if((     (d->rate < 0 && d->current == d->mini)
		     ||  (d->rate > 0 && d->current == d->maxi))
		     &&  (disc->controlling_element == e)  )
		{
			Vdisc_still(m->simple.rpd);
			disc->operation = VDSC_STOPPED;
		 }
	 }		
}

/*-------------------------------------------------------------------
*   DISPLAY TEXT
*
*   This text handling routine works with a toolkit text widget.  The
*   widget pointer is hung on e->w, the element window slot.  The 
*   element carries the source file name.  The mappings hold byte
*   offsets into this file.  The mappings are non-overlapping in this
*   case; that is, only one of the mappings can be displayed at a time.
*/

  void
display_text(e)
  Element   	*e;
{
  static char   *funcname = "display_text";
  Map		*m;
  WindowInfo    info;
  Screenlist    *sl;
  int 		status;
  char		s[Nchars];
  float		n, off;
  int		k, offset;

Debug((stderr,"%s: element `%s', type %d\n",funcname,e->name,e->map->simple.type));

  	if( ! in_region(e->p,e, e->map)) 
	{
		XUnmapWindow(e->w);
		return;
	 }



	if( ! XQueryWindow(e->w,&info))
	{
  		printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }
       	if(info.mapped == IsUnmapped)
	{
		XMapWindow( (Window) e->w);
#ifdef MUSEV
		RegisterWindow (sl->s->w, e->name);
#endif
 	 }
	if( ! XQueryWindow(e->w,&info))
	{
  		printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }
	if( info.mapped == IsInvisible )
	{
		map_parents( e->w );
 	 }
  
	m = find_map(e);

       	if (m) set_text_position( e->w, m->simple.in);
        else set_text_position( e->w, 0);
        
}

/*-----------------------------------------------------------------
*   DISPLAY TK WIDGET
*
*   The widget element allows concurrent mappings; more than one
*   widget in the set can be visible at a time.
*/

  void
display_TKwidget(e)
  Element   	*e;
{
  static char   *funcname = "display_TKwidget";
  WindowInfo    info;
  Screenlist    *sl;
  Map		*m = e->current;
  struct maplist
	{  Map  	  *map;
	   struct maplist *next;
	 } *maplist;
  Mapped_items		  *tmp, *newlist = 0;


Debug((stderr,"%s: element `%s'\n",funcname,e->name));


 	maplist = (struct maplist *)find_all_maps(e);
	
        /*  Make sure the target window is mapped... */
  	if( ! XQueryWindow(e->screen->s->w,&info))
  	{
	  	printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }
        if(info.mapped == IsUnmapped)
	{
		XMapWindow( (Window) e->screen->s->w);
	 }
	if( ! XQueryWindow(e->screen->s->w,&info))
  	{
		printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }
  	if( info.mapped == IsInvisible )
  	{
		map_parents( e->screen->s->w );
	 }



  	while( maplist != 0 && maplist->map != 0)
  	{
Debug((stderr,"  `%d'",maplist->map));
	        /* see if item on maplist is currently mapped */
		for(tmp = e->mapped_widgets; tmp && tmp->map != maplist->map; 
		    tmp = tmp->next);  
		if( tmp)  /* if yes,  */
		{
Debug((stderr, " mapped already (type `%d')\n"
    ,tmp->map->simple.type,tmp->map));
			/*  remove from element list... */
			if(tmp->prev) tmp->prev->next = tmp->next;
			if(tmp->next) tmp->next->prev = tmp->prev;
			if(tmp == e->mapped_widgets) e->mapped_widgets = tmp->next;
			/*  and add to newlist   */
			tmp->next = newlist;
			if(newlist) newlist->prev = tmp;
			newlist = tmp;
		 }
		else
		{	/* otherwise map it...  */
Debug((stderr, " new mapping: type `%d'\n",
    maplist->map->simple.type,maplist->map));

  			if( !XMapWindow( (Window) maplist->map->simple.w))
			{
	  			printf("%s: failed XMapWindow\n", funcname);
				exit(1);
	 	 	 }
			if((tmp = (Mapped_items *)
			    calloc(1, sizeof(Mapped_items))) == 0)
			{
	  			printf("%s: failed calloc mapped_widgets\n"
				    ,funcname);
				exit(1);
			 }
			/*  and add it to newlist.  */
			tmp->map = maplist->map;
			tmp->next = newlist;
			if(newlist) newlist->prev = tmp;
			newlist = tmp;
		 }
		maplist = maplist->next;			
	  }

	while( e->mapped_widgets != 0)
	{
		/* then unmap any that are up but shouldn't be */
Debug((stderr, "  unmapping: type `%d' at `%d'\n"
    ,e->mapped_widgets->map->simple.type,e->mapped_widgets->map));

		if( !XUnmapWindow( (Window) e->mapped_widgets->map->simple.w))
		{
			printf("%s: failed XUnmapWindow\n", funcname);
			exit(1);
	 	 }
		tmp = e->mapped_widgets;
		e->mapped_widgets = e->mapped_widgets->next;
		free(tmp);
	  }
        e->mapped_widgets = 0;
	if(newlist) e->mapped_widgets = newlist;
	XFlush();


        
}




/*----------------------------------------------------------------------
*   Draw Label  
*/
  void
draw_label(e,m,mode)
  Element 	*e;
  Map	 	*m;
  int		mode;
{

	int 		charpad = 0, spacepad = 0;  /* args to XLine, p 19 */
	int		func = GXcopy;  /* drawing mode, see X man p. 18 */
	WindowInfo    	info;
	Screen          *s = e->screen->s;
	static 	char  	*funcname = "draw_label";
  	char		*str;  		/* string to print */
	int		res,x,y, color;
	float           xclip,yclip;
	int		erase_before_draw = m->graphic.erase ? 0 : 1;
	Font    	font = m->graphic.font->id;



  	if( ! XQueryWindow(e->screen->s->w,&info))
  	{
	  	printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }
        if(info.mapped == IsUnmapped)
	{
		XMapWindow( (Window) e->screen->s->w);
#ifdef MUSEV
		RegisterWindow (e->screen->s->w, e->name);
#endif
		XClipDrawThrough(e->screen->s->w);
	 }
	if( ! XQueryWindow(e->screen->s->w,&info))
  	{
		printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }
  	if( info.mapped == IsInvisible )
  	{
		map_parents( e->screen->s->w );
	 }

	/*  If the label is to be wiped permanently (mode == ERASE), or
	*   if it is to be erased before a new copy is drawn (erase_befo...),
	*   then get rid of it by setting the color to zero.  Need to find
	*   a better way of doing this -- setting to 0 is baloney.
	*/
	if(mode == ERASE || erase_before_draw)
	{
		str = m->graphic.label;
		x = m->graphic.value[X1INDX];
		y = m->graphic.value[Y1INDX];
		color = e->screen->s->background;
		XTextMaskPad(	e->screen->s->w,
				x,y,
				str,strlen(str),
		        	font,
				charpad,spacepad,
				color,
				func,
				AllPlanes);
	 }

	/*  Mode ERASE is used to get rid of the label altogether; don't 
	*   redraw anything.  Therefore,...
	*/
	if(mode == ERASE) return; /* since the rest has to do with redraw */


	/*  If a label function has been declared, use it to get the string;
	*   otherwise use what's in the label slot.  Same goes for the
	*   location.
	*/
	str = m->graphic.label_fn ?
		       (char *)(*m->graphic.label_fn)(m,m->graphic.label_prm) :
			m->graphic.label;
	str = m->graphic.label;  
	/*  Note the function pointers for x and y are kept in an array,
	*   indexed by X1INDX, Y1INDX, X2INDX, and Y2INDX.  Values likewise.
	*/
	x = m->graphic.fn[X1INDX] ? /* fn or value? */
			(*m->graphic.fn[X1INDX])(m->graphic.params[X1INDX]) :
			m->graphic.value[X1INDX];  /* value  */

	y = m->graphic.fn[Y1INDX] ? /* fn or value? */
			(*m->graphic.fn[Y1INDX])(m->graphic.params[Y1INDX]) :
			m->graphic.value[Y1INDX];  /* value  */

	if(s->x_key > -1 || s->y_key > -1)
	{
		res = position_and_scale_graphic(e,m,s,x,y,&xclip, &yclip);
/*		if(res == -1)
		{
			XUnmapWindow(s->w);
			skip = 1;
		 }
*/
		x = m->graphic.pos[InPoint][s->x_key];
		y = m->graphic.pos[InPoint][s->y_key];

	 }

	m->graphic.value[X1INDX] = x;
	m->graphic.value[Y1INDX] = y;
		
	color = m->graphic.color;  /* integer foreground, see X, p.34 */


	/*  If there is no string, just bail out.  There should be a case for
	*   when there is no change; currently, the label blinks if it is
	*   set erase_before_draw, erasing and redrawing the same thing.
	*/
	if(!strlen(str)) return;

	XTextMaskPad(	e->screen->s->w,
			x,y,
			str,strlen(str),
		        font,
			charpad,spacepad,
			color,
			func,
			AllPlanes);

	XFlush();  
}

/*----------------------------------------------*/
void
u$_DrawLine(window,x,y,w,h,color)
	Window	window;
	int	x,y,w,h,color;
{
	XLine(window, x, y, x + w, y + h, 1, 1, BlackPixel, GXxor, AllPlanes);
}

void
u$_DrawBox(window,x,y,w,h,color)
	Window	window;
	int	x,y,w,h,color;
{
	Vertex	vertices[5];
	void	u$_SetVertex();

	u$_SetVertex(&vertices[0], x, y, VertexStartClosed);
	u$_SetVertex(&vertices[1], w, 0, VertexRelative);
	u$_SetVertex(&vertices[2], 0, h, VertexRelative);
	u$_SetVertex(&vertices[3], -w, 0, VertexRelative);
	u$_SetVertex(&vertices[4], 0, -h, VertexRelative | VertexEndClosed);
	XDraw(window, vertices, 5, 1, 1, color, GXxor, 1);
}	

void
u$_SetVertex(vertex, x, y, flags)
	Vertex		*vertex;
	short		x, y;
	unsigned short	flags;
{
	vertex->x = x;
	vertex->y = y;
	vertex->flags = flags;
}


/*----------------------------------------------------------------------
*   Draw
*/
  void
draw(e,m,mode)
  Element 	*e;
  Map	 	*m;
  int		mode;
{

	int 		charpad = 0, spacepad = 0;  /* args to XLine, p 19 */
	int		func = GXcopy;  /* drawing mode, see X man p. 18 */
	WindowInfo    	info;
	Screen          *s = e->screen->s;
	static 	char  	*funcname = "draw_label";
  	char		*str;  		/* string to print */
	int		res,x,y,w,h,color;
	float           xclip,yclip;
	int		erase_before_draw = m->graphic.erase ? 0 : 1;
	Font    	font = m->graphic.font->id;


  	if( ! XQueryWindow(e->screen->s->w,&info))
  	{
	  	printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }
        if(info.mapped == IsUnmapped)
	{
		XMapWindow( (Window) e->screen->s->w);
#ifdef MUSEV
		RegisterWindow (e->screen->s->w, e->name);
#endif
		XClipDrawThrough(e->screen->s->w);
	 }
	if( ! XQueryWindow(e->screen->s->w,&info))
  	{
		printf("%s: failed XQueryWindow\n",funcname);
		exit(1);
	 }
  	if( info.mapped == IsInvisible )
  	{
		map_parents( e->screen->s->w );
	 }

	/*  If the label is to be wiped permanently (mode == ERASE), or
	*   if it is to be erased before a new copy is drawn (erase_befo...),
	*/
	if(mode == ERASE || erase_before_draw)
	{
		x = m->graphic.value[X1INDX];
		y = m->graphic.value[Y1INDX];
		w = m->graphic.value[X2INDX];
		h = m->graphic.value[Y2INDX];
/*		color = e->screen->s->background; */
		color = m->graphic.color;
		u$_DrawBox(e->screen->s->w,x,y,w,h,color);
	 }

	/*  Mode ERASE is used to get rid of the label altogether; don't 
	*   redraw anything.  Therefore,...
	*/
	if(mode == ERASE) return; /* since the rest has to do with redraw */


	/*  If a label function has been declared, use it to get the string;
	*   otherwise use what's in the label slot.  Same goes for the
	*   location.
	*/
	color = m->graphic.label_fn ?
		       (int)(*m->graphic.label_fn)(m,m->graphic.label_prm) :
			m->graphic.color;
	color = m->graphic.color;  
	/*  Note the function pointers for x and y are kept in an array,
	*   indexed by X1INDX, Y1INDX, X2INDX, and Y2INDX.  Values likewise.
	*/
	x = m->graphic.fn[X1INDX] ? /* fn or value? */
			(*m->graphic.fn[X1INDX])(m->graphic.params[X1INDX]) :
			m->graphic.value[X1INDX];  /* value  */

	y = m->graphic.fn[Y1INDX] ? /* fn or value? */
			(*m->graphic.fn[Y1INDX])(m->graphic.params[Y1INDX]) :
			m->graphic.value[Y1INDX];  /* value  */

	w = m->graphic.fn[X2INDX] ? /* fn or value? */
			(*m->graphic.fn[X2INDX])(m->graphic.params[X2INDX]) :
			m->graphic.value[X2INDX];  /* value  */

	h = m->graphic.fn[Y2INDX] ? /* fn or value? */
			(*m->graphic.fn[Y2INDX])(m->graphic.params[Y2INDX]) :
			m->graphic.value[Y2INDX];  /* value  */

printf("map %d value %d  InPoint %d\n",m,m->graphic.value[X1INDX],m->graphic.pos[InPoint][s->x_key]);

	if(s->x_key > -1 || s->y_key > -1)
	{
printf("going to scale graphic x %d x_key %d, y %d, y_key %d...\n",x,s->x_key,y,s->y_key);
		res = position_and_scale_graphic(e,m,s,x,y,&xclip, &yclip);
/*		if(res == -1)
		{
			XUnmapWindow(s->w);
			skip = 1;
		 }
*/
		x = m->graphic.pos[InPoint][s->x_key];
		y = m->graphic.pos[InPoint][s->y_key];
printf("back from scale x %d, y%d\n",x,y);
	 }

	m->graphic.value[X1INDX] = x;
	m->graphic.value[Y1INDX] = y;
	m->graphic.value[X2INDX] = w;
	m->graphic.value[Y2INDX] = h;
	u$_DrawBox(e->screen->s->w,x,y,w,h,color);		

	XFlush();  
}

/*----------------------------------------------------------------------
*   Display Graphic
*/
  void
display_graphic(e)
  Element 	*e;
{
  	Map	*m = e->current ? e->current : e->map;
  	struct maplist
		{  Map  	  *map;
	   	   struct maplist *next;
	 	 } *maplist;
  	Mapped_items		  *tmp, *newlist = 0;


 	if( (maplist = (struct maplist *)find_all_maps(e)) == NULL)
	{
		XUnmapWindow(e->screen->s->w);
		return;
	 }


	switch(m->simple.type)
	{
		  case LINE_MAP:
			break;
		  case LABEL_MAP:
					/* options are DRAW and ERASE
					*  use ERASE to get rid of the 
					*  thing permanently.
					*/
			draw_label(e,m,DRAW);
			break;
		  case ARC_MAP:
			break;
		  case BOX_MAP:
			draw(e,m,DRAW);
			break;
		  default:
			break;
	 }
}


/*---------------------------------------------------------------------
*    Display  Package
*/
   void
display_package(e)
    Element 	*e;
{
  static char   *funcname = "display_package";
  Map		*m = e->current;
  struct maplist
	{  Map  	  *map;
	   struct maplist *next;
	 } *maplist;
  Mapped_items		  *tmp, *newlist = 0;

 	maplist = (struct maplist *)find_all_maps(e);

  	while( maplist != 0 && maplist->map != 0)
  	{
	        /* see if 1st item on maplist is currently mapped */
		for(tmp = e->mapped_packages; tmp && tmp->map != maplist->map; 
		    tmp = tmp->next);  
		if( tmp)  /* if yes,  */
		{
			/*  remove from element list... */
			if(tmp->prev) tmp->prev->next = tmp->next;
			if(tmp->next) tmp->next->prev = tmp->prev;
			if(tmp == e->mapped_packages)
			{
				 e->mapped_packages = tmp->next;
			 }
			/*  and add to newlist   */
			tmp->next = newlist;
			if(newlist) newlist->prev = tmp;
			newlist = tmp;
		 }
		else
		{	/* otherwise map it...  */

			activate_package(maplist->map->simple.package);

			if((tmp = (Mapped_items *)
			    calloc(1, sizeof(Mapped_items))) == 0)
			{
	  			printf("%s: failed calloc mapped_packages\n"
				    ,funcname);
				exit(1);
			 }
			/*  and add it to newlist.  */
			tmp->map = maplist->map;
			tmp->next = newlist;
			if(newlist) newlist->prev = tmp;
			newlist = tmp;
		 }
		maplist = maplist->next;			
	  }
	while( e->mapped_packages != 0)
	{
		/* then unmap any that are up but shouldn't be */

		expire(e->mapped_packages->map->simple.package,(Package *) 0,
		    DO_STOP);

		tmp = e->mapped_packages;
		e->mapped_packages = e->mapped_packages->next;
		free(tmp);
	        e->mapped_packages = 0;
	  }
	if(newlist) e->mapped_packages = newlist;
	XFlush();        
}

/********************************************************************
*  Display Action
*/
   void
display_action(e)
   Element	*e;
{
  static char   *funcname = "display_action";
  Map		*m = e->current;
  struct maplist
	{  Map  	  *map;
	   struct maplist *next;
	 } *maplist;
  Mapped_items		  *tmp, *newlist = 0;

Debug((stderr,"%s:\n",funcname));
 	maplist = (struct maplist *)find_all_maps(e);

  	while( maplist != 0 && maplist->map != 0)
  	{
		m = maplist->map;
		(*m->simple.action)(m->simple.arg);
		maplist = maplist->next;			
	 }

}

