/*  Structs.h */

typedef int  Position[MaxDims];

typedef struct _Simple{    
	  union _Map     *prev, *next;
	  int		 type;
	  int 		 pos[MaxDims][2]; 
	  int 		 selected;
 	  long 		 in, out, icon;
	  char 		 text[Nchars];
	  Window	 w;
} Simple;

typedef struct _Complex {    
	  union _Map      *prev, *next;
	  int		  type;
	  int 		  pos[MaxDims][2]; 
	  int 		  selected;
	  int		  ndims;
	  int 		  cells[MaxDims], scale[MaxDims], delta[MaxDims];
	  int 		  package_dim[MaxDims];
	  int		  xdim, ydim, frame1;
} Complex;

typedef struct _Graphic {
	  union _Map      *prev, *next;
	  int		  type;
	  int 		  pos[MaxDims][2]; 
	  int 		  selected;
	  int		  x, y, xdim, ydim;
	  int		  color;
	  int		  attributes;
} Graphic;  	 


typedef union _Map {
		 	  	Simple	 simple;
	  		  	Complex	 complex;
				Graphic	 graphic;
} Map;


/*   */


typedef struct _Dimension {
	  int 		 min, max, current, range;           
	  int 		 boundary;        
	  char 		 name[Nchars];
 } Dimension;

typedef struct _Screen{
	  int 		 type;
	  int 		 selected;
	  Window 	 w, parent;
	  int 		 x, y, width, height, borderwidth;
	  int 		 border, background;
	  Pixmap 	 border_pixmap, background_pixmap;
	  char 		 name[Nchars], parentname[Nchars], nextname[Nchars];
	  struct _Screen *prev, *next;
} Screen;

typedef struct _Element{
	  int 		  type;
	  struct _Package *p;
	  Window 	  w;          
	  Map  		  *map, *current;
	  int 	 	  (*display_fn)();
	  int 		  active, init_active, selected;
	  char 		  file[Nchars], display_function[Nchars];
	  char		  name[Nchars], screen_name[Nchars], nextname[Nchars]; 
	  struct _Element *prev, *next;
} Element;

typedef struct _Package{
	  Element 	 *element;             
	  Screen 	 *window;       
	  Dimension 	 *dimension[MaxDims];
	  Position 	 position; 
	  int 		 ndims;                
	  int 		 active, init_active, selected;
	  char 		 name[Nchars], nextname[Nchars], screen_name[Nchars];  
	  struct _Package *prev, *next, *unext;    /* unext is user's chain */
} Package;






