BASE_FILES_DIR := ../base-files

ROOT_DIRS_BASE_FILES := / /sys /tmp /dev /proc /storage /etc /usr/bin /usr/sbin /lib/modules
ROOT_DIRECTORIES += $(addprefix $(ROOT_DIR), $(ROOT_DIRS_BASE_FILES))

rootfs: \
	do_root_sync \
	$(ROOT_DIR)/MERAKI_ARCH \
	$(ROOT_DIR)/MERAKI_BUILD \
	$(ROOT_DIR)/etc/mtab

.PHONY: do_root_sync

FILES_TO_ROOFNET := /www/index.pl /www/scan.pl /www/scan.cgi /etc/resolv.conf /etc/default_config /etc/banner

do_root_sync:
	rsync -a --exclude=.svn --exclude=\*~ $(BASE_FILES_DIR)/files/ $(ROOT_DIR)/

$(ROOT_DIR)/etc/banner: do_root_sync $(PREPARE_STAMP)
	sed 's,$$R,r$(REV),g' $@

$(ROOT_DIR)/etc/ipkg.conf: do_root_sync $(PREPARE_STAMP)
	sed 's,$$S,$(BOARD)-$(KERNEL),g' $@

$(ROOT_DIR)/usr/bin/%: $(BASE_FILES_DIR)/src/%.c $(BASE_FILES_DIR)/src/glue.h $(PREPARE_STAMP)
	$(CC) -o $@ $<

ifeq ($(BOARD),brcm)
ARCH := "mipsel"
endif
ifeq ($(BOARD),ar531x)
ARCH := "mips"
endif

$(ROOT_DIR)/MERAKI_ARCH: $(PREPARE_STAMP)
	echo "$(ARCH)" > $@

$(ROOT_DIR)/MERAKI_BUILD: $(PREPARE_STAMP) FORCE
	rm -f $@
	echo "563" > $@

$(ROOT_DIR)/etc/mtab: $(PREPARE_STAMP)
	ln -sf /proc/mounts $@

.PHONY: rootfs_cleaned
rootfs_cleaned: rootfs
	-find $(ROOT_DIR) -name '.#*' -or -name '*~'| xargs rm -f
