#!/usr/bin/perl -w

my %FORM;
my $buffer;
# parse the form data.
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
my @pairs = split(/&/, $buffer);
foreach my $pair (@pairs) {
    my ($name, $value) = split(/=/, $pair);
    $value =~ tr/+/ /;  
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $FORM{$name} = $value;
}

my $channel = 0;

my $uplink_ssid = "";

my $uplink_enabled = "";
my $uplink_wep_key = "";

my $local_ssid = "";
my $local_wep_key = "";
my $local_wpa_key = "";

sub set_config {
    my ($key, $value) = @_;
    if (defined $value && $value ne "") {
	system "/usr/bin/config_set $key $value";
    }
    
}
# write a new config out if we got any new values
if (scalar(@pairs) > 0) {
    set_config("channel", $FORM{"channel"});


    set_config("uplink_enabled", $FORM{"uplink_enabled"});
    set_config("uplink_ssid", $FORM{"uplink_ssid"});
    set_config("uplink_wep_key", $FORM{"uplink_wep_key"});
    set_config("uplink_wpa_key", $FORM{"uplink_wpa_key"});
    
    set_config("local_ssid", $FORM{"local_ssid"});
    set_config("local_wep_key", $FORM{"local_wep_key"});

}


sub get_config {
    my ($key) = @_;

    my $r = `/usr/bin/config_get $key`;
    return $r;
}

$channel = get_config("channel");
$uplink_enabled = get_config("uplink_enabled");
$uplink_ssid = get_config("uplink_ssid");
$uplink_wep_key = get_config("uplink_wep_key");
$uplink_wpa_key = get_config("uplink_wpa_key");

$local_ssid = get_config("local_ssid");
$local_wep_key = get_config("local_wep_key");

if (! defined $uplink_enabled) {$uplink_enabled = "false"; }
if (! defined $uplink_ssid) {$uplink_ssid = ""; }
if (! defined $uplink_wpa_key) {$uplink_wpa_key = ""; }
if (! defined $channel) {$channel = ""; }
if (! defined $uplink_wep_key) {$uplink_wep_key = ""; }
if (! defined $local_ssid) {$local_ssid = "roofnet"; }
if (! defined $local_wep_key) {$local_wep_key = ""; }


print "Content-type:text/html\n\n";
print <<EndHTML;
<head>
    <title>Configuration</title>
</head>

<body>

<form action="configure.pl" method="POST">
    Uplink Enabled: <input type="text" name="uplink_enabled" value="$uplink_enabled">
    <br>
    Channel: <input type="text" name="channel" value="$channel">
    <br>
    Uplink SSID: <input type="text" name="uplink_ssid" value="$uplink_ssid">
    <br>
    Uplink wep key: <input type="text" name="uplink_wep_key" value="$uplink_wep_key">
    <br>
    Uplink wpa key: <input type="text" name="uplink_wpa_key" value="$uplink_wpa_key">
    <br>
    Local SSID: <input type="text" name="local_ssid" value="$local_ssid">
    <br>
    Local wep key: <input type="text" name="local_wep_key" value="$local_wep_key">
    <br>
<input type="submit" value="Write Configuration">
<input type="reset" value="Clear Form">
</form>

</body></html>


EndHTML
