#!/usr/bin/ruby -w
#
# Copyright (c) 2006 Meraki Networks, Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, subject to the conditions
# listed in the Meraki.LICENSE file. These conditions include: you must
# preserve this copyright notice, and you cannot mention the copyright
# holders in advertising related to the Software without their permission.
# The Software is provided WITHOUT ANY WARRANTY, EXPRESS OR IMPLIED. This
# notice is a summary of the Meraki.LICENSE file; the license in that file is
# legally binding.
#

STDOUT.sync = true # like perl's $| = 1;


# helper functions
#
#

def run_system(cmd)
  printf("+%s\n", cmd);
  return system(cmd)
end

def dev_exists(device)
  return system("/sbin/ifconfig #{device} > /dev/null 2>&1")
end

def mac_from_dev(device)
  f = `/sbin/ifconfig #{device}`
  if f.match(/(\S+)\:(\S+)\:(\S+)\:(\S+)\:(\S+)\:(\S+)/)
    return "#$1:#$2:#$3:#$4:#$5:#$6"
  end
end

def ip_from_mac(srcr_version, mac)
  if mac.match(/(\S+)\:(\S+)\:(\S+)\:(\S+)\:(\S+)\:(\S+)/)
    return sprintf("%d.%d.%d.%d", srcr_version == 2 ? 6 : 5, $4.hex, $5.hex,
		   $6.hex)
  end
end


# global variables
$config = {}
$dhcpd_always_devices = "ath0"
$eth0 = "eth0"
@ROUTE_UNCONFIG = 0
@ROUTE_NODE_ETH0_NO_CARRIER = 1
@ROUTE_NODE_ETH0_CARRIER = 2
@ROUTE_ETH0 = 3
@ROUTE_ATH0_DISASSOCIATED = 4
@ROUTE_ATH0_ASSOCIATED = 5

$state_names = {}
$state_names[@ROUTE_UNCONFIG] = "unconfig"
$state_names[@ROUTE_NODE_ETH0_NO_CARRIER] = "node_eth0_no_carrier"
$state_names[@ROUTE_NODE_ETH0_CARRIER] = "node_eth0_carrier"
$state_names[@ROUTE_ETH0] = "eth0"
$state_names[@ROUTE_ATH0_DISASSOCIATED] = "ath0_disassociated"
$state_names[@ROUTE_ATH0_ASSOCIATED] = "ath0_associate"

$route = @ROUTE_UNCONFIG
$eth0_carrier_ok = false

$arch = `cat /MERAKI_ARCH`

def transition(newstate)
  print "transition from #{$state_names[$route]} to #{$state_names[newstate]}\n"
  if $route == newstate
    return
  end
  oldstate = $route
  $route = newstate

  if (oldstate != @ROUTE_NODE_ETH0_CARRIER && oldstate != @ROUTE_NODE_ETH0_NO_CARRIER) \
      && (newstate == @ROUTE_NODE_ETH0_CARRIER || newstate == @ROUTE_NODE_ETH0_NO_CARRIER)
    # stop udhcpc on the 
    if File.exist?("/var/run/eth0.pid")
      cmd = "killall -9 `cat /var/run/eth0.pid`"
      run_system(cmd)
    end
    run_system("/sbin/route del default")
    run_system("/sbin/route add default dev srcr2")
    run_system("/usr/bin/write_handler gateway_disable.step 1")
    run_system("echo '0' > /proc/sys/net/ath0/meraki_gateway_flag")
    run_system("/sbin/ifconfig #{$eth0} #{$config['eth0_gateway_ip']}")
    restart_dhcpd
  elsif newstate == @ROUTE_ETH0
    # we successfully dhcp-ed on eth0
    run_system("/sbin/route del default dev srcr2")
    run_system("/usr/bin/write_handler gateway_enable.step 1")
    run_system("echo '1' > /proc/sys/net/ath0/meraki_gateway_flag")
    restart_dhcpd
  elsif newstate == @ROUTE_ATH0_DISASSOCIATED
    run_system("/sbin/ifconfig ath0 down")
    run_system("killall -q click")
  elsif newstate == @ROUTE_ATH0_ASSOCIATED
    if dhcp_ath1() 
      puts "dhcp successful\n"
    else
      # XXX NOTE that we will probably never try again.  really we
      # should add a state so that we will periodically look again 
      # for a dhcp lease on the wireless interface.

      puts "dhcp failed\n"
    end

    start_click()
    run_system("/sbin/ifconfig ath0 up")
    run_system("/sbin/ifconfig ath0 #{$config['ath0_gateway_ip']}")

    # we successfully dhcp-ed on ath0
    run_system("/sbin/ifconfig #{$eth0} #{$config['eth0_gateway_ip']}")
    run_system("/usr/bin/write_handler gateway_enable.step 1")
    run_system("echo '1' > /proc/sys/net/ath0/meraki_gateway_flag")
    restart_dhcpd
  end
end

def shutdown
  puts "running shutdown...\n"
  if dev_exists("ath0")
    system("/sbin/ifconfig ath0 down")
    system("/usr/sbin/wlanconfig ath0 destroy");
  end
  if dev_exists("ath1")
    system("/usr/sbin/wlanconfig ath1 destroy");
  end
  if dev_exists("ath2")
    system("/usr/sbin/wlanconfig ath2 destroy");
  end
end


def start

  if $arch.match("mipsel")
    $eth0 = "vlan0"
    $dhcpd_always_devices += " vlan1"
    system("/sbin/ifconfig vlan1 #{$config['vlan1_gateway_ip']}")
  end

  printf "starting wireless\n"
  run_system("/usr/sbin/80211debug +scan")
  run_system("/usr/sbin/wlanconfig ath0 create wlandev wifi0 wlanmode ap")
  run_system("/usr/sbin/iwpriv ath0 mode 2")
  run_system("/usr/sbin/iwpriv ath0 bintval 500")
  run_system("/sbin/ifconfig ath0 #{$config['ath0_gateway_ip']}")
  run_system("/usr/sbin/iwconfig ath0 2>&1")
  run_system("/usr/sbin/iwconfig ath0 channel #{$config['channel']}")
  run_system("/usr/sbin/iwconfig ath0 essid #{$config['local_ssid']}")
  run_system("/usr/sbin/iwconfig ath0 rate 11M")
  run_system("/usr/sbin/iwconfig ath0 2>&1")



  run_system("/usr/sbin/wlanconfig ath1 create wlandev wifi0 wlanmode sta nosbeacon")

  run_system("/usr/sbin/wlanconfig ath2 create wlandev wifi0 wlanmode monitor > /dev/null")
  run_system("/sbin/ifconfig ath2 mtu 1900")
  run_system("/sbin/ifconfig ath2 txqueuelen 5")
  run_system("echo '804' >  /proc/sys/net/ath2/dev_type")
  run_system("/sbin/ifconfig ath2 up")
  run_system("/sbin/modprobe tun > /dev/null 2>&1")


  # do a scan
  run_system("/usr/sbin/iwlist ath0 scan")
  sleep 3

end

def load_config
  # configs are stored in the file as
  # key value...
  #
  $config = {}
  run_system("touch /storage/config")
  all_configs = IO.readlines("/etc/default_config") +
    IO.readlines("/storage/config")
  all_configs.each { |line| 
    arr = line.chomp.split(/ /)
    key = arr.shift
    value = arr.join " "
    if key != ""
      $config[key] = value
      printf "key %s value %s\n", key, value
    end
  }

  # default config values
end

def start_nat
  run_system ("echo 1 > /proc/sys/net/ipv4/ip_forward")
  run_system ("/usr/sbin/iptables -t nat -A POSTROUTING -j MASQUERADE")
end

def stop_dhcpd
  run_system ("killall -q dhcpd")
end
def restart_dhcpd
  printf "restarting dhcpd\n"
  stop_dhcpd
  run_system ("touch /tmp/dhcp.leases")
  if $route == @ROUTE_ETH0
    run_system("/usr/sbin/dhcpd -d #{$dhcpd_always_devices} > /tmp/dhcpd.log 2>&1 &")
  else
    # hopefully add a check here someday to only actually run dhcpd if
    # we can get to the internet... or maybe just change ssid
    run_system("/usr/sbin/dhcpd -d #{$dhcpd_always_devices} #{$eth0} > /tmp/dhcpd.log 2>&1 &")
  end
end

def eth0_has_carrier
  if $arch.match("mipsel") || $arch.match("i386")
    return true
  else
    return `cat /sys/class/net/eth0/carrier`.chomp == "1"
  end
end

def ath1_associated
  return `cat /tmp/ath1_associated`.chomp == "1"
end

def try_dhcp_eth0
  stop_dhcpd
  run_system("route del default")

  print "running udhcpc...\n"
  cmd = "/sbin/udhcpc -i #{$eth0} -n -p /var/run/eth0.pid -R"
  if run_system(cmd) 
    printf "new ethernet -> gateway 1st try\n"
    return true
  elsif run_system(cmd)
    printf("new ethernet -> gateway 2nd try\n")
    return true
  else
    printf("could not obtain ethernet address, giving up\n")
    return false
  end      
end    

def start_wireless_gateway
  if $config['uplink_enabled'] != "true"
    printf "no wireless uplink configured\n"
    return false
  end

  printf "configuring wireless uplink\n"

  run_system("/sbin/ifconfig ath0 up")
  run_system("/sbin/ifconfig ath1 up")

  run_system("/usr/sbin/iwconfig ath1 essid #{$config['uplink_ssid']} > /tmp/wireless_uplink.log 2>&1 &")

  while `iwconfig ath1`.match(/Not-Associated/)
    sleep 20
    puts "still not associated."
    run_system("/usr/sbin/iwconfig ath1 essid #{$config['uplink_ssid']}")
  end
  
  system("echo '1' > /tmp/ath1_associated")

  return true
end

def dhcp_ath1
  # start dhcpd
  run_system("killall -9 udhcpc")
  run_system("/sbin/ifconfig ath0 up")
  run_system("/sbin/ifconfig ath1 up")

  cmd = "/sbin/udhcpc -i ath1 -n -p /var/run/ath1.pid -R"
  if run_system(cmd) 
    return true
  end
  if run_system(cmd)
    return true
  end
  if run_system(cmd)
    return true
  end

  puts "failed to get a wireless dhcp lease in three tries."
  return false
end

def start_click
  cmd = "cat /etc/sr2.click.template \
| sed -e 's/__SRCR1_IP__/#{$srcr1_ip}/g' \
| sed -e 's/__SRCR1_NM__/255.0.0.0/g' \
| sed -e 's/__SRCR2_IP__/#{$srcr2_ip}/g' \
| sed -e 's/__SRCR2_NM__/255.0.0.0/g' \
| sed -e 's/__WIRELESS_MAC__/#{$ath0_mac}/g' \
| sed -e 's/__WIRELESS_IP__/#{$srcr2_ip}/g' > /etc/sr2.click"

  run_system(cmd)
  run_system("killall -q click")
  # 4MB core file size max
  run_system("mkdir -p /tmp/cores/click")
  run_system("sh -c 'ulimit -c 8192; cd /tmp/cores/click; exec /usr/bin/click /etc/sr2.click >> /tmp/sr2.log 2>&1' &");
  run_system("echo '1'> /proc/sys/net/ath0/meraki_flag")

#  if !`ps aux`.match("netequality_reporter.pl")
#    system("/usr/bin/netequality_reporter.pl >> /tmp/netequality_reporter.log 2>&1 &")
#  end

  # hack, should actually check somehow that click is ready
  sleep(2)
end

load_config()
shutdown()
start()

$ath0_mac = mac_from_dev("ath0")
$srcr2_ip = ip_from_mac(2,$ath0_mac)
$srcr1_ip = ip_from_mac(1,$ath0_mac)
$sleep_time = 5

printf "found ath0 mac %s\n", $ath0_mac
printf "found srcr2_ip %s\n", $srcr2_ip

start_nat

if start_wireless_gateway()
  transition(@ROUTE_ATH0_DISASSOCIATED)
else
  start_click()
end

while (1)
  if ($route == @ROUTE_ATH0_ASSOCIATED && !ath1_associated())
    transition(@ROUTE_ATH0_DISASSOCIATED)
  elsif ($route == @ROUTE_ATH0_DISASSOCIATED && ath1_associated()) 
    transition(@ROUTE_ATH0_ASSOCIATED)
  elsif ($route == @ROUTE_UNCONFIG || $route == @ROUTE_NODE_ETH0_NO_CARRIER) && eth0_has_carrier()
    if try_dhcp_eth0()
      transition(@ROUTE_ETH0)
    else
      transition(@ROUTE_NODE_ETH0_CARRIER)
    end
  elsif ($route == @ROUTE_UNCONFIG || $route == @ROUTE_NODE_ETH0_CARRIER || $route == @ROUTE_ETH0) && !eth0_has_carrier
    transition(@ROUTE_NODE_ETH0_NO_CARRIER)
  end

  # only write this when we're running
  if ($route != @ROUTE_ATH0_DISASSOCIATED) 
    system("/usr/bin/read_handler srcr2/gw.metric > /proc/sys/net/ath0/meraki_gateway_metric")
  end
  sleep $sleep_time
end
