if [ "$1" == "" ]; then
    URLBASE=http://www.roofnet.net/ng-image/latest/
else
    URLBASE=$1
fi

echo "this will upgrade from ${URLBASE}"

if [ -f /MERAKI_ARCH ] && ( ! grep mipsel /MERAKI_ARCH ); then
    echo "this is only meant for upgrading netgear nodes"
    exit 1
fi

if cat /dev/mtd/`grep linux /proc/mtd | head -c 4 | tail -c 1` | head -c 4 | grep HDR0; then
    echo 'this is a 2.0.x node'
    echo 'starting upgrade process ...'
    cat /sbin/* /bin/* /usr/bin/* /usr/sbin/* /sbin/halt /usr/bin/killall /bin/umount > /dev/null
    mount -o remount,ro /dev/root /
    cd /tmp
    if ! wget ${URLBASE}/upgrade-from-2.0.x.trx; then
        echo "download failed!"
        rm -f upgrade-from-2.0.x.trx
        exit 1
    fi
    if ! [ `wc -c < upgrade-from-2.0.x.trx` -ge 3000000 ]; then
        echo "file too small!"
        rm -f upgrade-from-2.0.x.trx
        exit 1
    fi
    mtd -e linux -r write upgrade-from-2.0.x.trx linux
    exit 1
fi

if cat /dev/mtd/`grep linux /proc/mtd | head -c 4 | tail -c 1` | head -c 4 | grep ELF; then
    echo 'this is (hopefully) a recent build (not 2.0.x or 1.6.x)'
    cd /tmp
    if ! wget ${URLBASE}/stage2-embedded.elf; then
        echo "download failed!"
        rm -f stage2-embedded.elf
        exit 1
    fi
    if ! [ `wc -c < stage2-embedded.elf` -ge 3000000 ]; then
        echo "file too small!"
        rm -f stage2-embedded.elf
        exit 1
    fi
    mtd -e linux -r write stage2-embedded.elf linux
    exit 1
fi

echo 'unknown build!'
exit 1

