#!/usr/bin/perl -w

my $srcr = "srcr2";

my $ip = `read_handler $srcr/es.ip`;
chomp($ip);

my %FORM;
my $buffer;
# parse the form data.
read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
my @pairs = split(/&/, $buffer);
foreach my $pair (@pairs) {
    my ($name, $value) = split(/=/, $pair);
    $value =~ tr/+/ /;  
    $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;
    $FORM{$name} = $value;
}

my $channel = 0;

my $uplink_ssid = "";

my $uplink_enabled = "";
my $uplink_wep_key = "";

my $local_ssid = "";
my $local_wep_key = "";
my $local_wpa_key = "";

sub set_config {
    my ($key, $value) = @_;
    if (defined $value && $value ne "") {
	system "/usr/bin/config_set $key $value";
    }
    
}
# write a new config out if we got any new values
if (scalar(@pairs) > 0) {

    my $new_local_ssid = $FORM{"local_ssid"};
    my $new_channel = $FORM{"channel"};

    set_config("channel", $new_channel);
    my $ssid = $FORM{"uplink_ssid"};
    if ($ssid eq "none") {
      set_config("uplink_enabled", "false");
      set_config("uplink_ssid", "none");
    } else {
      set_config("uplink_enabled", "true");
      set_config("uplink_ssid", $FORM{"uplink_ssid"});
    }
    set_config("uplink_wep_key", $FORM{"uplink_wep_key"});
    set_config("uplink_wpa_key", $FORM{"uplink_wpa_key"});
    
    set_config("local_ssid", $new_local_ssid);
    set_config("local_wep_key", $FORM{"local_wep_key"});

    print "<html><head><META HTTP-EQUIV='Refresh' CONTENT='45; URL=index.pl'></head><body><H1>Rebooting...</H1>The home page will be displayed as soon as the router restarts (about 45 seconds).<P>If it doesn't, you probably don't have your computer set to automatically connect to the new SSID you set.</body></html>";
    system "/sbin/reboot";
    exit;
}


sub get_config {
    my ($key) = @_;

    my $r = `/usr/bin/config_get $key`;
    return $r;
}

$channel = get_config("channel");
$uplink_enabled = get_config("uplink_enabled");
$uplink_ssid = get_config("uplink_ssid");
$uplink_wep_key = get_config("uplink_wep_key");
$uplink_wpa_key = get_config("uplink_wpa_key");

$local_ssid = get_config("local_ssid");
$local_wep_key = get_config("local_wep_key");

if (! defined $uplink_enabled) {$uplink_enabled = "false"; }
if (! defined $uplink_ssid) {$uplink_ssid = ""; }
if (! defined $uplink_wpa_key) {$uplink_wpa_key = ""; }
if (! defined $channel) {$channel = "3"; }
if (! defined $uplink_wep_key) {$uplink_wep_key = ""; }
if (! defined $local_ssid) {$local_ssid = "roofnet"; }
if (! defined $local_wep_key) {$local_wep_key = ""; }

print "Content-type:text/html\n\n";
print <<EndHTML;
<head>
    <title>Configuration</title>
<link rel='stylesheet' media='screen' type='text/css' href='/style.css' />
<link rel='stylesheet' media='print' type='text/css' href='/print.css' />
<div class='stylehead'>
<div class='header'>
<div class='pagename'>
[[$ip]]
</div>
<div class='logo'>
<a href='http://roofnet.net/' name='top' accesskey='h' title='[ALT+H]' onclick='return svchk()' onkeypress='return svchk()'>Roofnet</a>
</div>
</div>
</head>

<body>
<P>
<h2>Changing SSID, Channel and Uplink SSID</h2>
<div class='level2'>
You can enter a new SSID and channel below.  <b>The changes won't take affect until you reboot this access point</b>.  Each roofnet access point can have a different SSID and they will still form a mesh with each other.  However, all roofnet access points that are part of the same network MUST be on the same channel.<BR>&nbsp;<P>The Uplink SSID allows you to extend an existing non-roofnet wireless network by entering its SSID.  This access point will then act as a repeater for that network.  You can further extend this repeater by adding other roofnet access points which will automatically mesh with this one. <P>A great use for this feature is to extend a municipal wireless network.  These typically don't have great indoor coverage.  By putting a roofnet access point near a window and entering the SSID of the municipal wireless network into the Uplink SSID, you can extend its coverage into your home or apartment.
<P>
<form action="configure.pl" method="POST">
    <table class="inline">
    <tr><td>SSID</td><td><input type="text" name="local_ssid" value="$local_ssid"></td></tr>
    <tr><td>Channel</td><td><input type="text" name="channel" value="$channel"></td></tr>
    <tr><td>Uplink SSID (or "none")</td><td><input type="text" name="uplink_ssid" value="$uplink_ssid"></td></tr>
    </table>
<input type="submit" value="Save & Reboot Now">
<input type="reset" value="Clear Form">
</form>
</div>
</body></html>


EndHTML
