#!/usr/bin/perl -w

print "Content-type: text/html\n";
print "\n";
my $ip = `/usr/bin/read_handler srcr2/es.ip`;
chomp($ip);
print "<html><head>\n";
print "<title>Scan Results for $ip</title>";
print "<link rel='stylesheet' media='screen' type='text/css' href='/style.css' />";
print "<link rel='stylesheet' media='print' type='text/css' href='/print.css' />";
print "</head>";
print "<body>";

print "<div class='stylehead'>";
print "<div class='header'>";
print "<div class='pagename'>";
print "[[<a href='http://meraki.net/' onclick='return svchk()' onkeypress='return svchk()'>$ip</a>]]";
print "</div>";
print "<div class='logo'>";
print "<a href='http://meraki.net/' name='top' accesskey='h' title='[ALT+H]' onclick='return svchk()' onkeypress='return svchk()'>Meraki Networks</a>";
print "</div>";
print "</div>";
print "<h2>Scan Results:</h2>";
my $r = `cat /proc/net/madwifi/ath0/scan_results`;

my %aps;

my $bssid = "";
foreach my $line (split /\n/, $r) {
    if ($line =~ /^bssid: (\S+)/) {
	$bssid = $1;
#	print "got bssid $bssid\n";
    } elsif ($line =~ /^ ssid: \"(\S+)\"$/) {
	$aps{$bssid}{ssid} = $1;
    } elsif ($line =~ /^ channel: (\d+)/) {
	$aps{$bssid}{channel} = $1;
#	print "got channel $1\n";
    } elsif ($line =~ /^ rssi: (\d+)/) {
	$aps{$bssid}{rssi} = $1;
#	print "got rssi $1\n";
    } elsif ($line =~ /^ rev_rssi: (\d+)/) {
	$aps{$bssid}{rev_rssi} = $1;
#	print "got rev_rssi $1\n";
    }
    
}

print "<div class='level2'>";
print "<table BORDER=0 cellspacing=5 class=inline>";
print "<tr><th>ssid</th><th>ap</th><th>rssi</th><th>rev_rssi</th><th>channel</th></tr>";
sub by_ssid_rssi {
    if (defined $aps{$a}{ssid} && defined ${aps}{$b}{ssid} &&
	$aps{$b}{ssid} ne $aps{$a}{ssid}) {
	return $aps{$b}{ssid} cmp $aps{$a}{ssid};
    }
    return $aps{$b}{rssi} <=> $aps{$a}{rssi};
}
my @a;
foreach my $bssid (keys %aps) {
#    next if !defined $aps{$bssid}{ssid};
    next if !defined $aps{$bssid}{rssi};
    next if !defined $aps{$bssid}{channel};
    push @a, $bssid;
}
my $last_ssid;
foreach my $bssid (sort by_ssid_rssi @a) {
    my $ssid = $aps{$bssid}{ssid};
    print "<tr>";
    print "<td>$aps{$bssid}{ssid}</td>";
    print "<td>$bssid</td>";

    print "<td>$aps{$bssid}{rssi}</td>";
    print "<td>$aps{$bssid}{rev_rssi}</td>";

    print "<td>$aps{$bssid}{channel}</td>";
    print "</tr>";
    print "\n";

    $last_ssid = $ssid;
}
print "</table></div>\n";
print "</body></html>\n";
