#ifndef FLASH_LAYOUT_H
#define FLASH_LAYOUT_H


/*

mem addr    erase sector  size		
0xa8000000  0-3			  192k	RedBoot
0xa8030000  3-5			  128k  stage2
0xa8050000  5-21		  1024k /storage
0xa8150000  21-73		  3328k part1
0xa8490000  73-125		  3328k part2
0xa87d0000  125			  64k	fis/redboot config
0xa87e0000  126			  64k	board data
0xa87f0000  127			  64k	radio config
0xa8800000  end

*/

#define PARTITION_SIZE			(52*64*1024)
#define FLASH_BASE				0xa8000000
#define FLASH_SIZE				0x800000
#define PART1_ADDR				0xa8150000
#define PART2_ADDR				0xa8490000

struct partition_data {
	unsigned int lzma_compressed_length;
	unsigned int lzma_compressed_crc32;
	char lzma_compressed_data[0];
};

#endif
