STAGE2_DIR := stage2

# we have the load address set low so that RedBoot is happy

STAGE2_BUILD_DIR := $(BUILD_DIR)/stage2
BUILD_DIRECTORIES += $(STAGE2_BUILD_DIR)

ifeq ($(BOARD), brcm)
LOAD_TEXT_START := 0x80001000
# RAM start + 20M
RUN_TEXT_START  := 0x81400000
KERNEL_ENTRY := 0x80001000
BOARD_DEFINE := BRCM
STAGE2_EMBEDDED_KERNEL_LZMA := $(LINUX_BUILD_DIR)/vmlinux-meraki.bin.lzma
endif
ifeq ($(BOARD), ar531x)
# RAM start + 1M
LOAD_TEXT_START := 0x80100000
# RAM start + 20M
RUN_TEXT_START  := 0x81400000
KERNEL_ENTRY := 0x80041000
BOARD_DEFINE := AR531X
STAGE2_EMBEDDED_KERNEL_LZMA := $(LINUX_BUILD_DIR)/vmlinux-meraki.bin.fast.lzma
endif

CFLAGS := -fno-builtin -Os -G 0 -mno-abicalls -fno-pic -Wall -DKERNEL_ENTRY=${KERNEL_ENTRY} -DLOAD_TEXT_START=${LOAD_TEXT_START} -DRUN_TEXT_START=${RUN_TEXT_START} -D_LZMA_IN_CB -D${BOARD_DEFINE}


STAGE2_FILES := \
	$(STAGE2_BUILD_DIR)/start.o \
	$(STAGE2_BUILD_DIR)/decompress.o \
	$(STAGE2_BUILD_DIR)/LzmaDecode.o \
	$(STAGE2_BUILD_DIR)/crc32.o \
	$(STAGE2_BUILD_DIR)/dbg_io.o


rootfs: $(ROOT_DIR)/usr/bin/crc

$(STAGE2_BUILD_DIR)/%.o: $(STAGE2_DIR)/%.S $(PREPARE_STAMP)
	$(CC) $(CFLAGS) -o $@ -c $<

$(STAGE2_BUILD_DIR)/%.o: $(STAGE2_DIR)/%.c ar531x/flashlayout.h $(PREPARE_STAMP)
	$(CC) $(CFLAGS) -o $@ -c $<

$(STAGE2_BUILD_DIR)/:
	mkdir -p $@

$(STAGE2_BUILD_DIR)/stage2-embedded.lds: $(STAGE2_DIR)/stage2.lds.in $(PREPARE_STAMP)
	sed -e 's,@LOADADDR@,$(RUN_TEXT_START),g' $< > $@.half
	sed -e 's,@EMBEDDED_KERNEL@,$(STAGE2_BUILD_DIR)/kernel.o,g' $@.half > $@
	rm $@.half

$(STAGE2_BUILD_DIR)/stage2-flash.lds: $(STAGE2_DIR)/stage2.lds.in $(PREPARE_STAMP)
	sed -e 's,@LOADADDR@,$(RUN_TEXT_START),g' $< > $@.half
	sed -e 's,@EMBEDDED_KERNEL@,,g' $@.half > $@
	rm $@.half

$(LINUX_BUILD_DIR)/vmlinux-meraki.bin: $(LINUX_BUILD_DIR)/vmlinux-meraki
	$(OBJCOPY) -O binary $< $@

%.bin: %.elf
	$(OBJCOPY) -O binary $< $@

%.lzma: %
	$(LZMA) e $< $@

%.fast.lzma: %
	$(LZMA) e $< $@ -a0 -mfhc3 -d16 -fb5



$(STAGE2_BUILD_DIR)/kernel.o: $(STAGE2_EMBEDDED_KERNEL_LZMA)
	$(LD) -r -b binary --oformat `$(OBJDUMP) -i | head -2 | grep elf32` -o $@ $<

$(BUILD_DIR)/stage2-embedded.elf: $(STAGE2_BUILD_DIR)/stage2-embedded.lds $(STAGE2_BUILD_DIR)/kernel.o ${STAGE2_FILES}
	$(LD) -s -T$< -o $@.noreloc $(STAGE2_FILES) $(STAGE2_BUILD_DIR)/kernel.o
	$(OBJCOPY) -j .text --adjust-vma=$$(($(LOAD_TEXT_START)-$(RUN_TEXT_START))) $@.noreloc $@

$(BUILD_DIR)/stage2-flash.elf: $(STAGE2_BUILD_DIR)/stage2-flash.lds ${STAGE2_FILES}
	$(LD) -s -T$< -o $@.noreloc $(STAGE2_FILES)
	$(OBJCOPY) -j .text --adjust-vma=$$(($(LOAD_TEXT_START)-$(RUN_TEXT_START))) $@.noreloc $@

$(BUILD_DIR)/crc: $(STAGE2_DIR)/crc.c $(STAGE2_DIR)/crc32.c
	gcc -o $@ $^

$(ROOT_DIR)/usr/bin/crc: $(STAGE2_DIR)/crc.c $(STAGE2_DIR)/crc32.c $(PREPARE_STAMP)
	$(CC) -o $@ $(STAGE2_DIR)/crc.c $(STAGE2_DIR)/crc32.c
