/*
 * Fast Fourier Transform.
 * Adapted from file "four1.c" from Numerical Recipes.
 */

#include "complex.h"

#define SWAP(a,b) temp=(a);(a)=(b);(b)=temp

/*
 * calculate a one-dimensional Fast Fourier Transform "in place".
 *    data[] -- array used for both input and output
 *    nn --     array size
 * if isign==1, calculate the FFT
 * if isign==-1, calculate the inverse FFT multiplied by nn
 */
void fft(complex data[], unsigned long nn, int isign)
{
	unsigned long mmax,m,j,istep,i;
	complex theta;

	complex w,wp,temp;

	j=0;
	for (i=0; i<nn; i++) {
		if (j > i) {
			SWAP(data[j],data[i]);
		}
		m=nn >> 1;
		while (m >= 1 && j >= m) {
			j -= m;
			m >>= 1;
		}
		j += m;
	}
	mmax=1;
	while (mmax < nn) {
		istep=mmax << 1;
		theta=isign*(M_PI/mmax)*1i;
		wp=cexp(theta)-1.0;     /* function args must be variables */
                                         /* because of a bug in GCC (sigh) */
		w = 1.0;
		for (m=0; m<mmax; m++) {
			for (i=m; i<nn; i+=istep) {
				j=i+mmax;
				temp=w * data[j];
				data[j]=data[i] - temp;
				data[i] += temp;
			}
			w = (w*wp) + w;
		}
		mmax=istep;
	}
}
#undef SWAP
