#include "ps5/http_server.h"
#include "ps5/simple_response.h"
#include "ps5/dir_node.h"
#include "ps5/file_node.h"
#include "ps4/sockstream.h"

#include <stdlib.h>
#include <errno.h>
#include <unistd.h>

class simple_node : public web_node {
public:
    simple_node(string text_) { text = text_; }
    http_response *get(string request, extensions *) {
	return new simple_response(text, true);
    }
private:
    string text;
};

int main(int argc, char* argv[]) {
    if (argc != 2) {
	cout << "Usage: " << argv[0] << " <port-number> \n";
	exit(1);
    }
    int port = atoi(argv[1]);
    if (errno) {
	cout << "port-number non-integral";
	exit(1);
    }

    dir_node *d = new dir_node("");
    dir_node *d2;
    http_server *serv = new http_server(port, d);
    serv->debug(true);
    d->add("ps5",
	new simple_node("This is a <em>boring</em> web page<p>"
			"<form method=\"POST\" action=\"/6.170/src/ps5\">"
	                "See problem set 5 include files"
	                "<input type=submit>"));
    d->add("6.170", new file_node("/afs/athena/course/6/6.170", "6.170"));
    d2 = new dir_node("d2");
    d->add("d2", d2);
    d2->add("simple1", new simple_node("simple node 1"));
    d2->add("simple2", new simple_node("simple node 2"));
    for(;;) {
	serv->handle_one();
    }
    serv->close();
    return 0;
}
