/**********************************************************************
 * Menu library header file
 *
 * $Author: lwvanels $
 * $Source: /afs/athena.mit.edu/astaff/project/olhdev/src/include/RCS/menu.h,v $
 * $Header: /afs/athena.mit.edu/astaff/project/olhdev/src/include/RCS/menu.h,v 1.9 91/06/30 18:50:29 lwvanels Exp $
 *
 * Copyright (c) 1990, Massachusetts Institute of Technology
 **********************************************************************/

#ifndef __MENU_H__
#define __MENU_H__

#ifndef lint
#ifndef SABER
static char rcsid_menu_h[] = "$Header: /afs/athena.mit.edu/astaff/project/olhdev/src/include/RCS/menu.h,v 1.9 91/06/30 18:50:29 lwvanels Exp $";
#endif
#endif

#include <stdio.h>
#include <menu_et.h>

/****************************************************************
 * The main structures used in the menu libary are
 *    EntryField -- two strings: the field name and field value
 *    MenuEntry -- basically an array of fields
 *    Menu -- basically an array of menu entries
 *
 * Use the macros defined in primitive.c and fields.c to handle
 * Menu and MenuEntry structures.
 ****************************************************************/

typedef struct _EntryField
{
  char *name, *value;
} EntryField;
  
typedef struct _MenuEntry
{
  int size;
  int n_alloc;
  EntryField *field;
} MenuEntry;

#define ENT_A_SIZE 20

typedef struct _Menu
{
  int size;
  int n_alloc;
  MenuEntry *entry;
  char *id, *file;
} Menu;

#define MENU_A_SIZE 20

/************************************************
 * standard field names
 ************************************************/

extern char *TYPE;
extern char *NODE_ID;
extern char *MODIFY_DATE;
extern char *NODE_LABEL;
extern char *AUTHOR;
extern char *MAINTAINER;
extern char *KEYWORDS;
extern char *FILE_FORMAT;
extern char *FILE_LOCATION;
extern char *FILESYSTEM;
extern char *GROUP_ID;
extern char *POINTER;
extern char *PARENT;
extern char *DO_KEYWORDS;
extern char *IN_KEYWORDS;
extern char *FORMATTER;
extern char *MPARENT;
extern char *TTY;
extern char *X;
extern char *LPTLN;
extern char *ASCII_FILE;

#define CONFIG_MENU "/mit/logos/lib/config.menu"
#define CONFIG_FILSYS "logos"

/* Convenient macros */
#define size_entry(e)	(e)->size
#define size_menu(m)	(m)->size
#define nth_field(e, n)	&((e)->field[(n)])
#define nth_entry(m, n)	&((m)->entry[(n)])

#define is_dirhook(e)	!strcasecmp(field_value((e), FILE_FORMAT), "DIRHOOK")
#define is_menu(e)	(!strcasecmp(field_value((e), FILE_FORMAT), "MENU") \
			 || is_dirhook((e)))
#define is_doc(e)	!strcasecmp(field_value(e, TYPE), "DOCUMENT")
#define config_menu	(*menus_loaded)

/* Global variable */
extern Menu **menus_loaded;

#ifdef __STDC__
# define	P(s) s
#else
# define P(s) ()
#endif


#ifdef LOG_USAGE
void log_startup P((char *type));
void log_view P((char *view_id ));
#endif

/* attach.c */
long olh_attach P((char *filsys, int map));

/* colons.c */
int break_colons P((char s [], char *array []));

/* dirhook_file.c */
char *dirhook_type_translate P((char *s ));
long dirhook_file_load P((char *filename , Menu **mp ));
int directory_load_entries_compar P((MenuEntry *e1 , MenuEntry *e2 ));
long directory_load_entries P((char *filename , Menu **mp ));

/* fields.c */
long field_set P((MenuEntry *entry , char *name , char *value ));
char *field_value P((MenuEntry *entry , char *name ));
void free_fields P((MenuEntry *entry ));

/* hash.c */
char *in_word_set P((register const char *str , register int len ));
void init_hash_table P((void ));

/* menu.c */
long menu_load P((MenuEntry *e , Menu **mp ));
long main_menu_load P((Menu **mp ));
long menu_init P((char *conf ));
char *group_file_location P((char *s ));
MenuEntry *find_group P((char *s ));

/* menu_alloc.c */
long newmenu P((Menu **mp ));
void freemenu P((Menu *m ));
long resizemenu P((Menu *m , int n ));
long insertentry P((Menu *m , int n ));
long deleteentry P((Menu *m , int n ));

/* menu_et.c */
void initialize_menu_error_table P(( void ));

/* menu_file.c */
long menu_file_save P((Menu *m , char *filename ));
char *_get_field_name P((char *s ));
char *_get_field_value P((char *s ));
long menu_file_load P((char *filename , Menu **mp ));

/* plaintext.c */
FILE *doc_stream P((MenuEntry *e ));
char *doc_string P((MenuEntry *e ));

/* pointer.c */
long pointerEntry P((char *s , MenuEntry **e ));

/* strcasecmp.c */
int strcasecmp P((const char *s1 , const char *s2 ));
int strncasecmp P((const char *s1 , const char *s2 , size_t n ));

/* viewer.c */
long viewdoc P((MenuEntry *e , char *device , char *prefix ));

/* Hooks */
extern void (*olh_attach_hook)P((char *));
extern void (*olh_attach_done_hook)P((char *, long));

#undef P

#endif /* __MENU_H__ */
