/*
 * This file is part of the OLH On-Line Help system
 *
 *	Chris VanHaren
 *      MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *      $Source: /source/athena/athena.bin/olh/motif/RCS/Highlight.c,v $
 *      $Id: Highlight.c,v 1.1 1992/05/01 17:09:05 lwvanels Exp $
 *      $Author: lwvanels $
 */

/*
 *  Highlight.c
 *	** The DrawHighlight routine is taken directly from Xm/List.c.
 *	Since there is no public method for setting the highlighted item, I
 *	have to muck with the private state of the widget.
 */

#include <X11/Xlib.h>
#include <Xm/ListP.h>

#include "global.h"

/************************************************************************
 *									*
 * XmGetHighlight - Get the highlighted item in a list widget.		*
 *									*
 ************************************************************************/
int XmGetHighlight(lw)
     XmListWidget lw;
{
  return (lw->list.CurrentKbdItem);
}

/************************************************************************
 *									*
 * XmSetHighlight - Set the highlighted item in a list widget.		*
 *									*
 ************************************************************************/
void XmSetHighlight(lw,position)
     XmListWidget lw;
     int	position;
{
  if (lw->list.CurrentKbdItem)
    XmDrawHighlight(lw,lw->list.CurrentKbdItem, FALSE);
  lw->list.CurrentKbdItem = position;
  XmDrawHighlight(lw,lw->list.CurrentKbdItem, TRUE);
}

/************************************************************************
 *									*
 * XmDrawHighlight - Draw or clear the traversal highlight on an item.	*
 *									*
 ************************************************************************/
void XmDrawHighlight(lw,position,on)
     XmListWidget lw;
     int	 position;
     int	 on;
{
  register int  width, height, x, y, ht;
  GC  gc;
  XRectangle rect[4];

  if (!XtIsRealized(lw)) return;

  if (position < lw->list.top_position) return;
  if (position >= (lw->list.top_position + lw->list.visibleItemCount)) return;
    
  ht = lw->primitive.highlight_thickness;
  if (ht < 1) return;
  x = lw->list.BaseX - ht;
  y = (lw->list.InternalList[position]->CumHeight - 
       lw->list.InternalList[lw->list.top_position]->CumHeight) +
	 lw->list.BaseY - ht;

  width = lw->core.width - 2 * ((int )lw->list.margin_width + 
				lw->primitive.shadow_thickness);


  height = lw->list.InternalList[position]->height + 
    (2 * ht);

  if (width <=  0 || height <= 0) return;

  if (on)
    {
      gc = lw->list.HighlightGC;

      rect[0].x = x;
      rect[0].y = y;
      rect[0].width = width;
      rect[0].height = ht;

      rect[1].x = x;
      rect[1].y = y;
      rect[1].width = ht;
      rect[1].height = height;

      rect[2].x = x + width - ht;
      rect[2].y = y;
      rect[2].width = ht;
      rect[2].height = height;

      rect[3].x = x;
      rect[3].y = y + height - ht;
      rect[3].width = width;
      rect[3].height = ht;

      XFillRectangles (XtDisplay (lw), XtWindow (lw), gc, &rect[0], 4);
    }
  else
    {
      XClearArea (XtDisplay (lw), XtWindow (lw),
		  x, y, width, ht, False);

      XClearArea (XtDisplay (lw), XtWindow (lw),
		  x, y, ht, height, False);

      XClearArea (XtDisplay (lw), XtWindow (lw),
		  x + width - ht, y, 
		  ht, height, False);

      XClearArea (XtDisplay (lw), XtWindow (lw),
		  x, y+ height - ht,
		  width, ht, False);
    }
}
