/*
 * This file is part of the OLH On-Line Help system
 *
 *      Chris VanHaren
 *	Lucien Van Elsen
 *      MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *      $Source: /source/athena/athena.bin/olh/motif/RCS/Olh.cpp,v $
 *      $Id: Olh.cpp,v 1.14 1992/07/13 16:47:30 lwvanels Exp $
 *      $Author: lwvanels $
 */

#include "widget_num.h"
!
!  "Global" fonts
!
#ifdef _IBMR2
*XmText.fontList:			-adobe-*schoolbook-medium-r-normal--14-*
*fontList:				-adobe-*schoolbook-medium-r-normal--12-*
#else
*XmText.fontList:			-adobe-*schoolbook-medium-r-*-*-*-140-*
*fontList:				-adobe-*schoolbook-medium-r-*-*-*-120-*
#endif
!
!  "Global" behaviors
!
*XmLabelGadget.alignment:		alignment_beginning
*XmSeparatorGadget.separatorType:	SHADOW_ETCHED_IN
*XmText.blinkRate:			300
*scrollBarDisplayPolicy:		STATIC
*XmFrame.shadowThickness:		0
*XmList.selectionPolicy:		SINGLE_SELECT
*XmList.listMarginWidth:		5
*XmList.listSpacing:			0
*XmList*doubleClickInterval:		400
!*XmList.traversalOn:			TRUE
!  Setting traversal on will be nifty in the future, so that we can have
!  keyboard selection in the list widgets.
!
*XmList.highlightThickness:		0
*XmPanedWindow.spacing:			15
*XmText.editable:			FALSE
*XmText.editMode:			MULTI_LINE_EDIT
!
!  Individual widgets
!
Olh.title:			On-Line Help
Olh.iconName:			OLH
Olh.iconPixmap:			olh.xbm
#ifdef _IBMR2
Olh.minWidth:			488
Olh.minHeight:			470
#else
Olh.minWidth:			385
Olh.minHeight:			450
#endif
Olh.geometry:			+0+30
Olh.useViewers:			True
Olh.borderWidth:		2

!
*printerList:			ajax barker bias ceres electra europa hayden helios homer linus manda medea pandora picus pindar plato python sanda scheme thesis varan virus w20-east-1 w20-east-2 w20-east-3 w20-east-4
!
#ifdef _IBMR2
*main.width:			600
*main.height:			604
#else
*main.width:			470
*main.height:			500
#endif

*main*traversalOn:		FALSE
*main.shadowThickness:		2
*main.horizontalSpacing:	5
*main.verticalSpacing:		5
!
*banner.fontList:		-adobe-*schoolbook-bold-r-*-*-*-180-*
*banner.labelString:		Athena On-Line Help Service  (OLH)
*banner.topAttachment:		ATTACH_FORM
*banner.leftAttachment:		ATTACH_FORM
!
*menubar.topAttachment:		ATTACH_WIDGET
*menubar.topWidget:		banner
*menubar.leftAttachment:	ATTACH_FORM
*menubar.rightAttachment:	ATTACH_FORM
!
! MENUBAR RESOURCES
!
*toggleHistory.value:		off
*toggleHistory.on.labelString:	Show History Panel
*toggleHistory.off.labelString:	Hide History Panel
!
*menubar.items: \
  file:		"_File"		->file					;\
  search:	"_Search"	->search				;\
  options:	"_Options"	->options				;\
  suggest:	"S_uggest"	->suggest				;\
  help:		"_Help"		->help		help			;
*menubar*file.items: \
  "_Print Module"		[Meta+P]	File(PRINT_DLG)		;\
  "_Copy Module"		[Meta+C]	File(COPY_DLG)		;\
  "Show _Info on Module"	[Meta+I]	File(INFO_DLG)		;\
  "-"									;\
  "_Quit"			[Meta+Q]	button(QUIT_BTN)	;
*menubar*search.items: \
  keyword:	"_Keyword Search"	[Meta+K]	button(KWD_BTN)	;
!
!
#ifdef HIDDEN  /****  Bookmarks are not yet implemented.  ****/
  "Bookmark Search"		->bookmarks				;
menubar*bookmarks.items: \
  "_User Bookmarks"				button(USER_BKMK_BTN)	;\
  "_Consultant Bookmarks"			button(CONSULTANT_BKMK_BTN) ;\
  "_Other Bookmarks"				button(OTHER_BKMK_BTN) ;
#endif         /****  Bookmarks.  ****/
!
!
*menubar*options.items: \
  "Go to _Top Menu"		[Meta+T]	button(TOP_BTN)		;\
ev:  "Use _External Viewers"	togoff [Meta+E]	toggleb(0)		;\
  "Show _Version"		[Meta+V]	button(VERSION_BTN)	;
!
!
#ifdef HIDDEN  /****  Also commented out in main.c  ****/
  hist_tog:	"Show/Hide _History Panel"	button(HIST_TOG)	;
#endif         /****  Also commented out in main.c  ****/
!
!
*menubar*suggest.items: \
  "Send _Comment to maintainers"		button(SUGGEST_BTN)	;\
  "Send _Bug report to maintainers"		button(BUG_BTN)		;
!
!
!
*paneForm.topAttachment:	ATTACH_WIDGET
*paneForm.topWidget:		menubar
*paneForm.leftAttachment:	ATTACH_FORM
*paneForm.rightAttachment:	ATTACH_FORM
*paneForm.bottomAttachment:	ATTACH_WIDGET
*paneForm.bottomWidget:		messageSep
*pane.topAttachment:		ATTACH_FORM
*pane.leftAttachment:		ATTACH_FORM
*pane.rightAttachment:		ATTACH_FORM
*pane.bottomAttachment:		ATTACH_FORM
!
*menuForm.topAttachment:	ATTACH_WIDGET
*menuForm.topWidget:		menubar
!*menuForm.topAttachment:	ATTACH_FORM
*menuForm.leftAttachment:	ATTACH_FORM
*menuForm.rightAttachment:	ATTACH_FORM
*menuForm.bottomAttachment:	ATTACH_WIDGET
*menuForm.bottomWidget:		messageSep
!*menuForm.bottomAttachment:	ATTACH_FORM
*menuForm.paneMinimum:		150
*menuForm.verticalSpacing:	5
*menuForm.horizontalSpacing:	5
!
!!!!  These are resources for a test widget....
*bar.labelString:		Hi There.
*bar.topAttachment:		ATTACH_FORM
*bar.leftAttachment:		ATTACH_FORM
*bar.rightAttachment:		ATTACH_FORM
!
*bar.translations:		#replace \
				<Btn1Down>: Activate() \n\
				<Btn2Down>: Activate() \n\
				<Btn3Down>: Activate()
!!!!
*menuName*fontList:		-adobe-*schoolbook-medium-r-*-*-*-140-*
!*menuName.topWidget:		bar
!*menuName.topAttachment:	ATTACH_WIDGET
*menuName.topAttachment:	ATTACH_FORM
*menuName.leftAttachment:	ATTACH_FORM
*menuName.rightAttachment:	ATTACH_FORM
!
*menuPulldown*fontList:		-adobe-*schoolbook-medium-r-*-*-*-140-*
!
*menuListSW.topAttachment:	ATTACH_WIDGET
*menuListSW.topWidget:		menuName
*menuListSW.leftAttachment:	ATTACH_FORM
*menuListSW.rightAttachment:	ATTACH_FORM
*menuListSW.bottomAttachment:	ATTACH_WIDGET
*menuListSW.bottomWidget:	up
!
*menuList.traversalOn:		TRUE
!
*up.labelString:		Step Up Menu
*up.sensitive:			FALSE
*up.rightAttachment:		ATTACH_FORM
*up.bottomAttachment:		ATTACH_FORM
*up.accelerators:		#override ~Meta <Key>U:	ArmAndActivate() \n\
				<Key>Left:	ArmAndActivate()
!
*previous.labelString:		View Previous
*previous.leftAttachment:	ATTACH_FORM
*previous.bottomAttachment:	ATTACH_FORM
*previous.accelerators:		#override ~Meta <Key>P:	ArmAndActivate()
!
*view.labelString:		View Selected
*view.leftAttachment:		ATTACH_WIDGET
*view.leftWidget:		previous
*view.bottomAttachment:		ATTACH_FORM
*view.accelerators:		#override \
				~Meta <Key>.:	ArmAndActivate() \n\
				~Meta <Key>V:	ArmAndActivate() \n\
				~Meta <Key>S:	ArmAndActivate() \n\
				<Key>Right:	ArmAndActivate()
!
*next.labelString:		View Next
*next.leftAttachment:		ATTACH_WIDGET
*next.leftWidget:		view
*next.bottomAttachment:		ATTACH_FORM
*next.accelerators:		#override ~Meta <Key>N:	ArmAndActivate()
!
*histForm.topAttachment:	ATTACH_FORM
*histForm.leftAttachment:	ATTACH_FORM
*histForm.rightAttachment:	ATTACH_FORM
*histForm.bottomAttachment:	ATTACH_FORM
*histForm.paneMinimum:		150
*histForm.marginWidth:		25
*histForm.Spacing:		5
!
!
*history.labelString:		History of Selections
*history.topAttachment:		ATTACH_FORM
*history.leftAttachment:	ATTACH_FORM
*history.rightAttachment:	ATTACH_FORM
!
*histFrame.topAttachment:	ATTACH_WIDGET
*histFrame.topWidget:		history
*histFrame.leftAttachment:	ATTACH_FORM
*histFrame.rightAttachment:	ATTACH_FORM
*histFrame.bottomAttachment:	ATTACH_WIDGET
*histFrame.bottomWidget:	goto
!
*histList.topAttachment:	ATTACH_FORM
*histList.leftAttachment:	ATTACH_FORM
*histList.rightAttachment:	ATTACH_FORM
*histList.bottomAttachment:	ATTACH_FORM
!
*back.labelString:		Step Backward
*back.leftAttachment:		ATTACH_FORM
*back.bottomAttachment:		ATTACH_FORM
*back.sensitive:		FALSE
!
*goto.labelString:		Go To Selected
*goto.leftAttachment:		ATTACH_WIDGET
*goto.leftWidget:		back
*goto.bottomAttachment:		ATTACH_FORM
*goto.sensitive:		FALSE
!
*forward.labelString:		Step Forward
*forward.leftAttachment:	ATTACH_WIDGET
*forward.leftWidget:		goto
*forward.bottomAttachment:	ATTACH_FORM
*forward.sensitive:		FALSE
!
*last.labelString:		Go to end of history
*last.rightAttachment:		ATTACH_FORM
*last.bottomAttachment:		ATTACH_FORM
*last.sensitive:		FALSE
!
*message.leftAttachment:	ATTACH_FORM
*message.bottomAttachment:	ATTACH_FORM
!
*copyright:			Copyright  1992 Massachusetts Institute of Technology     XOLH v1.1
*helpDir:			/mit/logos/lib/help_files
*helpLocker:			logos
!
*wait.attach:			Attaching "%s".  Please wait.
*wait.viewer:			Starting external viewer.  Please wait.
*wait.lpr:			Submitting job to printer.  Please wait.
!
*warning.noneSelected:		No items currently selected.\nPlease make a selection and try again.
*warning.copyMenu:		You cannot copy a menu.\nPlease select a document instead and try again.
*warning.printMenu:	      	You cannot print a menu.\nPlease select a document instead and try again.
*warning.emptyMenu:	      	That menu is empty.  Please select another.
*warning.noconvert:		That module cannot be viewed with the internal viewer.\n  To view it, you will need to enable external viewers in the options menu.
!
*message.noneSelected:		Nothing selected yet.  Press "View Selected" again to view the first entry.
*message.noMore:		No more entries.  Press "Next" again to step up one level.
*message.noPrev:		No previous entries.  Press "Previous" again to step up one level.
*message.topAndNoMore:		No more entries, and there are no menus above this one.
*message.topAndNoPrev:		No previous entries, and there are no menus above this one.
*message.noMoreUp:		There are no more menus up from here.  You are at the top-level menu.
*message.noKeywordSelected:	No keyword has been selected yet.  Please select a keyword and try again.
*message.noKeywordMatch:	No keywords begin with "%s".
*message.KeywordWait:		Please wait; creating keyword list.
!
*quit.labelString:		Quit
*quit.rightAttachment:		ATTACH_FORM
*quit.bottomAttachment:		ATTACH_FORM
*quit.accelerators:		#override  Meta<Key>Q:	ArmAndActivate()
!
*messageSep.leftAttachment:	ATTACH_FORM
*messageSep.rightAttachment:	ATTACH_FORM
*messageSep.bottomAttachment:	ATTACH_WIDGET
*messageSep.bottomWidget:	quit
!
! Pop-up Text Viewer
!
*textView.title:		On-Line Help Text
*textView.iconName:		OLH Text
!*textView*iconPixmap:		olh_text.xbm
*textView.minWidth:		520
*textView.minHeight:		200
*textView.geometry:		-0+30
*textView.borderWidth:		2
!
*textForm.shadowThickness:	2
*textForm.width:		520
*textForm.height:		500
!
*textForm.topAttachment:	ATTACH_FORM
*textForm.leftAttachment:	ATTACH_FORM
*textForm.rightAttachment:	ATTACH_FORM
*textForm.bottomAttachment:	ATTACH_FORM
*textForm.Spacing:		5
!
*textLabel.topAttachment:	ATTACH_FORM
*textLabel.leftAttachment:	ATTACH_FORM
*textLabel.rightAttachment:	ATTACH_FORM
*textLabel.alignment:		ALIGNMENT_CENTER
*textLabel.fontList:		-adobe-*schoolbook-bold-r-*-*-*-140-*
!
*textSW.topAttachment:		ATTACH_WIDGET
*textSW.topWidget:		textLabel
*textSW.leftAttachment:		ATTACH_FORM
*textSW.rightAttachment:	ATTACH_FORM
*textSW.bottomAttachment:	ATTACH_WIDGET
*textSW.bottomWidget:		textClose
!
*text.fontList:			fixed
*text.scrollVertical:		TRUE
*text.scrollHorizontal:		FALSE
!
!*textClose.showAsDefault:	1
*textClose.labelString:		Close Window
*textClose.rightAttachment:	ATTACH_FORM
*textClose.bottomAttachment:	ATTACH_FORM
*textClose.accelerators:	#override  ~Meta <Key>C: ArmAndActivate()
!
! SENDBUG DIALOG
!
*sendbugDialog.title:		Olh Bug Report
*sendbugDialog.iconName:	Olh Bug Report
*sendbugDialog.width:		510
*sendbugDialog.height:		200
*sendbugDialog.borderWidth:	2
*sendbugForm.Spacing:		10
*sendbugForm.shadowThickness:	2
!
*sendbugLabel.labelString:	Type the text of your bug report.  Press "send" button to mail it, "cancel" to discard it.
*sendbugLabel.topAttachment:	ATTACH_FORM
*sendbugLabel.leftAttachment:	ATTACH_FORM
*sendbugLabel.rightAttachment:	ATTACH_FORM
*sendbugLabel.alignment:	ALIGNMENT_CENTER
!
*sendbugSend.labelString:	Send
*sendbugSend.leftAttachment:	ATTACH_FORM
*sendbugSend.bottomAttachment:	ATTACH_FORM
!
*sendbugClose.labelString:	Cancel
*sendbugClose.rightAttachment:	ATTACH_FORM
*sendbugClose.bottomAttachment:	ATTACH_FORM
!
*sendbugSep.leftAttachment:	ATTACH_FORM
*sendbugSep.rightAttachment:	ATTACH_FORM
*sendbugSep.bottomAttachment:	ATTACH_WIDGET
*sendbugSep.bottomWidget:	sendbugClose
!
*sendbugTextSW.topAttachment:	ATTACH_WIDGET
*sendbugTextSW.topWidget:	sendbugLabel
*sendbugTextSW.leftAttachment:	ATTACH_FORM
*sendbugTextSW.rightAttachment:	ATTACH_FORM
*sendbugTextSW.bottomAttachment:ATTACH_WIDGET
*sendbugTextSW.bottomWidget:	sendbugSep
!
*sendbugText.fontList:		fixed
*sendbugText.scrollVertical:	TRUE
*sendbugText.scrollHorizontal:	FALSE
*sendbugText.editable:		TRUE
*sendbugText.wordWrap:		TRUE
!
! SUGGEST DIALOG
!
*suggestDialog.title:		Olh Suggestion
*suggestDialog.iconName:	Olh Suggestion
*suggestDialog.height:		200
*suggestDialog.width:		510
*suggestDialog.borderWidth:	2
*suggestForm.Spacing:		10
*suggestForm.shadowThickness:	2
!
*suggestLabel.labelString:	Type the text of your suggestion.  Press "send" button to mail it, "cancel" to discard it.
*suggestLabel.topAttachment:	ATTACH_FORM
*suggestLabel.leftAttachment:	ATTACH_FORM
*suggestLabel.rightAttachment:	ATTACH_FORM
*suggestLabel.alignment:	ALIGNMENT_CENTER
!
*suggestSend.labelString:	Send
*suggestSend.leftAttachment:	ATTACH_FORM
*suggestSend.bottomAttachment:	ATTACH_FORM
!
*suggestClose.labelString:	Cancel
*suggestClose.rightAttachment:	ATTACH_FORM
*suggestClose.bottomAttachment:	ATTACH_FORM
!
*suggestSep.leftAttachment:	ATTACH_FORM
*suggestSep.rightAttachment:	ATTACH_FORM
*suggestSep.bottomAttachment:	ATTACH_WIDGET
*suggestSep.bottomWidget:	suggestClose
!
*suggestTextSW.topAttachment:	ATTACH_WIDGET
*suggestTextSW.topWidget:	suggestLabel
*suggestTextSW.leftAttachment:	ATTACH_FORM
*suggestTextSW.rightAttachment:	ATTACH_FORM
*suggestTextSW.bottomAttachment:ATTACH_WIDGET
*suggestTextSW.bottomWidget:	suggestSep
!
*suggestText.fontList:		fixed
*suggestText.scrollVertical:	TRUE
*suggestText.scrollHorizontal:	FALSE
*suggestText.editable:		TRUE
*suggestText.wordWrap:		TRUE
!
! INFO DIALOG
!
*infoDialog.width:		510
*infoDialog.height:		350
*infoDialog.Spacing:		10
*infoDialog.shadowThickness:	2
*infoDialog_popup.borderWidth:	2
*infoDialog_popup.name:		Olh Info
*infoDialog_popup.title:	Olh Info
!
*infoLabel.labelString:		Info on module "%s"
*infoLabel.topAttachment:	ATTACH_FORM
*infoLabel.leftAttachment:	ATTACH_FORM
*infoLabel.rightAttachment:	ATTACH_FORM
*infoLabel.alignment:		ALIGNMENT_CENTER
*infoLabel.recomputeSize:	False
!
!*infoClose.showAsDefault:	1
*infoClose.rightAttachment:	ATTACH_FORM
*infoClose.bottomAttachment:	ATTACH_FORM
*infoClose.labelString:		OK
*infoClose.accelerators:	#override  ~Meta <Key>Return: ArmAndActivate()
!
*infoSep.leftAttachment:	ATTACH_FORM
*infoSep.rightAttachment:	ATTACH_FORM
*infoSep.bottomAttachment:	ATTACH_WIDGET
*infoSep.bottomWidget:		infoClose
!
*infoTextSW.topAttachment:	ATTACH_WIDGET
*infoTextSW.topWidget:		infoLabel
*infoTextSW.leftAttachment:	ATTACH_FORM
*infoTextSW.rightAttachment:	ATTACH_FORM
*infoTextSW.bottomAttachment:	ATTACH_WIDGET
*infoTextSW.bottomWidget:	infoSep
!
*infoText.fontList:		fixed
*infoText.scrollVertical:	TRUE
*infoText.scrollHorizontal:	FALSE
*infoText.wordWrap:		TRUE
*infoText.value:		Information on the current module will go here.
!
! COPY DIALOG
!
!*copyDialog.height:		125
!*copyDialog.width:		400
*copyDialog.Spacing:		10
*copyDialog.shadowThickness:	2
*copyDialog_popup.borderWidth:	2
*copyDialog_popup.name:		Olh Copy
*copyDialog_popup.title:	Olh Copy
!
*copyLabel.labelString:		Copy module "%s" to:
*copyLabel.topAttachment:	ATTACH_FORM
*copyLabel.leftAttachment:	ATTACH_FORM
*copyLabel.rightAttachment:	ATTACH_FORM
*copyLabel.alignment:		ALIGNMENT_BEGINNING
!
*copyOK.labelString:		OK
*copyOK.leftAttachment:		ATTACH_FORM
*copyOK.bottomAttachment:	ATTACH_FORM
*copyOK.showAsDefault:		1
!
*copyClose.labelString:		Cancel
*copyClose.rightAttachment:	ATTACH_FORM
*copyClose.bottomAttachment:	ATTACH_FORM
!
*copySep.leftAttachment:	ATTACH_FORM
*copySep.rightAttachment:	ATTACH_FORM
*copySep.bottomAttachment:	ATTACH_WIDGET
*copySep.bottomWidget:		copyOK
!
*copyText.topAttachment:	ATTACH_WIDGET
*copyText.topWidget:		copyLabel
*copyText.leftAttachment:	ATTACH_FORM
*copyText.rightAttachment:	ATTACH_FORM
*copyText.bottomAttachment:	ATTACH_WIDGET
*copyText.bottomWidget:		copySep
*copyText.fontList:		fixed
*copyText.editable:		TRUE
*copyText.editMode:		SINGLE_LINE_EDIT
!
! KEYWORD DIALOG
!
*keywordDialog.geometry:	-0+30
*keywordDialog.title:		OLH Keyword Search
*keywordDialog.iconName:	OLH Keywords
*keywordDialog.width:		480
*keywordDialog.height:		400
*keywordDialog.borderWidth:	2
*keywordDialog*autoPopdown:	true
*keywordForm.Spacing:		5
*keywordForm.shadowThickness:	2
!
!*keywordName*fontList:		fixed
!*keywordName.topAttachment:	ATTACH_FORM
!*keywordName.leftAttachment:	ATTACH_FORM
!
!*keywordPulldown*fontList:	fixed
!*keywordPulldown.topAttachment: ATTACH_FORM
!*keywordPulldown.leftAttachment: ATTACH_FORM
!
*keywordMessage.leftAttachment:		ATTACH_FORM
*keywordMessage.bottomAttachment:	ATTACH_FORM
*keywordMessage.rightAttachment:	ATTACH_FORM
*keywordMessage.recomputeSize:		False
!
*keywordClose.labelString:	Cancel
*keywordClose.rightAttachment:	ATTACH_FORM
*keywordClose.bottomAttachment:	ATTACH_FORM
!
*keywordMessageSep.leftAttachment:	ATTACH_FORM
*keywordMessageSep.rightAttachment:	ATTACH_FORM
*keywordMessageSep.bottomAttachment:	ATTACH_WIDGET
*keywordMessageSep.bottomWidget:	keywordClose
!
*keywordSend.labelString:	Go to selected
*keywordSend.sensitive:		FALSE
*keywordSend.leftAttachment:	ATTACH_FORM
*keywordSend.bottomAttachment:	ATTACH_WIDGET
*keywordSend.bottomWidget:	keywordMessageSep
*keywordSend.accelerators:	#override \
				<Key>Return:	ArmAndActivate() \n\
				<Key>KP_Enter:	ArmAndActivate() \n\
				Ctrl<Key>m:	ArmAndActivate()
!
*keywordUp.labelString:		Step Up Menu
*keywordUp.sensitive:		FALSE
*keywordUp.rightAttachment:	ATTACH_FORM
*keywordUp.bottomAttachment:	ATTACH_WIDGET
*keywordUp.bottomWidget:	keywordMessageSep
*keywordUp.accelerators:	#override Meta <Key>U:	ArmAndActivate() \n\
				Meta <Key>Left:		ArmAndActivate()
!
*keywordEntryLabel.labelString:		Enter keyword or token id:
*keywordEntryLabel.leftAttachment:	ATTACH_FORM
*keywordEntryLabel.bottomAttachment:	ATTACH_WIDGET
*keywordEntryLabel.bottomWidget:	keywordSend
!
*keywordText.leftAttachment:	ATTACH_WIDGET
*keywordText.leftWidget:	keywordEntryLabel
*keywordText.rightAttachment:	ATTACH_FORM
*keywordText.bottomAttachment:	ATTACH_WIDGET
*keywordText.bottomWidget:	keywordSend
*keywordText.editable:		TRUE
*keywordText.editMode:		SINGLE_LINE_EDIT
*keywordText.fontList:		fixed
*keywordText.accelerators:	#override \
				<Key>Return:	activate() \n\
				<Key>KP_Enter:	activate() \n\
				Ctrl<Key>m:	activate()
!
*keywordListSW.topAttachment:	ATTACH_FORM
*keywordListSW.leftAttachment:	ATTACH_FORM
*keywordListSW.rightAttachment:	ATTACH_FORM
*keywordListSW.bottomAttachment:ATTACH_WIDGET
*keywordListSW.bottomWidget:	keywordText
!
!
! BOOKMARK DIALOG
!
*bookmarkDialog.width:		400
*bookmarkDialog.height:		200
*bookmarkDialog.Spacing:	10
!
*bookmarkLabel.labelString:	Bookmark Selection Box
*bookmarkLabel.topAttachment:	ATTACH_FORM
*bookmarkLabel.leftAttachment:	ATTACH_FORM
*bookmarkLabel.rightAttachment:	ATTACH_FORM
*bookmarkLabel.alignment:	ALIGNMENT_CENTER
!
*bookmarkSend.labelString:	Go to selected
*bookmarkSend.leftAttachment:	ATTACH_FORM
*bookmarkSend.bottomAttachment:	ATTACH_FORM
!
*bookmarkDelete.labelString:	Delete selected bookmark
*bookmarkDelete.leftAttachment:	ATTACH_WIDGET
*bookmarkDelete.leftWidget:	bookmarkSend
*bookmarkDelete.bottomAttachment:	ATTACH_FORM
!
*bookmarkClose.labelString:	Cancel
*bookmarkClose.rightAttachment:	ATTACH_FORM
*bookmarkClose.bottomAttachment:ATTACH_FORM
!
*bookmarkSW.topAttachment:	ATTACH_WIDGET
*bookmarkSW.topWidget:		bookmarkLabel
*bookmarkSW.leftAttachment:	ATTACH_FORM
*bookmarkSW.rightAttachment:	ATTACH_FORM
*bookmarkSW.bottomAttachment:	ATTACH_WIDGET
*bookmarkSW.bottomWidget:	bookmarkClose
!
!
! PRINT DIALOG
!
*printDialog.textColumns:	40
*printDialog*editable:		TRUE
*printDialog.listLabelString:	Print module "%s".\n\nSelect a printer below:
*printDialog.selectionLabelString:	or type in the name of a printer:
*printDialog.mustMatch:		FALSE
*printDialog.shadowThickness:	2
*printDialog_popup.borderWidth:	2
*printDialog_popup.name:	Olh Print
*printDialog_popup.title:	Olh Print
!
*bookmark.labelString:		Bookmark Search
!
*markTopic.labelString:		Mark Topic
*markTopic.mnemonic:		M
*markTopic.sensitive:		FALSE
!
!
*userBookmarks.labelString:	User Bookmarks
*userBookmarks.mnemonic:	U
!*userBookmarks.sensitive:	FALSE
*consultBookmarks.labelString:	Consultant Bookmarks
*consultBookmarks.mnemonic:	C
*consultBookmarks.sensitive:	FALSE
*otherBookmarks.labelString:	Other Bookmarks
*otherBookmarks.mnemonic:	O
*otherBookmarks.sensitive:	FALSE
!
!
*configure.labelString:		Configure OLH Setup
*configure.mnemonic:		C
!
*bookmarkHelp.labelString:	Bookmarks
*bookmarkHelp.mnemonic:		B
*addModuleHelp.labelString:	Adding your own modules
*addModuleHelp.mnemonic:	A
!*XmText.Translations:	#replace \
!			Shift<Key>Tab:		prev-tab-group() \n\
!			<Key>Tab:		next-tab-group() \n\
!			<Key>Delete:		delete-previous-character() \n\
!			Meta<Key>Delete:	kill-previous-word() \n\
!			Ctrl<Key>D:		delete-next-character() \n\
!			Meta<Key>D:		kill-next-word() \n\
!			Ctrl<Key>K:		kill-to-end-of-line() \n\
!			Ctrl<Key>W:		kill-selection() \n\
!			Ctrl<Key>Y:		unkill() \n\
!			Ctrl<Key>F:		forward-character() \n\
!			Ctrl<Key>B:		backward-character() \n\
!			Meta<Key>F:		forward-word() \n\
!			Meta<Key>B:		backward-word() \n\
!			Meta<Key>]:		forward-paragraph() \n\
!			Meta<Key>[:		backward-paragraph() \n\
!			Ctrl<Key>A:		beginning-of-line() \n\
!			Ctrl<Key>E:		end-of-line() \n\
!			Ctrl<Key>N:		next-line() \n\
!			Ctrl<Key>P:		previous-line() \n\
!			Ctrl<Key>V:		next-page() \n\
!			Meta<Key>V:		previous-page() \n\
!			Meta<Key><:		beginning-of-file() \n\
!			Meta Shift<Key><:	end-of-file() \n\
!			Meta<Key>>:		end-of-file() \n\
!			Ctrl<Key>L:		redraw-display() \n\
!			Ctrl<Key>M:		newline() \n\
!			Ctrl<Key>J:		newline() \n\
!			<Key>Return:		newline() \n\
!			~Ctrl <Key>:		self-insert() \n\
!			<Btn1Down>:		grab-focus() \n\
!			Button1<PtrMoved>:	extend-adjust() \n\
!			<Btn1Up>:		extend-end()
!*text.translations:	#replace \
!			Ctrl<Key>F:		forward-character() \n\
!			Ctrl<Key>B:		backward-character() \n\
!			Meta<Key>F:		forward-word() \n\
!			Meta<Key>B:		backward-word() \n\
!			Meta<Key>]:		forward-paragraph() \n\
!			Meta<Key>[:		backward-paragraph() \n\
!			Ctrl<Key>A:		beginning-of-line() \n\
!			Ctrl<Key>E:		end-of-line() \n\
!			Ctrl<Key>N:		next-line() \n\
!			Ctrl<Key>P:		previous-line() \n\
!			Ctrl<Key>V:		next-page() \n\
!			Meta<Key>V:		previous-page() \n\
!			Meta<Key><:		beginning-of-file() \n\
!			Meta<Key>>:		end-of-file() \n\
!			Ctrl<Key>L:		redraw-display() \n\
!			Ctrl<Key>M:		next-line() \n\
!			Ctrl<Key>J:		next-line() \n\
!			<Key>Return:		next-line() \n\
!			<Key>Delete:		previous-page() \n\
!			<Key>B:			previous-page() \n\
!			<Key>space:		next-page() \n\
!			<Btn1Down>:		grab-focus() \n\
!			Button1<PtrMoved>:	extend-adjust() \n\
!			<Btn1Up>:		extend-end()
*infoText.accelerators:	#replace \
			Ctrl<Key>F:		forward-character() \n\
			Ctrl<Key>B:		backward-character() \n\
			Meta<Key>F:		forward-word() \n\
			Meta<Key>B:		backward-word() \n\
			Meta<Key>]:		forward-paragraph() \n\
			Meta<Key>[:		backward-paragraph() \n\
			Ctrl<Key>A:		beginning-of-line() \n\
			Ctrl<Key>E:		end-of-line() \n\
			Ctrl<Key>N:		next-line() \n\
			Ctrl<Key>P:		previous-line() \n\
			Ctrl<Key>V:		next-page() \n\
			Meta<Key>V:		previous-page() \n\
			Meta<Key><:		beginning-of-file() \n\
			Meta<Key>>:		end-of-file() \n\
			Ctrl<Key>L:		redraw-display() \n\
			<Key>Delete:		previous-page() \n\
			<Key>B:			previous-page() \n\
			<Key>space:		next-page()
*XmCascadeButton.translations:	#replace \
				<Btn1Down>:	MenuBarSelect() \n\
				<Btn2Down>:	MenuBarSelect() \n\
				<Btn3Down>:	MenuBarSelect() \n\
				<Btn1Up>:	DoSelect() \n\
				<Btn2Up>:	DoSelect() \n\
				<Btn3Up>:	DoSelect() \n\
				<EnterWindow>:	MenuBarEnter() \n\
				<LeaveWindow>:	MenuBarLeave() \n\
				<Key>Return:	KeySelect() \n\
				<Key>Escape:	CleanupMenuBar()
*XmPushButton.translations:	#replace \
				<Btn1Down>:	Arm() \n\
				<Btn2Down>:	Arm() \n\
				<Btn3Down>:	Arm() \n\
				<Btn1Up>:	Activate() Disarm() \n\
				<Btn2Up>:	Activate() Disarm() \n\
				<Btn3Up>:	Activate() Disarm() \n\
				<Key>Return:	ArmAndActivate() \n\
				<Key>space:	ArmAndActivate() \n\
				<EnterWindow>:	Enter() \n\
				<LeaveWindow>:	Leave()
!
!  Motif managed to break the resource converter for translations.  If
!  you try to specify #augment or #override, Motif chooses to ignore these
!  and use #replace instead.  Therefore, I had to install everything all
!  over again myself.
!
!  The XmList translations below are only useful with traversal on.
!
*XmList.translations:	#replace \
			<Enter>:		ListEnter() \n\
			<Leave>:		ListLeave() \n\
			<FocusIn>:		ListFocusIn() \n\
			<FocusOut>:		ListFocusOut() \n\
			<Unmap>:		PrimitiveUnmap() \n\
			Shift<Key>Tab:		PrimitivePrevTabGroup() \n\
			<Key>Tab:		PrimitiveNextTabGroup() \n\
			<Key>Home:		PrimitiveTraverseHome() \n\
			Button1<Motion>:	ListButtonMotion() \n\
			<Btn1Down>:		ListBeginSelect() \n\
			<Btn1Up>:		ListEndSelect() \n\
			<Key>Up:		ListPrevItem() \n\
			<Key>Down:		ListNextItem()
!
*helpbox_popup.title:			OLH Help
*helpbox_popup.iconName:		OLH Help
*_MuModalDialogShell.title:		OLH Dialog
*_MuModalDialogShell.iconName:		OLH Dialog
*_MuModalDialogShell.shadowThickness:	2
*_MuModalDialogShell.borderWidth:	2
