/*
 * This file is part of the OLH On-Line Help system
 *
 *	Chris VanHaren
 *      MIT Project Athena
 *
 * Copyright (C) 1990 by the Massachusetts Institute of Technology.
 * For copying and distribution information, see the file "mit-copyright.h".
 *
 *      $Source: /mit/sipb-athena/src/olh/motif/RCS/Scroll.c,v $
 *      $Id: Scroll.c,v 1.4 96/03/19 12:19:42 warlord Exp $
 *      $Author: warlord $
 */

#include "global.h"

#include <X11/keysym.h>
#include <sys/param.h>

#ifndef MIN
#define MIN(x,y) (((x)<(y))?(x):(y))
#endif
#ifndef MAX
#define MAX(x,y) (((x)>(y))?(x):(y))
#endif

void
ScrollList(widget_num, ks, event)
     int widget_num;
     KeySym ks;
     XKeyEvent *event;
{
  Arg args[5];
  int pageIncrement, minimum, maximum, value, sliderSize, top, newValue;
  Widget W, scrollBar;

  W = XtParent(w[widget_num]);
  XtSetArg(args[0], XmNverticalScrollBar, &scrollBar);
  XtGetValues(W, args, 1);

  XtSetArg(args[0], XmNpageIncrement, &pageIncrement);
  XtSetArg(args[1], XmNminimum, &minimum);
  XtSetArg(args[2], XmNmaximum, &maximum);
  XtSetArg(args[3], XmNvalue, &value);
  XtSetArg(args[4], XmNsliderSize, &sliderSize);
  XtGetValues(scrollBar, args, 5);

  top = XmListGetTopPos((XmListWidget) w[widget_num]);

  if ((ks == XK_space) ||
      ((ks == XK_plus) || ((ks == XK_equal) &&
			   (event->state & (ShiftMask|LockMask)))))
    {
      newValue = MIN(value + pageIncrement, maximum - sliderSize);
      XtSetArg(args[0], XmNvalue, newValue);
      XtSetValues(scrollBar, args, 1);
      XmListSetPos(w[widget_num], top + newValue - value);
    }
  if ((ks == XK_minus) || (ks == XK_b) || (ks == XK_Delete))
    {
      newValue = MAX(value - pageIncrement, minimum);
      XtSetArg(args[0], XmNvalue, newValue);
      XtSetValues(scrollBar, args, 1);
      XmListSetPos(w[widget_num], top - value + newValue);
    }
}
